"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArduinoFrontendContribution = void 0;
const remote = require("@theia/core/electron-shared/@electron/remote");
const inversify_1 = require("@theia/core/shared/inversify");
const React = require("@theia/core/shared/react");
const core_1 = require("@theia/core");
const common_frontend_contribution_1 = require("@theia/core/lib/browser/common-frontend-contribution");
const common_1 = require("@theia/core/lib/common");
const command_1 = require("@theia/core/lib/common/command");
const message_service_1 = require("@theia/core/lib/common/message-service");
const browser_1 = require("@theia/editor/lib/browser");
const monaco_menu_1 = require("@theia/monaco/lib/browser/monaco-menu");
const navigator_contribution_1 = require("@theia/navigator/lib/browser/navigator-contribution");
const terminal_frontend_contribution_1 = require("@theia/terminal/lib/browser/terminal-frontend-contribution");
const arduino_preferences_1 = require("./arduino-preferences");
const boards_service_provider_1 = require("./boards/boards-service-provider");
const boards_toolbar_item_1 = require("./boards/boards-toolbar-item");
const arduino_menus_1 = require("./menu/arduino-menus");
const monitor_view_contribution_1 = require("./serial/monitor/monitor-view-contribution");
const arduino_toolbar_1 = require("./toolbar/arduino-toolbar");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const plotter_frontend_contribution_1 = require("./serial/plotter/plotter-frontend-contribution");
let ArduinoFrontendContribution = class ArduinoFrontendContribution {
    async init() {
        if (!window.navigator.onLine) {
            // tslint:disable-next-line:max-line-length
            this.messageService.warn(common_1.nls.localize('arduino/common/offlineIndicator', 'You appear to be offline. Without an Internet connection, the Arduino CLI might not be able to download the required resources and could cause malfunction. Please connect to the Internet and restart the application.'));
        }
    }
    onStart(app) {
        this.arduinoPreferences.onPreferenceChanged((event) => {
            if (event.newValue !== event.oldValue) {
                switch (event.preferenceName) {
                    case 'arduino.window.zoomLevel':
                        if (typeof event.newValue === 'number') {
                            const webContents = remote.getCurrentWebContents();
                            webContents.setZoomLevel(event.newValue || 0);
                        }
                        break;
                }
            }
        });
        this.appStateService.reachedState('ready').then(() => this.arduinoPreferences.ready.then(() => {
            const webContents = remote.getCurrentWebContents();
            const zoomLevel = this.arduinoPreferences.get('arduino.window.zoomLevel');
            webContents.setZoomLevel(zoomLevel);
        }));
        // Removes the _Settings_ (cog) icon from the left sidebar
        app.shell.leftPanelHandler.removeBottomMenu('settings-menu');
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: boards_toolbar_item_1.BoardsToolBarItem.TOOLBAR_ID,
            render: () => (React.createElement(boards_toolbar_item_1.BoardsToolBarItem, { key: "boardsToolbarItem", commands: this.commandRegistry, boardsServiceProvider: this.boardsServiceProvider })),
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            priority: 7,
        });
        registry.registerItem({
            id: 'toggle-serial-plotter',
            command: plotter_frontend_contribution_1.SerialPlotterContribution.Commands.OPEN_TOOLBAR.id,
            tooltip: common_1.nls.localize('arduino/serial/openSerialPlotter', 'Serial Plotter'),
        });
        registry.registerItem({
            id: 'toggle-serial-monitor',
            command: monitor_view_contribution_1.MonitorViewContribution.TOGGLE_SERIAL_MONITOR_TOOLBAR,
            tooltip: common_1.nls.localize('arduino/common/serialMonitor', 'Serial Monitor'),
        });
    }
    registerCommands(registry) {
        for (const command of [
            browser_1.EditorCommands.SPLIT_EDITOR_DOWN,
            browser_1.EditorCommands.SPLIT_EDITOR_LEFT,
            browser_1.EditorCommands.SPLIT_EDITOR_RIGHT,
            browser_1.EditorCommands.SPLIT_EDITOR_UP,
            browser_1.EditorCommands.SPLIT_EDITOR_VERTICAL,
            browser_1.EditorCommands.SPLIT_EDITOR_HORIZONTAL,
            navigator_contribution_1.FileNavigatorCommands.REVEAL_IN_NAVIGATOR,
        ]) {
            registry.unregisterCommand(command);
        }
    }
    registerMenus(registry) {
        const menuId = (menuPath) => {
            const index = menuPath.length - 1;
            const menuId = menuPath[index];
            return menuId;
        };
        registry.getMenu(core_1.MAIN_MENU_BAR).removeNode(menuId(monaco_menu_1.MonacoMenus.SELECTION));
        registry.getMenu(core_1.MAIN_MENU_BAR).removeNode(menuId(browser_1.EditorMainMenu.GO));
        registry.getMenu(core_1.MAIN_MENU_BAR).removeNode(menuId(terminal_frontend_contribution_1.TerminalMenus.TERMINAL));
        registry.getMenu(core_1.MAIN_MENU_BAR).removeNode(menuId(common_frontend_contribution_1.CommonMenus.VIEW));
        registry.registerSubmenu(arduino_menus_1.ArduinoMenus.SKETCH, common_1.nls.localize('arduino/menu/sketch', 'Sketch'));
        registry.registerSubmenu(arduino_menus_1.ArduinoMenus.TOOLS, common_1.nls.localize('arduino/menu/tools', 'Tools'));
    }
    registerColors(colors) {
        colors.register({
            id: 'arduino.toolbar.button.background',
            defaults: {
                dark: 'button.background',
                light: 'button.background',
                hc: 'activityBar.inactiveForeground',
            },
            description: 'Background color of the toolbar items. Such as Upload, Verify, etc.',
        }, {
            id: 'arduino.toolbar.button.hoverBackground',
            defaults: {
                dark: 'button.hoverBackground',
                light: 'button.hoverBackground',
                hc: 'button.background',
            },
            description: 'Background color of the toolbar items when hovering over them. Such as Upload, Verify, etc.',
        }, {
            id: 'arduino.toolbar.button.secondary.label',
            defaults: {
                dark: 'secondaryButton.foreground',
                light: 'button.foreground',
                hc: 'activityBar.inactiveForeground',
            },
            description: 'Foreground color of the toolbar items. Such as Serial Monitor and Serial Plotter',
        }, {
            id: 'arduino.toolbar.button.secondary.hoverBackground',
            defaults: {
                dark: 'secondaryButton.hoverBackground',
                light: 'button.hoverBackground',
                hc: 'textLink.foreground',
            },
            description: 'Background color of the toolbar items when hovering over them, such as "Serial Monitor" and "Serial Plotter"',
        }, {
            id: 'arduino.toolbar.toggleBackground',
            defaults: {
                dark: 'editor.selectionBackground',
                light: 'editor.selectionBackground',
                hc: 'textPreformat.foreground',
            },
            description: 'Toggle color of the toolbar items when they are currently toggled (the command is in progress)',
        }, {
            id: 'arduino.toolbar.dropdown.border',
            defaults: {
                dark: 'dropdown.border',
                light: 'dropdown.border',
                hc: 'dropdown.border',
            },
            description: 'Border color of the Board Selector.',
        }, {
            id: 'arduino.toolbar.dropdown.borderActive',
            defaults: {
                dark: 'focusBorder',
                light: 'focusBorder',
                hc: 'focusBorder',
            },
            description: "Border color of the Board Selector when it's active",
        }, {
            id: 'arduino.toolbar.dropdown.background',
            defaults: {
                dark: 'tab.unfocusedActiveBackground',
                light: 'dropdown.background',
                hc: 'dropdown.background',
            },
            description: 'Background color of the Board Selector.',
        }, {
            id: 'arduino.toolbar.dropdown.label',
            defaults: {
                dark: 'dropdown.foreground',
                light: 'dropdown.foreground',
                hc: 'dropdown.foreground',
            },
            description: 'Font color of the Board Selector.',
        }, {
            id: 'arduino.toolbar.dropdown.iconSelected',
            defaults: {
                dark: 'list.activeSelectionIconForeground',
                light: 'list.activeSelectionIconForeground',
                hc: 'list.activeSelectionIconForeground',
            },
            description: 'Color of the selected protocol icon in the Board Selector.',
        }, {
            id: 'arduino.toolbar.dropdown.option.backgroundHover',
            defaults: {
                dark: 'list.hoverBackground',
                light: 'list.hoverBackground',
                hc: 'list.hoverBackground',
            },
            description: 'Background color on hover of the Board Selector options.',
        }, {
            id: 'arduino.toolbar.dropdown.option.backgroundSelected',
            defaults: {
                dark: 'list.activeSelectionBackground',
                light: 'list.activeSelectionBackground',
                hc: 'list.activeSelectionBackground',
            },
            description: 'Background color of the selected board in the Board Selector.',
        });
    }
};
__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], ArduinoFrontendContribution.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], ArduinoFrontendContribution.prototype, "boardsServiceProvider", void 0);
__decorate([
    (0, inversify_1.inject)(command_1.CommandRegistry),
    __metadata("design:type", command_1.CommandRegistry)
], ArduinoFrontendContribution.prototype, "commandRegistry", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "arduinoPreferences", void 0);
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], ArduinoFrontendContribution.prototype, "appStateService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ArduinoFrontendContribution.prototype, "init", null);
ArduinoFrontendContribution = __decorate([
    (0, inversify_1.injectable)()
], ArduinoFrontendContribution);
exports.ArduinoFrontendContribution = ArduinoFrontendContribution;
//# sourceMappingURL=arduino-frontend-contribution.js.map