"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../src/browser/style/index.css");
const inversify_1 = require("@theia/core/shared/inversify");
const widget_manager_1 = require("@theia/core/lib/browser/widget-manager");
const command_1 = require("@theia/core/lib/common/command");
const view_contribution_1 = require("@theia/core/lib/browser/shell/view-contribution");
const tab_bar_toolbar_1 = require("@theia/core/lib/browser/shell/tab-bar-toolbar");
const ws_connection_provider_1 = require("@theia/core/lib/browser/messaging/ws-connection-provider");
const frontend_application_1 = require("@theia/core/lib/browser/frontend-application");
const library_list_widget_1 = require("./library/library-list-widget");
const arduino_frontend_contribution_1 = require("./arduino-frontend-contribution");
const library_service_1 = require("../common/protocol/library-service");
const boards_service_1 = require("../common/protocol/boards-service");
const sketches_service_1 = require("../common/protocol/sketches-service");
const sketches_service_client_impl_1 = require("../common/protocol/sketches-service-client-impl");
const core_service_1 = require("../common/protocol/core-service");
const boards_list_widget_1 = require("./boards/boards-list-widget");
const boards_widget_frontend_contribution_1 = require("./boards/boards-widget-frontend-contribution");
const boards_service_provider_1 = require("./boards/boards-service-provider");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const workspace_service_2 = require("./theia/workspace/workspace-service");
const outline_view_contribution_1 = require("@theia/outline-view/lib/browser/outline-view-contribution");
const outline_contribution_1 = require("./theia/outline/outline-contribution");
const problem_contribution_1 = require("@theia/markers/lib/browser/problem/problem-contribution");
const problem_contribution_2 = require("./theia/markers/problem-contribution");
const navigator_contribution_1 = require("./theia/navigator/navigator-contribution");
const navigator_contribution_2 = require("@theia/navigator/lib/browser/navigator-contribution");
const keymaps_frontend_contribution_1 = require("./theia/keymaps/keymaps-frontend-contribution");
const keymaps_frontend_contribution_2 = require("@theia/keymaps/lib/browser/keymaps-frontend-contribution");
const arduino_toolbar_contribution_1 = require("./toolbar/arduino-toolbar-contribution");
const editor_contribution_1 = require("@theia/editor/lib/browser/editor-contribution");
const editor_contribution_2 = require("./theia/editor/editor-contribution");
const monaco_status_bar_contribution_1 = require("@theia/monaco/lib/browser/monaco-status-bar-contribution");
const monaco_status_bar_contribution_2 = require("./theia/monaco/monaco-status-bar-contribution");
const browser_1 = require("@theia/core/lib/browser");
const menu_1 = require("@theia/core/lib/common/menu");
const application_shell_1 = require("./theia/core/application-shell");
const frontend_application_2 = require("./theia/core/frontend-application");
const boards_config_dialog_1 = require("./boards/boards-config-dialog");
const boards_config_dialog_widget_1 = require("./boards/boards-config-dialog-widget");
const scm_contribution_1 = require("@theia/scm/lib/browser/scm-contribution");
const scm_contribution_2 = require("./theia/scm/scm-contribution");
const search_in_workspace_frontend_contribution_1 = require("@theia/search-in-workspace/lib/browser/search-in-workspace-frontend-contribution");
const search_in_workspace_frontend_contribution_2 = require("./theia/search-in-workspace/search-in-workspace-frontend-contribution");
const library_widget_frontend_contribution_1 = require("./library/library-widget-frontend-contribution");
const config_service_1 = require("../common/protocol/config-service");
const monitor_widget_1 = require("./serial/monitor/monitor-widget");
const monitor_view_contribution_1 = require("./serial/monitor/monitor-view-contribution");
const tab_bar_decorator_1 = require("@theia/core/lib/browser/shell/tab-bar-decorator");
const tab_bar_decorator_2 = require("./theia/core/tab-bar-decorator");
const browser_2 = require("@theia/markers/lib/browser");
const problem_manager_1 = require("./theia/markers/problem-manager");
const boards_auto_installer_1 = require("./boards/boards-auto-installer");
const shell_layout_restorer_1 = require("./theia/core/shell-layout-restorer");
const list_item_renderer_1 = require("./widgets/component-list/list-item-renderer");
const color_application_contribution_1 = require("@theia/core/lib/browser/color-application-contribution");
const monaco_theming_service_1 = require("@theia/monaco/lib/browser/monaco-theming-service");
const arduino_daemon_1 = require("../common/protocol/arduino-daemon");
const browser_3 = require("@theia/editor/lib/browser");
const connection_status_service_1 = require("./theia/core/connection-status-service");
const connection_status_service_2 = require("@theia/core/lib/browser/connection-status-service");
const boards_data_menu_updater_1 = require("./boards/boards-data-menu-updater");
const boards_data_store_1 = require("./boards/boards-data-store");
const core_1 = require("@theia/core");
const filesystem_ext_1 = require("../common/protocol/filesystem-ext");
const browser_4 = require("@theia/workspace/lib/browser");
const workspace_frontend_contribution_1 = require("./theia/workspace/workspace-frontend-contribution");
const contribution_1 = require("./contributions/contribution");
const new_sketch_1 = require("./contributions/new-sketch");
const open_sketch_1 = require("./contributions/open-sketch");
const close_1 = require("./contributions/close");
const save_as_sketch_1 = require("./contributions/save-as-sketch");
const save_sketch_1 = require("./contributions/save-sketch");
const verify_sketch_1 = require("./contributions/verify-sketch");
const upload_sketch_1 = require("./contributions/upload-sketch");
const common_frontend_contribution_1 = require("./theia/core/common-frontend-contribution");
const edit_contributions_1 = require("./contributions/edit-contributions");
const open_sketch_external_1 = require("./contributions/open-sketch-external");
const preferences_contribution_1 = require("@theia/preferences/lib/browser/preferences-contribution");
const preferences_contribution_2 = require("./theia/preferences/preferences-contribution");
const quit_app_1 = require("./contributions/quit-app");
const sketch_control_1 = require("./contributions/sketch-control");
const settings_1 = require("./contributions/settings");
const workspace_commands_1 = require("./theia/workspace/workspace-commands");
const workspace_delete_handler_1 = require("@theia/workspace/lib/browser/workspace-delete-handler");
const workspace_delete_handler_2 = require("./theia/workspace/workspace-delete-handler");
const tab_bar_toolbar_2 = require("./theia/core/tab-bar-toolbar");
const editor_widget_factory_1 = require("@theia/editor/lib/browser/editor-widget-factory");
const editor_widget_factory_2 = require("./theia/editor/editor-widget-factory");
const burn_bootloader_1 = require("./contributions/burn-bootloader");
const examples_service_1 = require("../common/protocol/examples-service");
const examples_1 = require("./contributions/examples");
const include_library_1 = require("./contributions/include-library");
const output_channel_1 = require("@theia/output/lib/browser/output-channel");
const output_channel_2 = require("./theia/output/output-channel");
const output_channel_registry_main_1 = require("./theia/plugin-ext/output-channel-registry-main");
const protocol_1 = require("../common/protocol");
const monaco_text_model_service_1 = require("@theia/monaco/lib/browser/monaco-text-model-service");
const monaco_text_model_service_2 = require("./theia/monaco/monaco-text-model-service");
const response_service_impl_1 = require("./response-service-impl");
const response_service_1 = require("../common/protocol/response-service");
const notification_center_1 = require("./notification-center");
const protocol_2 = require("../common/protocol");
const about_1 = require("./contributions/about");
const icon_theme_service_1 = require("@theia/core/lib/browser/icon-theme-service");
const tab_bars_1 = require("./theia/core/tab-bars");
const editor_command_1 = require("./theia/editor/editor-command");
const navigator_tab_bar_decorator_1 = require("@theia/navigator/lib/browser/navigator-tab-bar-decorator");
const navigator_tab_bar_decorator_2 = require("./theia/navigator/navigator-tab-bar-decorator");
const debug_1 = require("./contributions/debug");
const debug_session_manager_1 = require("./theia/debug/debug-session-manager");
const debug_session_manager_2 = require("@theia/debug/lib/browser/debug-session-manager");
const sketchbook_1 = require("./contributions/sketchbook");
const debug_frontend_application_contribution_1 = require("./theia/debug/debug-frontend-application-contribution");
const debug_frontend_application_contribution_2 = require("@theia/debug/lib/browser/debug-frontend-application-contribution");
const board_selection_1 = require("./contributions/board-selection");
const open_recent_sketch_1 = require("./contributions/open-recent-sketch");
const help_1 = require("./contributions/help");
const arduino_preferences_1 = require("./arduino-preferences");
const settings_2 = require("./dialogs/settings/settings");
const settings_dialog_1 = require("./dialogs/settings/settings-dialog");
const add_file_1 = require("./contributions/add-file");
const archive_sketch_1 = require("./contributions/archive-sketch");
const output_toolbar_contribution_1 = require("@theia/output/lib/browser/output-toolbar-contribution");
const output_toolbar_contribution_2 = require("./theia/output/output-toolbar-contribution");
const add_zip_library_1 = require("./contributions/add-zip-library");
const workspace_variable_contribution_1 = require("@theia/workspace/lib/browser/workspace-variable-contribution");
const workspace_variable_contribution_2 = require("./theia/workspace/workspace-variable-contribution");
const debug_configuration_manager_1 = require("./theia/debug/debug-configuration-manager");
const debug_configuration_manager_2 = require("@theia/debug/lib/browser/debug-configuration-manager");
const search_in_workspace_widget_1 = require("@theia/search-in-workspace/lib/browser/search-in-workspace-widget");
const search_in_workspace_widget_2 = require("./theia/search-in-workspace/search-in-workspace-widget");
const search_in_workspace_factory_1 = require("@theia/search-in-workspace/lib/browser/search-in-workspace-factory");
const search_in_workspace_factory_2 = require("./theia/search-in-workspace/search-in-workspace-factory");
const search_in_workspace_result_tree_widget_1 = require("@theia/search-in-workspace/lib/browser/search-in-workspace-result-tree-widget");
const search_in_workspace_result_tree_widget_2 = require("./theia/search-in-workspace/search-in-workspace-result-tree-widget");
const monaco_editor_provider_1 = require("./theia/monaco/monaco-editor-provider");
const monaco_editor_provider_2 = require("@theia/monaco/lib/browser/monaco-editor-provider");
const storage_wrapper_1 = require("./storage-wrapper");
const notifications_manager_1 = require("./theia/messages/notifications-manager");
const notifications_manager_2 = require("@theia/messages/lib/browser/notifications-manager");
const notifications_renderer_1 = require("@theia/messages/lib/browser/notifications-renderer");
const notifications_renderer_2 = require("./theia/messages/notifications-renderer");
const sketchbook_widget_contribution_1 = require("./widgets/sketchbook/sketchbook-widget-contribution");
const local_cache_fs_provider_1 = require("./local-cache/local-cache-fs-provider");
const cloud_sketchbook_widget_1 = require("./widgets/cloud-sketchbook/cloud-sketchbook-widget");
const cloud_sketchbook_tree_widget_1 = require("./widgets/cloud-sketchbook/cloud-sketchbook-tree-widget");
const cloud_sketchbook_tree_container_1 = require("./widgets/cloud-sketchbook/cloud-sketchbook-tree-container");
const create_api_1 = require("./create/create-api");
const cloud_share_sketch_dialog_1 = require("./dialogs/cloud-share-sketch-dialog");
const authentication_client_service_1 = require("./auth/authentication-client-service");
const authentication_service_1 = require("../common/protocol/authentication-service");
const create_fs_provider_1 = require("./create/create-fs-provider");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const cloud_sketchbook_contributions_1 = require("./widgets/cloud-sketchbook/cloud-sketchbook-contributions");
const cloud_sketchbook_composite_widget_1 = require("./widgets/cloud-sketchbook/cloud-sketchbook-composite-widget");
const sketchbook_widget_1 = require("./widgets/sketchbook/sketchbook-widget");
const sketchbook_tree_widget_1 = require("./widgets/sketchbook/sketchbook-tree-widget");
const sketchbook_tree_container_1 = require("./widgets/sketchbook/sketchbook-tree-container");
const cloud_sketch_cache_1 = require("./widgets/cloud-sketchbook/cloud-sketch-cache");
const upload_firmware_1 = require("./contributions/upload-firmware");
const firmware_uploader_dialog_1 = require("./dialogs/firmware-uploader/firmware-uploader-dialog");
const upload_certificate_1 = require("./contributions/upload-certificate");
const arduino_firmware_uploader_1 = require("../common/protocol/arduino-firmware-uploader");
const certificate_uploader_dialog_1 = require("./dialogs/certificate-uploader/certificate-uploader-dialog");
const plotter_frontend_contribution_1 = require("./serial/plotter/plotter-frontend-contribution");
const user_fields_dialog_1 = require("./dialogs/user-fields/user-fields-dialog");
const common_1 = require("@theia/core/lib/common");
const ide_updater_commands_1 = require("./ide-updater/ide-updater-commands");
const ide_updater_1 = require("../common/protocol/ide-updater");
const ide_updater_client_impl_1 = require("./ide-updater/ide-updater-client-impl");
const ide_updater_dialog_1 = require("./dialogs/ide-updater/ide-updater-dialog");
const electron_ipc_connection_provider_1 = require("@theia/core/lib/electron-browser/messaging/electron-ipc-connection-provider");
const monitor_model_1 = require("./monitor-model");
const monitor_manager_proxy_client_impl_1 = require("./monitor-manager-proxy-client-impl");
const editor_manager_1 = require("@theia/editor/lib/browser/editor-manager");
const editor_manager_2 = require("./theia/editor/editor-manager");
const hosted_plugin_events_1 = require("./hosted-plugin-events");
const hosted_plugin_1 = require("./theia/plugin-ext/hosted-plugin");
const hosted_plugin_2 = require("@theia/plugin-ext/lib/hosted/browser/hosted-plugin");
const formatter_1 = require("../common/protocol/formatter");
const format_1 = require("./contributions/format");
const monaco_formatting_conflicts_1 = require("./theia/monaco/monaco-formatting-conflicts");
const monaco_formatting_conflicts_2 = require("@theia/monaco/lib/browser/monaco-formatting-conflicts");
const json_schema_store_1 = require("./theia/core/json-schema-store");
const json_schema_store_2 = require("@theia/core/lib/browser/json-schema-store");
const editor_navigation_contribution_1 = require("./theia/editor/editor-navigation-contribution");
const editor_navigation_contribution_2 = require("@theia/editor/lib/browser/editor-navigation-contribution");
const preference_tree_generator_1 = require("./theia/preferences/preference-tree-generator");
const preference_tree_generator_2 = require("@theia/preferences/lib/browser/util/preference-tree-generator");
const about_dialog_1 = require("./theia/core/about-dialog");
const about_dialog_2 = require("@theia/core/lib/browser/about-dialog");
const survey_service_1 = require("../common/protocol/survey-service");
const window_contribution_1 = require("./theia/core/window-contribution");
const window_contribution_2 = require("@theia/core/lib/browser/window-contribution");
const core_error_handler_1 = require("./contributions/core-error-handler");
const compiler_errors_1 = require("./contributions/compiler-errors");
const widget_manager_2 = require("./theia/core/widget-manager");
const widget_manager_3 = require("@theia/core/lib/browser/widget-manager");
const startup_task_1 = require("./widgets/sketchbook/startup-task");
const indexes_update_progress_1 = require("./contributions/indexes-update-progress");
const daemon_1 = require("./contributions/daemon");
const first_startup_installer_1 = require("./contributions/first-startup-installer");
const open_sketch_files_1 = require("./contributions/open-sketch-files");
const ino_language_1 = require("./contributions/ino-language");
const selected_board_1 = require("./contributions/selected-board");
const check_for_ide_updates_1 = require("./contributions/check-for-ide-updates");
const open_boards_config_1 = require("./contributions/open-boards-config");
const sketch_files_tracker_1 = require("./contributions/sketch-files-tracker");
const window_1 = require("./utils/window");
const status_bar_1 = require("./theia/core/status-bar");
const browser_5 = require("@theia/core/lib/browser");
const editor_file_1 = require("./theia/editor/editor-file");
const editor_menu_1 = require("@theia/editor/lib/browser/editor-menu");
const preference_editor_widget_1 = require("@theia/preferences/lib/browser/views/preference-editor-widget");
const preference_editor_widget_2 = require("./theia/preferences/preference-editor-widget");
const preference_widget_1 = require("@theia/preferences/lib/browser/views/preference-widget");
const preference_widget_bindings_1 = require("@theia/preferences/lib/browser/views/preference-widget-bindings");
const filter_renderer_1 = require("./widgets/component-list/filter-renderer");
const check_for_updates_1 = require("./contributions/check-for-updates");
const output_editor_factory_1 = require("./theia/output/output-editor-factory");
const registerArduinoThemes = () => {
    const themes = [
        {
            id: 'arduino-theme',
            label: 'Light (Arduino)',
            uiTheme: 'vs',
            json: require('../../src/browser/data/default.color-theme.json'),
        },
        {
            id: 'arduino-theme-dark',
            label: 'Dark (Arduino)',
            uiTheme: 'vs-dark',
            json: require('../../src/browser/data/dark.color-theme.json'),
        },
    ];
    themes.forEach((theme) => monaco_theming_service_1.MonacoThemingService.register(theme));
};
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const global = window;
const ready = global[window_1.MonacoThemeServiceIsReady];
if (ready) {
    ready.promise.then(registerArduinoThemes);
}
else {
    registerArduinoThemes();
}
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    // Commands and toolbar items
    bind(arduino_frontend_contribution_1.ArduinoFrontendContribution).toSelf().inSingletonScope();
    bind(command_1.CommandContribution).toService(arduino_frontend_contribution_1.ArduinoFrontendContribution);
    bind(menu_1.MenuContribution).toService(arduino_frontend_contribution_1.ArduinoFrontendContribution);
    bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(arduino_frontend_contribution_1.ArduinoFrontendContribution);
    bind(frontend_application_1.FrontendApplicationContribution).toService(arduino_frontend_contribution_1.ArduinoFrontendContribution);
    bind(color_application_contribution_1.ColorContribution).toService(arduino_frontend_contribution_1.ArduinoFrontendContribution);
    bind(arduino_toolbar_contribution_1.ArduinoToolbarContribution).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(arduino_toolbar_contribution_1.ArduinoToolbarContribution);
    // Renderer for both the library and the core widgets.
    bind(list_item_renderer_1.ListItemRenderer).toSelf().inSingletonScope();
    bind(filter_renderer_1.LibraryFilterRenderer).toSelf().inSingletonScope();
    bind(filter_renderer_1.BoardsFilterRenderer).toSelf().inSingletonScope();
    // Library service
    bind(library_service_1.LibraryService)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, library_service_1.LibraryServicePath))
        .inSingletonScope();
    // Library list widget
    bind(library_list_widget_1.LibraryListWidget).toSelf();
    (0, view_contribution_1.bindViewContribution)(bind, library_widget_frontend_contribution_1.LibraryListWidgetFrontendContribution);
    bind(widget_manager_1.WidgetFactory).toDynamicValue((context) => ({
        id: library_list_widget_1.LibraryListWidget.WIDGET_ID,
        createWidget: () => context.container.get(library_list_widget_1.LibraryListWidget),
    }));
    bind(frontend_application_1.FrontendApplicationContribution).toService(library_widget_frontend_contribution_1.LibraryListWidgetFrontendContribution);
    // Sketch list service
    bind(sketches_service_1.SketchesService)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, sketches_service_1.SketchesServicePath))
        .inSingletonScope();
    bind(sketches_service_client_impl_1.SketchesServiceClientImpl).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(sketches_service_client_impl_1.SketchesServiceClientImpl);
    // Config service
    bind(config_service_1.ConfigService)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, config_service_1.ConfigServicePath))
        .inSingletonScope();
    // Boards service
    bind(boards_service_1.BoardsService)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, boards_service_1.BoardsServicePath))
        .inSingletonScope();
    // Boards service client to receive and delegate notifications from the backend.
    bind(boards_service_provider_1.BoardsServiceProvider).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(boards_service_provider_1.BoardsServiceProvider);
    // To be able to track, and update the menu based on the core settings (aka. board details) of the currently selected board.
    bind(frontend_application_1.FrontendApplicationContribution)
        .to(boards_data_menu_updater_1.BoardsDataMenuUpdater)
        .inSingletonScope();
    bind(boards_data_store_1.BoardsDataStore).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(boards_data_store_1.BoardsDataStore);
    // Logger for the Arduino daemon
    bind(core_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(core_1.ILogger);
        return parentLogger.child('store');
    })
        .inSingletonScope()
        .whenTargetNamed('store');
    // Boards auto-installer
    bind(boards_auto_installer_1.BoardsAutoInstaller).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(boards_auto_installer_1.BoardsAutoInstaller);
    // Boards list widget
    bind(boards_list_widget_1.BoardsListWidget).toSelf();
    (0, view_contribution_1.bindViewContribution)(bind, boards_widget_frontend_contribution_1.BoardsListWidgetFrontendContribution);
    bind(widget_manager_1.WidgetFactory).toDynamicValue((context) => ({
        id: boards_list_widget_1.BoardsListWidget.WIDGET_ID,
        createWidget: () => context.container.get(boards_list_widget_1.BoardsListWidget),
    }));
    bind(frontend_application_1.FrontendApplicationContribution).toService(boards_widget_frontend_contribution_1.BoardsListWidgetFrontendContribution);
    // Board select dialog
    bind(boards_config_dialog_widget_1.BoardsConfigDialogWidget).toSelf().inSingletonScope();
    bind(boards_config_dialog_1.BoardsConfigDialog).toSelf().inSingletonScope();
    bind(boards_config_dialog_1.BoardsConfigDialogProps).toConstantValue({
        title: common_1.nls.localize('arduino/board/boardConfigDialogTitle', 'Select Other Board and Port'),
    });
    // Core service
    bind(core_service_1.CoreService)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, core_service_1.CoreServicePath))
        .inSingletonScope();
    bind(core_error_handler_1.CoreErrorHandler).toSelf().inSingletonScope();
    // Serial monitor
    bind(monitor_widget_1.MonitorWidget).toSelf();
    bind(frontend_application_1.FrontendApplicationContribution).toService(monitor_model_1.MonitorModel);
    bind(monitor_model_1.MonitorModel).toSelf().inSingletonScope();
    (0, view_contribution_1.bindViewContribution)(bind, monitor_view_contribution_1.MonitorViewContribution);
    bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(monitor_view_contribution_1.MonitorViewContribution);
    bind(widget_manager_1.WidgetFactory).toDynamicValue((context) => ({
        id: monitor_widget_1.MonitorWidget.ID,
        createWidget: () => {
            return new monitor_widget_1.MonitorWidget(context.container.get(monitor_model_1.MonitorModel), context.container.get(protocol_1.MonitorManagerProxyClient), context.container.get(boards_service_provider_1.BoardsServiceProvider));
        },
    }));
    bind(protocol_1.MonitorManagerProxyFactory).toFactory((context) => () => context.container.get(protocol_1.MonitorManagerProxy));
    bind(protocol_1.MonitorManagerProxy)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, protocol_1.MonitorManagerProxyPath, context.container.get(protocol_1.MonitorManagerProxyClient)))
        .inSingletonScope();
    // Monitor manager proxy client to receive and delegate pluggable monitors
    // notifications from the backend
    bind(protocol_1.MonitorManagerProxyClient)
        .to(monitor_manager_proxy_client_impl_1.MonitorManagerProxyClientImpl)
        .inSingletonScope();
    bind(workspace_service_2.WorkspaceService).toSelf().inSingletonScope();
    rebind(workspace_service_1.WorkspaceService).toService(workspace_service_2.WorkspaceService);
    bind(workspace_variable_contribution_2.WorkspaceVariableContribution).toSelf().inSingletonScope();
    rebind(workspace_variable_contribution_1.WorkspaceVariableContribution).toService(workspace_variable_contribution_2.WorkspaceVariableContribution);
    bind(survey_service_1.SurveyNotificationService)
        .toDynamicValue((context) => {
        return electron_ipc_connection_provider_1.ElectronIpcConnectionProvider.createProxy(context.container, survey_service_1.SurveyNotificationServicePath);
    })
        .inSingletonScope();
    // Layout and shell customizations.
    rebind(outline_view_contribution_1.OutlineViewContribution)
        .to(outline_contribution_1.OutlineViewContribution)
        .inSingletonScope();
    rebind(problem_contribution_1.ProblemContribution).to(problem_contribution_2.ProblemContribution).inSingletonScope();
    rebind(navigator_contribution_2.FileNavigatorContribution)
        .to(navigator_contribution_1.FileNavigatorContribution)
        .inSingletonScope();
    rebind(keymaps_frontend_contribution_2.KeymapsFrontendContribution)
        .to(keymaps_frontend_contribution_1.KeymapsFrontendContribution)
        .inSingletonScope();
    rebind(editor_contribution_1.EditorContribution).to(editor_contribution_2.EditorContribution).inSingletonScope();
    rebind(monaco_status_bar_contribution_1.MonacoStatusBarContribution)
        .to(monaco_status_bar_contribution_2.MonacoStatusBarContribution)
        .inSingletonScope();
    rebind(browser_1.ApplicationShell).to(application_shell_1.ApplicationShell).inSingletonScope();
    rebind(scm_contribution_1.ScmContribution).to(scm_contribution_2.ScmContribution).inSingletonScope();
    rebind(search_in_workspace_frontend_contribution_1.SearchInWorkspaceFrontendContribution)
        .to(search_in_workspace_frontend_contribution_2.SearchInWorkspaceFrontendContribution)
        .inSingletonScope();
    rebind(frontend_application_1.FrontendApplication).to(frontend_application_2.FrontendApplication).inSingletonScope();
    rebind(browser_4.WorkspaceFrontendContribution)
        .to(workspace_frontend_contribution_1.WorkspaceFrontendContribution)
        .inSingletonScope();
    rebind(browser_4.FileMenuContribution)
        .to(workspace_frontend_contribution_1.ArduinoFileMenuContribution)
        .inSingletonScope();
    rebind(browser_1.CommonFrontendContribution)
        .to(common_frontend_contribution_1.CommonFrontendContribution)
        .inSingletonScope();
    rebind(preferences_contribution_1.PreferencesContribution)
        .to(preferences_contribution_2.PreferencesContribution)
        .inSingletonScope();
    rebind(browser_4.WorkspaceCommandContribution)
        .to(workspace_commands_1.WorkspaceCommandContribution)
        .inSingletonScope();
    rebind(workspace_delete_handler_1.WorkspaceDeleteHandler)
        .to(workspace_delete_handler_2.WorkspaceDeleteHandler)
        .inSingletonScope();
    rebind(editor_widget_factory_1.EditorWidgetFactory).to(editor_widget_factory_2.EditorWidgetFactory).inSingletonScope();
    rebind(tab_bar_toolbar_1.TabBarToolbarFactory).toFactory(({ container: parentContainer }) => () => {
        const container = parentContainer.createChild();
        container.bind(tab_bar_toolbar_2.TabBarToolbar).toSelf().inSingletonScope();
        return container.get(tab_bar_toolbar_2.TabBarToolbar);
    });
    bind(output_channel_2.OutputChannelManager).toSelf().inSingletonScope();
    rebind(output_channel_1.OutputChannelManager).toService(output_channel_2.OutputChannelManager);
    bind(output_channel_registry_main_1.OutputChannelRegistryMainImpl).toSelf().inTransientScope();
    rebind(output_channel_registry_main_1.OutputChannelRegistryMainImpl).toService(output_channel_registry_main_1.OutputChannelRegistryMainImpl);
    bind(monaco_text_model_service_2.MonacoTextModelService).toSelf().inSingletonScope();
    rebind(monaco_text_model_service_1.MonacoTextModelService).toService(monaco_text_model_service_2.MonacoTextModelService);
    bind(monaco_editor_provider_1.MonacoEditorProvider).toSelf().inSingletonScope();
    rebind(monaco_editor_provider_2.MonacoEditorProvider).toService(monaco_editor_provider_1.MonacoEditorProvider);
    bind(search_in_workspace_widget_2.SearchInWorkspaceWidget).toSelf();
    rebind(search_in_workspace_widget_1.SearchInWorkspaceWidget).toService(search_in_workspace_widget_2.SearchInWorkspaceWidget);
    // Disabled reference counter in the editor manager to avoid opening the same editor (with different opener options) multiple times.
    bind(editor_manager_2.EditorManager).toSelf().inSingletonScope();
    rebind(editor_manager_1.EditorManager).toService(editor_manager_2.EditorManager);
    // replace search icon
    rebind(search_in_workspace_factory_1.SearchInWorkspaceFactory)
        .to(search_in_workspace_factory_2.SearchInWorkspaceFactory)
        .inSingletonScope();
    rebind(search_in_workspace_result_tree_widget_1.SearchInWorkspaceResultTreeWidget).toDynamicValue(({ container }) => {
        const childContainer = (0, browser_1.createTreeContainer)(container);
        childContainer.bind(search_in_workspace_result_tree_widget_2.SearchInWorkspaceResultTreeWidget).toSelf();
        childContainer
            .rebind(browser_1.TreeWidget)
            .toService(search_in_workspace_result_tree_widget_2.SearchInWorkspaceResultTreeWidget);
        return childContainer.get(search_in_workspace_result_tree_widget_2.SearchInWorkspaceResultTreeWidget);
    });
    // Show a disconnected status bar, when the daemon is not available
    bind(connection_status_service_1.ApplicationConnectionStatusContribution).toSelf().inSingletonScope();
    rebind(connection_status_service_2.ApplicationConnectionStatusContribution).toService(connection_status_service_1.ApplicationConnectionStatusContribution);
    bind(connection_status_service_1.FrontendConnectionStatusService).toSelf().inSingletonScope();
    rebind(connection_status_service_2.FrontendConnectionStatusService).toService(connection_status_service_1.FrontendConnectionStatusService);
    // Decorator customizations
    bind(tab_bar_decorator_2.TabBarDecoratorService).toSelf().inSingletonScope();
    rebind(tab_bar_decorator_1.TabBarDecoratorService).toService(tab_bar_decorator_2.TabBarDecoratorService);
    // Problem markers
    bind(problem_manager_1.ProblemManager).toSelf().inSingletonScope();
    rebind(browser_2.ProblemManager).toService(problem_manager_1.ProblemManager);
    // Customized layout restorer that can restore the state in async way: https://github.com/eclipse-theia/theia/issues/6579
    bind(shell_layout_restorer_1.ShellLayoutRestorer).toSelf().inSingletonScope();
    rebind(browser_1.ShellLayoutRestorer).toService(shell_layout_restorer_1.ShellLayoutRestorer);
    // No dropdown for the _Output_ view.
    bind(output_toolbar_contribution_2.OutputToolbarContribution).toSelf().inSingletonScope();
    rebind(output_toolbar_contribution_1.OutputToolbarContribution).toService(output_toolbar_contribution_2.OutputToolbarContribution);
    // To remove `New Window` from the `File` menu
    bind(window_contribution_1.WindowContribution).toSelf().inSingletonScope();
    rebind(window_contribution_2.WindowContribution).toService(window_contribution_1.WindowContribution);
    // To remove `File` > `Close Editor`.
    bind(editor_file_1.EditorMenuContribution).toSelf().inSingletonScope();
    rebind(editor_menu_1.EditorMenuContribution).toService(editor_file_1.EditorMenuContribution);
    // To disable the highlighting of non-unicode characters in the _Output_ view
    bind(output_editor_factory_1.OutputEditorFactory).toSelf().inSingletonScope();
    // Rebind to `TheiaOutputEditorFactory` when https://github.com/eclipse-theia/theia/pull/11615 is available.
    rebind(monaco_editor_provider_2.MonacoEditorFactory).toService(output_editor_factory_1.OutputEditorFactory);
    bind(arduino_daemon_1.ArduinoDaemon)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, arduino_daemon_1.ArduinoDaemonPath))
        .inSingletonScope();
    bind(formatter_1.Formatter)
        .toDynamicValue(({ container }) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(container, formatter_1.FormatterPath))
        .inSingletonScope();
    bind(arduino_firmware_uploader_1.ArduinoFirmwareUploader)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, arduino_firmware_uploader_1.ArduinoFirmwareUploaderPath))
        .inSingletonScope();
    // File-system extension
    bind(filesystem_ext_1.FileSystemExt)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, filesystem_ext_1.FileSystemExtPath))
        .inSingletonScope();
    // Examples service@
    bind(examples_service_1.ExamplesService)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, examples_service_1.ExamplesServicePath))
        .inSingletonScope();
    // Executable URIs known by the backend
    bind(protocol_1.ExecutableService)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, protocol_1.ExecutableServicePath))
        .inSingletonScope();
    contribution_1.Contribution.configure(bind, new_sketch_1.NewSketch);
    contribution_1.Contribution.configure(bind, open_sketch_1.OpenSketch);
    contribution_1.Contribution.configure(bind, close_1.Close);
    contribution_1.Contribution.configure(bind, save_sketch_1.SaveSketch);
    contribution_1.Contribution.configure(bind, save_as_sketch_1.SaveAsSketch);
    contribution_1.Contribution.configure(bind, verify_sketch_1.VerifySketch);
    contribution_1.Contribution.configure(bind, upload_sketch_1.UploadSketch);
    contribution_1.Contribution.configure(bind, open_sketch_external_1.OpenSketchExternal);
    contribution_1.Contribution.configure(bind, edit_contributions_1.EditContributions);
    contribution_1.Contribution.configure(bind, quit_app_1.QuitApp);
    contribution_1.Contribution.configure(bind, sketch_control_1.SketchControl);
    contribution_1.Contribution.configure(bind, settings_1.Settings);
    contribution_1.Contribution.configure(bind, burn_bootloader_1.BurnBootloader);
    contribution_1.Contribution.configure(bind, examples_1.BuiltInExamples);
    contribution_1.Contribution.configure(bind, examples_1.LibraryExamples);
    contribution_1.Contribution.configure(bind, include_library_1.IncludeLibrary);
    contribution_1.Contribution.configure(bind, about_1.About);
    contribution_1.Contribution.configure(bind, debug_1.Debug);
    contribution_1.Contribution.configure(bind, sketchbook_1.Sketchbook);
    contribution_1.Contribution.configure(bind, upload_firmware_1.UploadFirmware);
    contribution_1.Contribution.configure(bind, upload_certificate_1.UploadCertificate);
    contribution_1.Contribution.configure(bind, board_selection_1.BoardSelection);
    contribution_1.Contribution.configure(bind, open_recent_sketch_1.OpenRecentSketch);
    contribution_1.Contribution.configure(bind, help_1.Help);
    contribution_1.Contribution.configure(bind, add_file_1.AddFile);
    contribution_1.Contribution.configure(bind, archive_sketch_1.ArchiveSketch);
    contribution_1.Contribution.configure(bind, add_zip_library_1.AddZipLibrary);
    contribution_1.Contribution.configure(bind, plotter_frontend_contribution_1.PlotterFrontendContribution);
    contribution_1.Contribution.configure(bind, format_1.Format);
    contribution_1.Contribution.configure(bind, compiler_errors_1.CompilerErrors);
    contribution_1.Contribution.configure(bind, startup_task_1.StartupTasks);
    contribution_1.Contribution.configure(bind, indexes_update_progress_1.IndexesUpdateProgress);
    contribution_1.Contribution.configure(bind, daemon_1.Daemon);
    contribution_1.Contribution.configure(bind, first_startup_installer_1.FirstStartupInstaller);
    contribution_1.Contribution.configure(bind, open_sketch_files_1.OpenSketchFiles);
    contribution_1.Contribution.configure(bind, ino_language_1.InoLanguage);
    contribution_1.Contribution.configure(bind, selected_board_1.SelectedBoard);
    contribution_1.Contribution.configure(bind, check_for_ide_updates_1.CheckForIDEUpdates);
    contribution_1.Contribution.configure(bind, open_boards_config_1.OpenBoardsConfig);
    contribution_1.Contribution.configure(bind, sketch_files_tracker_1.SketchFilesTracker);
    contribution_1.Contribution.configure(bind, check_for_updates_1.CheckForUpdates);
    // Disabled the quick-pick customization from Theia when multiple formatters are available.
    // Use the default VS Code behavior, and pick the first one. In the IDE2, clang-format has `exclusive` selectors.
    bind(monaco_formatting_conflicts_1.MonacoFormattingConflictsContribution).toSelf().inSingletonScope();
    rebind(monaco_formatting_conflicts_2.MonacoFormattingConflictsContribution).toService(monaco_formatting_conflicts_1.MonacoFormattingConflictsContribution);
    bind(response_service_impl_1.ResponseServiceImpl)
        .toSelf()
        .inSingletonScope()
        .onActivation(({ container }, responseService) => {
        ws_connection_provider_1.WebSocketConnectionProvider.createProxy(container, response_service_1.ResponseServicePath, responseService);
        return responseService;
    });
    bind(response_service_1.ResponseService).toService(response_service_impl_1.ResponseServiceImpl);
    bind(response_service_1.ResponseServiceClient).toService(response_service_impl_1.ResponseServiceImpl);
    bind(notification_center_1.NotificationCenter).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(notification_center_1.NotificationCenter);
    bind(protocol_2.NotificationServiceServer)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, protocol_2.NotificationServicePath))
        .inSingletonScope();
    // Enable the dirty indicator on uncloseable widgets.
    rebind(browser_1.TabBarRendererFactory).toFactory((context) => () => {
        const contextMenuRenderer = context.container.get(browser_1.ContextMenuRenderer);
        const decoratorService = context.container.get(tab_bar_decorator_2.TabBarDecoratorService);
        const iconThemeService = context.container.get(icon_theme_service_1.IconThemeService);
        return new tab_bars_1.TabBarRenderer(contextMenuRenderer, decoratorService, iconThemeService);
    });
    // Workaround for https://github.com/eclipse-theia/theia/issues/8722
    // Do not trigger a save on IDE startup if `"editor.autoSave": "on"` was set as a preference.
    // Note: `"editor.autoSave" was renamed to `"files.autoSave" and `"on"` was replaced with three
    // different cases, but we treat `!== 'off'` as auto save enabled. (https://github.com/eclipse-theia/theia/issues/10812)
    bind(editor_command_1.EditorCommandContribution).toSelf().inSingletonScope();
    rebind(browser_3.EditorCommandContribution).toService(editor_command_1.EditorCommandContribution);
    // Silent the badge decoration in the Explorer view.
    bind(navigator_tab_bar_decorator_2.NavigatorTabBarDecorator).toSelf().inSingletonScope();
    rebind(navigator_tab_bar_decorator_1.NavigatorTabBarDecorator).toService(navigator_tab_bar_decorator_2.NavigatorTabBarDecorator);
    // Do not fetch the `catalog.json` from Azure on FE load.
    bind(json_schema_store_1.DefaultJsonSchemaContribution).toSelf().inSingletonScope();
    rebind(json_schema_store_2.DefaultJsonSchemaContribution).toService(json_schema_store_1.DefaultJsonSchemaContribution);
    // Do not block the app startup when initializing the editor navigation history.
    bind(editor_navigation_contribution_1.EditorNavigationContribution).toSelf().inSingletonScope();
    rebind(editor_navigation_contribution_2.EditorNavigationContribution).toService(editor_navigation_contribution_1.EditorNavigationContribution);
    // IDE2 does not use the Theia preferences widget, no need to create and sync the underlying tree model.
    bind(preference_tree_generator_1.PreferenceTreeGenerator).toSelf().inSingletonScope();
    rebind(preference_tree_generator_2.PreferenceTreeGenerator).toService(preference_tree_generator_1.PreferenceTreeGenerator);
    // IDE2 has a custom about dialog, so there is no need to load the Theia extensions on FE load
    bind(about_dialog_1.AboutDialog).toSelf().inSingletonScope();
    rebind(about_dialog_2.AboutDialog).toService(about_dialog_1.AboutDialog);
    // To avoid running `Save All` when there are no dirty editors before starting the debug session.
    bind(debug_session_manager_1.DebugSessionManager).toSelf().inSingletonScope();
    rebind(debug_session_manager_2.DebugSessionManager).toService(debug_session_manager_1.DebugSessionManager);
    // To remove the `Run` menu item from the application menu.
    bind(debug_frontend_application_contribution_1.DebugFrontendApplicationContribution).toSelf().inSingletonScope();
    rebind(debug_frontend_application_contribution_2.DebugFrontendApplicationContribution).toService(debug_frontend_application_contribution_1.DebugFrontendApplicationContribution);
    // To be able to use a `launch.json` from outside of the workspace.
    bind(debug_configuration_manager_1.DebugConfigurationManager).toSelf().inSingletonScope();
    rebind(debug_configuration_manager_2.DebugConfigurationManager).toService(debug_configuration_manager_1.DebugConfigurationManager);
    // To avoid duplicate tabs use deepEqual instead of string equal: https://github.com/eclipse-theia/theia/issues/11309
    bind(widget_manager_2.WidgetManager).toSelf().inSingletonScope();
    rebind(widget_manager_3.WidgetManager).toService(widget_manager_2.WidgetManager);
    // To avoid running a status bar update on every single `keypress` event from the editor.
    bind(status_bar_1.StatusBarImpl).toSelf().inSingletonScope();
    rebind(browser_5.StatusBarImpl).toService(status_bar_1.StatusBarImpl);
    // Debounced update for the tab-bar toolbar when typing in the editor.
    bind(application_shell_1.DockPanelRenderer).toSelf();
    rebind(browser_1.DockPanelRenderer).toService(application_shell_1.DockPanelRenderer);
    // Avoid running the "reset scroll" interval tasks until the preference editor opens.
    rebind(preference_widget_1.PreferencesWidget)
        .toDynamicValue(({ container }) => {
        const child = (0, preference_widget_bindings_1.createPreferencesWidgetContainer)(container);
        child.bind(preference_editor_widget_2.PreferencesEditorWidget).toSelf().inSingletonScope();
        child
            .rebind(preference_editor_widget_1.PreferencesEditorWidget)
            .toService(preference_editor_widget_2.PreferencesEditorWidget);
        return child.get(preference_widget_1.PreferencesWidget);
    })
        .inSingletonScope();
    // Preferences
    (0, arduino_preferences_1.bindArduinoPreferences)(bind);
    // Settings wrapper for the preferences and the CLI config.
    bind(settings_2.SettingsService).toSelf().inSingletonScope();
    // Settings dialog and widget
    bind(settings_dialog_1.SettingsWidget).toSelf().inSingletonScope();
    bind(settings_dialog_1.SettingsDialog).toSelf().inSingletonScope();
    bind(settings_dialog_1.SettingsDialogProps).toConstantValue({
        title: common_1.nls.localize('vscode/preferences.contribution/preferences', 'Preferences'),
    });
    bind(storage_wrapper_1.StorageWrapper).toSelf().inSingletonScope();
    bind(command_1.CommandContribution).toService(storage_wrapper_1.StorageWrapper);
    bind(notifications_manager_1.NotificationManager).toSelf().inSingletonScope();
    rebind(notifications_manager_2.NotificationManager).toService(notifications_manager_1.NotificationManager);
    bind(notifications_renderer_2.NotificationsRenderer).toSelf().inSingletonScope();
    rebind(notifications_renderer_1.NotificationsRenderer).toService(notifications_renderer_2.NotificationsRenderer);
    // UI for the Sketchbook
    bind(sketchbook_widget_1.SketchbookWidget).toSelf();
    bind(sketchbook_tree_widget_1.SketchbookTreeWidget).toDynamicValue(({ container }) => (0, sketchbook_tree_container_1.createSketchbookTreeWidget)(container));
    (0, view_contribution_1.bindViewContribution)(bind, sketchbook_widget_contribution_1.SketchbookWidgetContribution);
    bind(frontend_application_1.FrontendApplicationContribution).toService(sketchbook_widget_contribution_1.SketchbookWidgetContribution);
    bind(widget_manager_1.WidgetFactory).toDynamicValue(({ container }) => ({
        id: 'arduino-sketchbook-widget',
        createWidget: () => container.get(sketchbook_widget_1.SketchbookWidget),
    }));
    bind(cloud_sketchbook_widget_1.CloudSketchbookWidget).toSelf();
    rebind(sketchbook_widget_1.SketchbookWidget).toService(cloud_sketchbook_widget_1.CloudSketchbookWidget);
    bind(cloud_sketchbook_tree_widget_1.CloudSketchbookTreeWidget).toDynamicValue(({ container }) => (0, cloud_sketchbook_tree_container_1.createCloudSketchbookTreeWidget)(container));
    bind(create_api_1.CreateApi).toSelf().inSingletonScope();
    bind(cloud_sketch_cache_1.SketchCache).toSelf().inSingletonScope();
    bind(cloud_share_sketch_dialog_1.ShareSketchDialog).toSelf().inSingletonScope();
    bind(authentication_client_service_1.AuthenticationClientService).toSelf().inSingletonScope();
    bind(command_1.CommandContribution).toService(authentication_client_service_1.AuthenticationClientService);
    bind(frontend_application_1.FrontendApplicationContribution).toService(authentication_client_service_1.AuthenticationClientService);
    bind(authentication_service_1.AuthenticationService)
        .toDynamicValue((context) => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, authentication_service_1.AuthenticationServicePath))
        .inSingletonScope();
    bind(create_fs_provider_1.CreateFsProvider).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(create_fs_provider_1.CreateFsProvider);
    bind(file_service_1.FileServiceContribution).toService(create_fs_provider_1.CreateFsProvider);
    bind(cloud_sketchbook_contributions_1.CloudSketchbookContribution).toSelf().inSingletonScope();
    bind(command_1.CommandContribution).toService(cloud_sketchbook_contributions_1.CloudSketchbookContribution);
    bind(local_cache_fs_provider_1.LocalCacheFsProvider).toSelf().inSingletonScope();
    bind(file_service_1.FileServiceContribution).toService(local_cache_fs_provider_1.LocalCacheFsProvider);
    bind(cloud_sketchbook_composite_widget_1.CloudSketchbookCompositeWidget).toSelf();
    bind(widget_manager_1.WidgetFactory).toDynamicValue((ctx) => ({
        id: 'cloud-sketchbook-composite-widget',
        createWidget: () => ctx.container.get(cloud_sketchbook_composite_widget_1.CloudSketchbookCompositeWidget),
    }));
    bind(firmware_uploader_dialog_1.UploadFirmwareDialogWidget).toSelf().inSingletonScope();
    bind(firmware_uploader_dialog_1.UploadFirmwareDialog).toSelf().inSingletonScope();
    bind(firmware_uploader_dialog_1.UploadFirmwareDialogProps).toConstantValue({
        title: 'UploadFirmware',
    });
    bind(certificate_uploader_dialog_1.UploadCertificateDialogWidget).toSelf().inSingletonScope();
    bind(certificate_uploader_dialog_1.UploadCertificateDialog).toSelf().inSingletonScope();
    bind(certificate_uploader_dialog_1.UploadCertificateDialogProps).toConstantValue({
        title: 'UploadCertificate',
    });
    bind(ide_updater_dialog_1.IDEUpdaterDialogWidget).toSelf().inSingletonScope();
    bind(ide_updater_dialog_1.IDEUpdaterDialog).toSelf().inSingletonScope();
    bind(ide_updater_dialog_1.IDEUpdaterDialogProps).toConstantValue({
        title: 'IDEUpdater',
    });
    bind(user_fields_dialog_1.UserFieldsDialogWidget).toSelf().inSingletonScope();
    bind(user_fields_dialog_1.UserFieldsDialog).toSelf().inSingletonScope();
    bind(user_fields_dialog_1.UserFieldsDialogProps).toConstantValue({
        title: 'UserFields',
    });
    bind(ide_updater_commands_1.IDEUpdaterCommands).toSelf().inSingletonScope();
    bind(command_1.CommandContribution).toService(ide_updater_commands_1.IDEUpdaterCommands);
    // Frontend binding for the IDE Updater service
    bind(ide_updater_client_impl_1.IDEUpdaterClientImpl).toSelf().inSingletonScope();
    bind(ide_updater_1.IDEUpdaterClient).toService(ide_updater_client_impl_1.IDEUpdaterClientImpl);
    bind(ide_updater_1.IDEUpdater)
        .toDynamicValue((context) => {
        const client = context.container.get(ide_updater_client_impl_1.IDEUpdaterClientImpl);
        return electron_ipc_connection_provider_1.ElectronIpcConnectionProvider.createProxy(context.container, ide_updater_1.IDEUpdaterPath, client);
    })
        .inSingletonScope();
    bind(hosted_plugin_1.HostedPluginSupport).toSelf().inSingletonScope();
    rebind(hosted_plugin_2.HostedPluginSupport).toService(hosted_plugin_1.HostedPluginSupport);
    bind(hosted_plugin_events_1.HostedPluginEvents).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(hosted_plugin_events_1.HostedPluginEvents);
});
//# sourceMappingURL=arduino-ide-frontend-module.js.map