"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticationClientService = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const event_1 = require("@theia/core/lib/common/event");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const disposable_1 = require("@theia/core/lib/common/disposable");
const authentication_service_1 = require("../../common/protocol/authentication-service");
const cloud_user_commands_1 = require("./cloud-user-commands");
const authentication_server_1 = require("../../node/auth/authentication-server");
const arduino_preferences_1 = require("../arduino-preferences");
let AuthenticationClientService = class AuthenticationClientService {
    constructor() {
        this.toDispose = new disposable_1.DisposableCollection();
        this.onSessionDidChangeEmitter = new event_1.Emitter();
        this.onSessionDidChange = this.onSessionDidChangeEmitter.event;
    }
    async onStart() {
        this.toDispose.push(this.onSessionDidChangeEmitter);
        this.service.setClient(this);
        this.service
            .session()
            .then((session) => this.notifySessionDidChange(session));
        this.setOptions().then(() => this.service.initAuthSession());
        this.arduinoPreferences.onPreferenceChanged((event) => {
            if (event.preferenceName.startsWith('arduino.auth.')) {
                this.setOptions();
            }
        });
    }
    setOptions() {
        return this.service.setOptions({
            redirectUri: `http://localhost:${authentication_server_1.serverPort}/callback`,
            responseType: 'code',
            clientID: this.arduinoPreferences['arduino.auth.clientID'],
            domain: this.arduinoPreferences['arduino.auth.domain'],
            audience: this.arduinoPreferences['arduino.auth.audience'],
            registerUri: this.arduinoPreferences['arduino.auth.registerUri'],
            scopes: ['openid', 'profile', 'email', 'offline_access'],
        });
    }
    updateSession(session) {
        this._session = session;
        this.onSessionDidChangeEmitter.fire(this._session);
    }
    get session() {
        return this._session;
    }
    registerCommands(registry) {
        registry.registerCommand(cloud_user_commands_1.CloudUserCommands.LOGIN, {
            execute: () => this.service.login(),
        });
        registry.registerCommand(cloud_user_commands_1.CloudUserCommands.LOGOUT, {
            execute: () => this.service.logout(),
        });
    }
    notifySessionDidChange(session) {
        this.updateSession(session);
    }
};
__decorate([
    (0, inversify_1.inject)(authentication_service_1.AuthenticationService),
    __metadata("design:type", Object)
], AuthenticationClientService.prototype, "service", void 0);
__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    __metadata("design:type", Object)
], AuthenticationClientService.prototype, "windowService", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], AuthenticationClientService.prototype, "arduinoPreferences", void 0);
AuthenticationClientService = __decorate([
    (0, inversify_1.injectable)()
], AuthenticationClientService);
exports.AuthenticationClientService = AuthenticationClientService;
//# sourceMappingURL=authentication-client-service.js.map