"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var BoardsListWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoardsListWidget = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const boards_service_1 = require("../../common/protocol/boards-service");
const list_widget_1 = require("../widgets/component-list/list-widget");
const list_item_renderer_1 = require("../widgets/component-list/list-item-renderer");
const common_1 = require("@theia/core/lib/common");
const filter_renderer_1 = require("../widgets/component-list/filter-renderer");
let BoardsListWidget = BoardsListWidget_1 = class BoardsListWidget extends list_widget_1.ListWidget {
    constructor(service, itemRenderer, filterRenderer) {
        super({
            id: BoardsListWidget_1.WIDGET_ID,
            label: BoardsListWidget_1.WIDGET_LABEL,
            iconClass: 'fa fa-arduino-boards',
            searchable: service,
            installable: service,
            itemLabel: (item) => item.name,
            itemDeprecated: (item) => item.deprecated,
            itemRenderer,
            filterRenderer,
            defaultSearchOptions: { query: '', type: 'All' },
        });
    }
    init() {
        super.init();
        this.toDispose.pushAll([
            this.notificationCenter.onPlatformDidInstall(() => this.refresh(undefined)),
            this.notificationCenter.onPlatformDidUninstall(() => this.refresh(undefined)),
        ]);
    }
    async install({ item, progressId, version, }) {
        await super.install({ item, progressId, version });
        this.messageService.info(common_1.nls.localize('arduino/board/succesfullyInstalledPlatform', 'Successfully installed platform {0}:{1}', item.name, version), { timeout: 3000 });
    }
    async uninstall({ item, progressId, }) {
        await super.uninstall({ item, progressId });
        this.messageService.info(common_1.nls.localize('arduino/board/succesfullyUninstalledPlatform', 'Successfully uninstalled platform {0}:{1}', item.name, item.installedVersion), { timeout: 3000 });
    }
};
BoardsListWidget.WIDGET_ID = 'boards-list-widget';
BoardsListWidget.WIDGET_LABEL = common_1.nls.localize('arduino/boardsManager', 'Boards Manager');
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], BoardsListWidget.prototype, "init", null);
BoardsListWidget = BoardsListWidget_1 = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(boards_service_1.BoardsService)),
    __param(1, (0, inversify_1.inject)(list_item_renderer_1.ListItemRenderer)),
    __param(2, (0, inversify_1.inject)(filter_renderer_1.BoardsFilterRenderer)),
    __metadata("design:paramtypes", [Object, list_item_renderer_1.ListItemRenderer,
        filter_renderer_1.BoardsFilterRenderer])
], BoardsListWidget);
exports.BoardsListWidget = BoardsListWidget;
//# sourceMappingURL=boards-list-widget.js.map