"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var AddFile_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddFile = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const arduino_menus_1 = require("../menu/arduino-menus");
const contribution_1 = require("./contribution");
const browser_1 = require("@theia/filesystem/lib/browser");
const common_1 = require("@theia/core/lib/common");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
let AddFile = AddFile_1 = class AddFile extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(AddFile_1.Commands.ADD_FILE, {
            execute: () => this.addFile(),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__UTILS_GROUP, {
            commandId: AddFile_1.Commands.ADD_FILE.id,
            label: common_1.nls.localize('arduino/contributions/addFile', 'Add File') + '...',
            order: '2',
        });
    }
    async addFile() {
        const sketch = await this.sketchServiceClient.currentSketch();
        if (!sketches_service_client_impl_1.CurrentSketch.isValid(sketch)) {
            return;
        }
        const toAddUri = await this.fileDialogService.showOpenDialog({
            title: common_1.nls.localize('arduino/contributions/addFile', 'Add File'),
            canSelectFiles: true,
            canSelectFolders: false,
            canSelectMany: false,
        });
        if (!toAddUri) {
            return;
        }
        const sketchUri = new contribution_1.URI(sketch.uri);
        const filename = toAddUri.path.base;
        const targetUri = sketchUri.resolve('data').resolve(filename);
        const exists = await this.fileService.exists(targetUri);
        if (exists) {
            const { response } = await remote.dialog.showMessageBox({
                type: 'question',
                title: common_1.nls.localize('arduino/contributions/replaceTitle', 'Replace'),
                buttons: [
                    common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'),
                    common_1.nls.localize('vscode/issueMainService/ok', 'OK'),
                ],
                message: common_1.nls.localize('arduino/replaceMsg', 'Replace the existing version of {0}?', filename),
            });
            if (response === 0) {
                // Cancel
                return;
            }
        }
        await this.fileService.copy(toAddUri, targetUri, { overwrite: true });
        this.messageService.info(common_1.nls.localize('arduino/contributions/fileAdded', 'One file added to the sketch.'), {
            timeout: 2000,
        });
    }
};
__decorate([
    (0, inversify_1.inject)(browser_1.FileDialogService),
    __metadata("design:type", Object)
], AddFile.prototype, "fileDialogService", void 0);
AddFile = AddFile_1 = __decorate([
    (0, inversify_1.injectable)()
], AddFile);
exports.AddFile = AddFile;
(function (AddFile) {
    let Commands;
    (function (Commands) {
        Commands.ADD_FILE = {
            id: 'arduino-add-file',
        };
    })(Commands = AddFile.Commands || (AddFile.Commands = {}));
})(AddFile = exports.AddFile || (exports.AddFile = {}));
exports.AddFile = AddFile;
//# sourceMappingURL=add-file.js.map