"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var BurnBootloader_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BurnBootloader = void 0;
const common_1 = require("@theia/core/lib/common");
const inversify_1 = require("@theia/core/shared/inversify");
const arduino_menus_1 = require("../menu/arduino-menus");
const contribution_1 = require("./contribution");
let BurnBootloader = BurnBootloader_1 = class BurnBootloader extends contribution_1.CoreServiceContribution {
    registerCommands(registry) {
        registry.registerCommand(BurnBootloader_1.Commands.BURN_BOOTLOADER, {
            execute: () => this.burnBootloader(),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__BOARD_SETTINGS_GROUP, {
            commandId: BurnBootloader_1.Commands.BURN_BOOTLOADER.id,
            label: common_1.nls.localize('arduino/bootloader/burnBootloader', 'Burn Bootloader'),
            order: 'z99',
        });
    }
    async burnBootloader() {
        this.clearVisibleNotification();
        const options = await this.options();
        try {
            await this.doWithProgress({
                progressText: common_1.nls.localize('arduino/bootloader/burningBootloader', 'Burning bootloader...'),
                task: (progressId, coreService) => coreService.burnBootloader(Object.assign(Object.assign({}, options), { progressId })),
            });
            this.messageService.info(common_1.nls.localize('arduino/bootloader/doneBurningBootloader', 'Done burning bootloader.'), {
                timeout: 3000,
            });
        }
        catch (e) {
            this.handleError(e);
        }
    }
    async options() {
        var _a, _b;
        const { boardsConfig } = this.boardsServiceProvider;
        const port = boardsConfig.selectedPort;
        const [fqbn, { selectedProgrammer: programmer }, verify, verbose] = await Promise.all([
            this.boardsDataStore.appendConfigToFqbn((_a = boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn),
            this.boardsDataStore.getData((_b = boardsConfig.selectedBoard) === null || _b === void 0 ? void 0 : _b.fqbn),
            this.preferences.get('arduino.upload.verify'),
            this.preferences.get('arduino.upload.verbose'),
        ]);
        return {
            fqbn,
            programmer,
            port,
            verify,
            verbose,
        };
    }
};
BurnBootloader = BurnBootloader_1 = __decorate([
    (0, inversify_1.injectable)()
], BurnBootloader);
exports.BurnBootloader = BurnBootloader;
(function (BurnBootloader) {
    let Commands;
    (function (Commands) {
        Commands.BURN_BOOTLOADER = {
            id: 'arduino-burn-bootloader',
        };
    })(Commands = BurnBootloader.Commands || (BurnBootloader.Commands = {}));
})(BurnBootloader = exports.BurnBootloader || (exports.BurnBootloader = {}));
exports.BurnBootloader = BurnBootloader;
//# sourceMappingURL=burn-bootloader.js.map