"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckForIDEUpdates = void 0;
const nls_1 = require("@theia/core/lib/common/nls");
const storage_service_1 = require("@theia/core/lib/browser/storage-service");
const inversify_1 = require("@theia/core/shared/inversify");
const ide_updater_1 = require("../../common/protocol/ide-updater");
const ide_updater_dialog_1 = require("../dialogs/ide-updater/ide-updater-dialog");
const contribution_1 = require("./contribution");
let CheckForIDEUpdates = class CheckForIDEUpdates extends contribution_1.Contribution {
    onStart() {
        this.preferences.onPreferenceChanged(({ preferenceName, newValue, oldValue }) => {
            if (newValue !== oldValue) {
                switch (preferenceName) {
                    case 'arduino.ide.updateChannel':
                    case 'arduino.ide.updateBaseUrl':
                        this.updater.init(this.preferences.get('arduino.ide.updateChannel'), this.preferences.get('arduino.ide.updateBaseUrl'));
                }
            }
        });
    }
    onReady() {
        const checkForUpdates = this.preferences['arduino.checkForUpdates'];
        if (!checkForUpdates) {
            return;
        }
        this.updater
            .init(this.preferences.get('arduino.ide.updateChannel'), this.preferences.get('arduino.ide.updateBaseUrl'))
            .then(() => this.updater.checkForUpdates(true))
            .then(async (updateInfo) => {
            if (!updateInfo)
                return;
            const versionToSkip = await this.localStorage.getData(ide_updater_1.SKIP_IDE_VERSION);
            if (versionToSkip === updateInfo.version)
                return;
            this.updaterDialog.open(updateInfo);
        })
            .catch((e) => {
            this.messageService.error(nls_1.nls.localize('arduino/ide-updater/errorCheckingForUpdates', 'Error while checking for Arduino IDE updates.\n{0}', e.message));
        });
    }
};
__decorate([
    (0, inversify_1.inject)(ide_updater_1.IDEUpdater),
    __metadata("design:type", Object)
], CheckForIDEUpdates.prototype, "updater", void 0);
__decorate([
    (0, inversify_1.inject)(ide_updater_dialog_1.IDEUpdaterDialog),
    __metadata("design:type", ide_updater_dialog_1.IDEUpdaterDialog)
], CheckForIDEUpdates.prototype, "updaterDialog", void 0);
__decorate([
    (0, inversify_1.inject)(storage_service_1.LocalStorageService),
    __metadata("design:type", storage_service_1.LocalStorageService)
], CheckForIDEUpdates.prototype, "localStorage", void 0);
CheckForIDEUpdates = __decorate([
    (0, inversify_1.injectable)()
], CheckForIDEUpdates);
exports.CheckForIDEUpdates = CheckForIDEUpdates;
//# sourceMappingURL=check-for-ide-updates.js.map