"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var CheckForUpdates_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckForUpdates = void 0;
const nls_1 = require("@theia/core/lib/common/nls");
const inversify_1 = require("@theia/core/shared/inversify");
const nls_2 = require("../../common/nls");
const protocol_1 = require("../../common/protocol");
const installable_1 = require("../../common/protocol/installable");
const progressible_1 = require("../../common/protocol/progressible");
const boards_widget_frontend_contribution_1 = require("../boards/boards-widget-frontend-contribution");
const library_widget_frontend_contribution_1 = require("../library/library-widget-frontend-contribution");
const window_service_ext_1 = require("../theia/core/window-service-ext");
const contribution_1 = require("./contribution");
const NoUpdates = nls_1.nls.localize('arduino/checkForUpdates/noUpdates', 'There are no recent updates available.');
const PromptUpdateBoards = nls_1.nls.localize('arduino/checkForUpdates/promptUpdateBoards', 'Updates are available for some of your boards.');
const PromptUpdateLibraries = nls_1.nls.localize('arduino/checkForUpdates/promptUpdateLibraries', 'Updates are available for some of your libraries.');
const UpdatingBoards = nls_1.nls.localize('arduino/checkForUpdates/updatingBoards', 'Updating boards...');
const UpdatingLibraries = nls_1.nls.localize('arduino/checkForUpdates/updatingLibraries', 'Updating libraries...');
const InstallAll = nls_1.nls.localize('arduino/checkForUpdates/installAll', 'Install All');
const Updatable = { type: 'Updatable' };
let CheckForUpdates = CheckForUpdates_1 = class CheckForUpdates extends contribution_1.Contribution {
    registerCommands(register) {
        register.registerCommand(CheckForUpdates_1.Commands.CHECK_FOR_UPDATES, {
            execute: () => this.checkForUpdates(false),
        });
    }
    async onReady() {
        const checkForUpdates = this.preferences['arduino.checkForUpdates'];
        if (checkForUpdates) {
            this.windowService.isFirstWindow().then((firstWindow) => {
                if (firstWindow) {
                    this.checkForUpdates();
                }
            });
        }
    }
    async checkForUpdates(silent = true) {
        const [boardsPackages, libraryPackages] = await Promise.all([
            this.boardsService.search(Updatable),
            this.libraryService.search(Updatable),
        ]);
        this.promptUpdateBoards(boardsPackages);
        this.promptUpdateLibraries(libraryPackages);
        if (!libraryPackages.length && !boardsPackages.length && !silent) {
            this.messageService.info(NoUpdates);
        }
    }
    promptUpdateBoards(items) {
        this.prompt({
            items,
            installable: this.boardsService,
            viewContribution: this.boardsContribution,
            viewSearchOptions: Object.assign({ query: '' }, Updatable),
            promptMessage: PromptUpdateBoards,
            updatingMessage: UpdatingBoards,
        });
    }
    promptUpdateLibraries(items) {
        this.prompt({
            items,
            installable: this.libraryService,
            viewContribution: this.librariesContribution,
            viewSearchOptions: Object.assign({ query: '', topic: 'All' }, Updatable),
            promptMessage: PromptUpdateLibraries,
            updatingMessage: UpdatingLibraries,
        });
    }
    prompt(options) {
        const { items, installable, viewContribution, promptMessage: message, viewSearchOptions, updatingMessage, } = options;
        if (!items.length) {
            return;
        }
        this.messageService
            .info(message, nls_2.Later, nls_2.InstallManually, InstallAll)
            .then((answer) => {
            if (answer === InstallAll) {
                const tasks = items.map((item) => this.createInstallTask(item, installable));
                this.executeTasks(updatingMessage, tasks);
            }
            else if (answer === nls_2.InstallManually) {
                viewContribution
                    .openView({ reveal: true })
                    .then((widget) => widget.refresh(viewSearchOptions));
            }
        });
    }
    async executeTasks(message, tasks) {
        if (tasks.length) {
            return progressible_1.ExecuteWithProgress.withProgress(message, this.messageService, async (progress) => {
                try {
                    const total = tasks.length;
                    let count = 0;
                    for (const { run, item } of tasks) {
                        try {
                            await run(); // runs update sequentially. // TODO: is parallel update desired?
                        }
                        catch (err) {
                            console.error(err);
                            this.messageService.error(`Failed to update ${item.name}. ${err}`);
                        }
                        finally {
                            progress.report({ work: { total, done: ++count } });
                        }
                    }
                }
                finally {
                    progress.cancel();
                }
            });
        }
    }
    createInstallTask(item, installable) {
        const latestVersion = item.availableVersions[0];
        return {
            item,
            run: () => installable_1.Installable.installWithProgress({
                installable,
                item,
                version: latestVersion,
                messageService: this.messageService,
                responseService: this.responseService,
                keepOutput: true,
            }),
        };
    }
};
__decorate([
    (0, inversify_1.inject)(window_service_ext_1.WindowServiceExt),
    __metadata("design:type", Object)
], CheckForUpdates.prototype, "windowService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ResponseServiceClient),
    __metadata("design:type", Object)
], CheckForUpdates.prototype, "responseService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.BoardsService),
    __metadata("design:type", Object)
], CheckForUpdates.prototype, "boardsService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.LibraryService),
    __metadata("design:type", Object)
], CheckForUpdates.prototype, "libraryService", void 0);
__decorate([
    (0, inversify_1.inject)(boards_widget_frontend_contribution_1.BoardsListWidgetFrontendContribution),
    __metadata("design:type", boards_widget_frontend_contribution_1.BoardsListWidgetFrontendContribution)
], CheckForUpdates.prototype, "boardsContribution", void 0);
__decorate([
    (0, inversify_1.inject)(library_widget_frontend_contribution_1.LibraryListWidgetFrontendContribution),
    __metadata("design:type", library_widget_frontend_contribution_1.LibraryListWidgetFrontendContribution)
], CheckForUpdates.prototype, "librariesContribution", void 0);
CheckForUpdates = CheckForUpdates_1 = __decorate([
    (0, inversify_1.injectable)()
], CheckForUpdates);
exports.CheckForUpdates = CheckForUpdates;
(function (CheckForUpdates) {
    let Commands;
    (function (Commands) {
        Commands.CHECK_FOR_UPDATES = contribution_1.Command.toLocalizedCommand({
            id: 'arduino-check-for-updates',
            label: 'Check for Arduino Updates',
            category: 'Arduino',
        }, 'arduino/checkForUpdates/checkForUpdates');
    })(Commands = CheckForUpdates.Commands || (CheckForUpdates.Commands = {}));
})(CheckForUpdates = exports.CheckForUpdates || (exports.CheckForUpdates = {}));
exports.CheckForUpdates = CheckForUpdates;
//# sourceMappingURL=check-for-updates.js.map