"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var CompilerErrors_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompilerErrors = exports.ErrorDecorationRef = void 0;
const core_1 = require("@theia/core");
const uri_1 = require("@theia/core/lib/common/uri");
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/editor/lib/browser");
const editor_decoration_1 = require("@theia/editor/lib/browser/decorations/editor-decoration");
const editor_manager_1 = require("@theia/editor/lib/browser/editor-manager");
const monaco = require("@theia/monaco-editor-core");
const monaco_editor_1 = require("@theia/monaco/lib/browser/monaco-editor");
const monaco_to_protocol_converter_1 = require("@theia/monaco/lib/browser/monaco-to-protocol-converter");
const protocol_to_monaco_converter_1 = require("@theia/monaco/lib/browser/protocol-to-monaco-converter");
const output_uri_1 = require("@theia/output/lib/common/output-uri");
const arduino_preferences_1 = require("../arduino-preferences");
const selectors_1 = require("../selectors");
const contribution_1 = require("./contribution");
const core_error_handler_1 = require("./core-error-handler");
const monaco_editor_model_1 = require("@theia/monaco/lib/browser/monaco-editor-model");
var ErrorDecorationRef;
(function (ErrorDecorationRef) {
    function is(arg) {
        if (typeof arg === 'object') {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const object = arg;
            return ('uri' in object &&
                typeof object['uri'] === 'string' &&
                'id' in object &&
                typeof object['id'] === 'string');
        }
        return false;
    }
    ErrorDecorationRef.is = is;
    function sameAs(left, right) {
        return left.id === right.id && left.uri === right.uri;
    }
    ErrorDecorationRef.sameAs = sameAs;
})(ErrorDecorationRef = exports.ErrorDecorationRef || (exports.ErrorDecorationRef = {}));
var ErrorDecoration;
(function (ErrorDecoration) {
    function rangeOf(editorOrModel, decorations) {
        if (editorOrModel) {
            const allDecorations = getAllDecorations(editorOrModel);
            if (allDecorations) {
                if (Array.isArray(decorations)) {
                    return decorations.map(({ id: decorationId }) => findRangeOf(decorationId, allDecorations));
                }
                else {
                    return findRangeOf(decorations.id, allDecorations);
                }
            }
        }
        return Array.isArray(decorations)
            ? decorations.map(() => undefined)
            : undefined;
    }
    ErrorDecoration.rangeOf = rangeOf;
    function findRangeOf(decorationId, allDecorations) {
        var _a;
        return (_a = allDecorations.find(({ id: candidateId }) => candidateId === decorationId)) === null || _a === void 0 ? void 0 : _a.range;
    }
    function getAllDecorations(editorOrModel) {
        if (editorOrModel instanceof monaco_editor_1.MonacoEditor) {
            const model = editorOrModel.getControl().getModel();
            if (!model) {
                return [];
            }
            return model.getAllDecorations();
        }
        return editorOrModel.getAllDecorations();
    }
})(ErrorDecoration || (ErrorDecoration = {}));
let CompilerErrors = CompilerErrors_1 = class CompilerErrors extends contribution_1.Contribution {
    constructor() {
        super(...arguments);
        this.revealStrategy = arduino_preferences_1.ErrorRevealStrategy.Default;
        this.experimental = false;
        this.errors = [];
        this.onDidChangeEmitter = new monaco.Emitter();
        this.currentErrorDidChangEmitter = new core_1.Emitter();
        this.onCurrentErrorDidChange = this.currentErrorDidChangEmitter.event;
        this.toDisposeOnCompilerErrorDidChange = new core_1.DisposableCollection();
    }
    get currentErrorIndex() {
        const current = this.currentError;
        if (!current) {
            return -1;
        }
        return this.errors.findIndex((error) => ErrorDecorationRef.sameAs(error, current));
    }
    onStart(app) {
        this.shell = app.shell;
        monaco.languages.registerCodeLensProvider(selectors_1.InoSelector, this);
        monaco.languages.registerLinkProvider(selectors_1.ArduinoOutputSelector, this);
        this.coreErrorHandler.onCompilerErrorsDidChange((errors) => this.handleCompilerErrorsDidChange(errors));
        this.onCurrentErrorDidChange(async (error) => {
            const monacoEditor = await this.monacoEditor(error.uri);
            const monacoRange = ErrorDecoration.rangeOf(monacoEditor, error);
            if (!monacoRange) {
                console.warn('compiler-errors', `Could not find range of decoration: ${error.id}`);
                return;
            }
            const range = this.m2p.asRange(monacoRange);
            const editor = await this.revealLocationInEditor({
                uri: error.uri,
                range,
            });
            if (!editor) {
                console.warn('compiler-errors', `Failed to mark error ${error.id} as the current one.`);
            }
            else {
                const monacoEditor = this.monacoEditor(editor);
                if (monacoEditor) {
                    monacoEditor.cursor = range.start;
                }
            }
        });
    }
    onReady() {
        this.preferences.ready.then(() => {
            this.experimental = Boolean(this.preferences['arduino.compile.experimental']);
            const strategy = this.preferences['arduino.compile.revealRange'];
            this.revealStrategy = arduino_preferences_1.ErrorRevealStrategy.is(strategy)
                ? strategy
                : arduino_preferences_1.ErrorRevealStrategy.Default;
            this.preferences.onPreferenceChanged(({ preferenceName, newValue, oldValue }) => {
                if (newValue === oldValue) {
                    return;
                }
                switch (preferenceName) {
                    case 'arduino.compile.revealRange': {
                        this.revealStrategy = arduino_preferences_1.ErrorRevealStrategy.is(newValue)
                            ? newValue
                            : arduino_preferences_1.ErrorRevealStrategy.Default;
                        return;
                    }
                    case 'arduino.compile.experimental': {
                        this.experimental = Boolean(newValue);
                        this.onDidChangeEmitter.fire(this);
                        return;
                    }
                }
            });
        });
    }
    registerCommands(registry) {
        registry.registerCommand(CompilerErrors_1.Commands.NEXT_ERROR, {
            execute: () => {
                const index = this.currentErrorIndex;
                if (index < 0) {
                    console.warn('compiler-errors', `Could not advance to next error. Unknown current error.`);
                    return;
                }
                const nextError = this.errors[index === this.errors.length - 1 ? 0 : index + 1];
                return this.markAsCurrentError(nextError, {
                    forceReselect: true,
                    reveal: true,
                });
            },
            isEnabled: () => this.experimental && !!this.currentError && this.errors.length > 1,
        });
        registry.registerCommand(CompilerErrors_1.Commands.PREVIOUS_ERROR, {
            execute: () => {
                const index = this.currentErrorIndex;
                if (index < 0) {
                    console.warn('compiler-errors', `Could not advance to previous error. Unknown current error.`);
                    return;
                }
                const previousError = this.errors[index === 0 ? this.errors.length - 1 : index - 1];
                return this.markAsCurrentError(previousError, {
                    forceReselect: true,
                    reveal: true,
                });
            },
            isEnabled: () => this.experimental && !!this.currentError && this.errors.length > 1,
        });
        registry.registerCommand(CompilerErrors_1.Commands.MARK_AS_CURRENT, {
            execute: (arg) => {
                if (ErrorDecorationRef.is(arg)) {
                    return this.markAsCurrentError({ id: arg.id, uri: new uri_1.default(arg.uri).toString() }, // Make sure the URI fragments are encoded. On Windows, `C:` is encoded as `C%3A`.
                    { forceReselect: true, reveal: true });
                }
            },
            isEnabled: () => !!this.errors.length,
        });
    }
    get onDidChange() {
        return this.onDidChangeEmitter.event;
    }
    async provideCodeLenses(model, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    _token) {
        const lenses = [];
        if (this.experimental &&
            this.currentError &&
            this.currentError.uri === model.uri.toString() &&
            this.errors.length > 1) {
            const monacoEditor = await this.monacoEditor(model.uri);
            const range = ErrorDecoration.rangeOf(monacoEditor, this.currentError);
            if (range) {
                lenses.push({
                    range,
                    command: {
                        id: CompilerErrors_1.Commands.PREVIOUS_ERROR.id,
                        title: core_1.nls.localize('arduino/editor/previousError', 'Previous Error'),
                        arguments: [this.currentError],
                    },
                }, {
                    range,
                    command: {
                        id: CompilerErrors_1.Commands.NEXT_ERROR.id,
                        title: core_1.nls.localize('arduino/editor/nextError', 'Next Error'),
                        arguments: [this.currentError],
                    },
                });
            }
        }
        return {
            lenses,
            dispose: () => {
                /* NOOP */
            },
        };
    }
    async provideLinks(model, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    _token) {
        const links = [];
        if (model.uri.scheme === output_uri_1.OutputUri.SCHEME &&
            model.uri.path === '/Arduino') {
            links.push(...this.errors
                .filter((decoration) => !!decoration.rangesInOutput.length)
                .map(({ rangesInOutput, id, uri }) => rangesInOutput.map((range) => ({
                range,
                url: monaco.Uri.parse(`command://`).with({
                    query: JSON.stringify({ id, uri }),
                    path: CompilerErrors_1.Commands.MARK_AS_CURRENT.id,
                }),
                tooltip: core_1.nls.localize('arduino/editor/revealError', 'Reveal Error'),
            })))
                .reduce((acc, curr) => acc.concat(curr), []));
        }
        else {
            console.warn('unexpected URI: ' + model.uri.toString());
        }
        return { links };
    }
    async resolveLink(link, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    _token) {
        if (!this.experimental) {
            return undefined;
        }
        const { url } = link;
        if (url) {
            const candidateUri = new uri_1.default(typeof url === 'string' ? url : url.toString());
            const candidateId = candidateUri.path.toString();
            const error = this.errors.find((error) => error.id === candidateId);
            if (error) {
                const monacoEditor = await this.monacoEditor(error.uri);
                const range = ErrorDecoration.rangeOf(monacoEditor, error);
                if (range) {
                    return {
                        range,
                        url: monaco.Uri.parse(error.uri),
                    };
                }
            }
        }
        return undefined;
    }
    async handleCompilerErrorsDidChange(errors) {
        this.toDisposeOnCompilerErrorDidChange.dispose();
        const groupedErrors = this.groupBy(errors, (error) => error.location.uri);
        const decorations = await this.decorateEditors(groupedErrors);
        this.errors.push(...decorations.errors);
        this.toDisposeOnCompilerErrorDidChange.pushAll([
            core_1.Disposable.create(() => (this.errors.length = 0)),
            core_1.Disposable.create(() => this.onDidChangeEmitter.fire(this)),
            ...(await Promise.all([
                decorations.dispose,
                this.trackEditors(groupedErrors, (editor) => editor.onSelectionChanged((selection) => this.handleSelectionChange(editor, selection)), (editor) => editor.onDispose(() => this.handleEditorDidDispose(editor.uri.toString())), (editor) => editor.onDocumentContentChanged((event) => this.handleDocumentContentChange(editor, event))),
            ])),
        ]);
        const currentError = this.errors[0];
        if (currentError) {
            await this.markAsCurrentError(currentError, {
                forceReselect: true,
                reveal: true,
            });
        }
    }
    async decorateEditors(errors) {
        const composite = await Promise.all([...errors.entries()].map(([uri, errors]) => this.decorateEditor(uri, errors)));
        return {
            dispose: new core_1.DisposableCollection(...composite.map(({ dispose }) => dispose)),
            errors: composite.reduce((acc, { errors }) => acc.concat(errors), []),
        };
    }
    async decorateEditor(uri, errors) {
        const editor = await this.monacoEditor(uri);
        if (!editor) {
            return { dispose: core_1.Disposable.NULL, errors: [] };
        }
        const oldDecorations = editor.deltaDecorations({
            oldDecorations: [],
            newDecorations: errors.map((error) => this.compilerErrorDecoration(error.location.range)),
        });
        return {
            dispose: core_1.Disposable.create(() => {
                if (editor) {
                    editor.deltaDecorations({
                        oldDecorations,
                        newDecorations: [],
                    });
                }
            }),
            errors: oldDecorations.map((id, index) => ({
                id,
                uri,
                rangesInOutput: errors[index].rangesInOutput.map((range) => this.p2m.asRange(range)),
            })),
        };
    }
    compilerErrorDecoration(range) {
        return {
            range,
            options: {
                isWholeLine: true,
                className: 'compiler-error',
                stickiness: editor_decoration_1.TrackedRangeStickiness.NeverGrowsWhenTypingAtEdges,
            },
        };
    }
    /**
     * Tracks the selection in all editors that have an error. If the editor selection overlaps one of the compiler error's range, mark as current error.
     */
    handleSelectionChange(monacoEditor, selection) {
        const uri = monacoEditor.uri.toString();
        const monacoSelection = this.p2m.asRange(selection);
        console.log('compiler-errors', `Handling selection change in editor ${uri}. New (monaco) selection: ${monacoSelection.toJSON()}`);
        const calculatePriority = (candidateErrorRange, currentSelection) => {
            console.trace('compiler-errors', `Candidate error range: ${candidateErrorRange.toJSON()}`);
            console.trace('compiler-errors', `Current selection range: ${currentSelection.toJSON()}`);
            if (candidateErrorRange.intersectRanges(currentSelection)) {
                console.trace('Intersects.');
                return { score: 2 };
            }
            if (candidateErrorRange.startLineNumber <=
                currentSelection.startLineNumber &&
                candidateErrorRange.endLineNumber >= currentSelection.endLineNumber) {
                console.trace('Same line.');
                return { score: 1 };
            }
            console.trace('No match');
            return undefined;
        };
        const errorsPerResource = this.errors.filter((error) => error.uri === uri);
        const rangesPerResource = ErrorDecoration.rangeOf(monacoEditor, errorsPerResource);
        const error = rangesPerResource
            .map((range, index) => ({ error: errorsPerResource[index], range }))
            .map(({ error, range }) => {
            if (range) {
                const priority = calculatePriority(range, monacoSelection);
                if (priority) {
                    return Object.assign(Object.assign({}, priority), { error });
                }
            }
            return undefined;
        })
            .filter(core_1.notEmpty)
            .sort((left, right) => right.score - left.score) // highest first
            .map(({ error }) => error)
            .shift();
        if (error) {
            this.markAsCurrentError(error);
        }
        else {
            console.info('compiler-errors', `New (monaco) selection ${monacoSelection.toJSON()} does not intersect any error locations. Skipping.`);
        }
    }
    /**
     * This code does not deal with resource deletion, but tracks editor dispose events. It does not matter what was the cause of the editor disposal.
     * If editor closes, delete the decorators.
     */
    handleEditorDidDispose(uri) {
        let i = this.errors.length;
        // `splice` re-indexes the array. It's better to "iterate and modify" from the last element.
        while (i--) {
            const error = this.errors[i];
            if (error.uri === uri) {
                this.errors.splice(i, 1);
            }
        }
        this.onDidChangeEmitter.fire(this);
    }
    /**
     * If the text document changes in the line where compiler errors are, the compiler errors will be removed.
     */
    handleDocumentContentChange(monacoEditor, event) {
        const errorsPerResource = this.errors.filter((error) => error.uri === event.document.uri);
        let editorOrModel = monacoEditor;
        const doc = event.document;
        if (doc instanceof monaco_editor_model_1.MonacoEditorModel) {
            editorOrModel = doc.textEditorModel;
        }
        const rangesPerResource = ErrorDecoration.rangeOf(editorOrModel, errorsPerResource);
        const resolvedDecorations = rangesPerResource.map((range, index) => ({
            error: errorsPerResource[index],
            range,
        }));
        const decoratorsToRemove = event.contentChanges
            .map(({ range }) => this.p2m.asRange(range))
            .map((changedRange) => resolvedDecorations
            .filter(({ range: decorationRange }) => {
            if (!decorationRange) {
                return false;
            }
            const affects = changedRange.startLineNumber <= decorationRange.startLineNumber &&
                changedRange.endLineNumber >= decorationRange.endLineNumber;
            console.log('compiler-errors', `decoration range: ${decorationRange.toString()}, change range: ${changedRange.toString()}, affects: ${affects}`);
            return affects;
        })
            .map(({ error }) => {
            const index = this.errors.findIndex((candidate) => ErrorDecorationRef.sameAs(candidate, error));
            return index !== -1 ? { error, index } : undefined;
        })
            .filter(core_1.notEmpty))
            .reduce((acc, curr) => acc.concat(curr), [])
            .sort((left, right) => left.index - right.index); // highest index last
        if (decoratorsToRemove.length) {
            let i = decoratorsToRemove.length;
            while (i--) {
                this.errors.splice(decoratorsToRemove[i].index, 1);
            }
            monacoEditor.getControl().deltaDecorations(decoratorsToRemove.map(({ error }) => error.id), []);
            this.onDidChangeEmitter.fire(this);
        }
    }
    async trackEditors(errors, ...track) {
        return new core_1.DisposableCollection(...(await Promise.all(Array.from(errors.keys()).map(async (uri) => {
            const editor = await this.monacoEditor(uri);
            if (!editor) {
                return core_1.Disposable.NULL;
            }
            return new core_1.DisposableCollection(...track.map((t) => t(editor)));
        }))));
    }
    async markAsCurrentError(ref, options) {
        const index = this.errors.findIndex((candidate) => ErrorDecorationRef.sameAs(candidate, ref));
        if (index < 0) {
            console.warn('compiler-errors', `Failed to mark error ${ref.id} as the current one. Error is unknown. Known errors are: ${this.errors.map(({ id }) => id)}`);
            return;
        }
        const newError = this.errors[index];
        if ((options === null || options === void 0 ? void 0 : options.forceReselect) ||
            !this.currentError ||
            !ErrorDecorationRef.sameAs(this.currentError, newError)) {
            this.currentError = this.errors[index];
            console.log('compiler-errors', `Current error changed to ${this.currentError.id}`);
            if (options === null || options === void 0 ? void 0 : options.reveal) {
                this.currentErrorDidChangEmitter.fire(this.currentError);
            }
            this.onDidChangeEmitter.fire(this);
        }
    }
    // The double editor activation logic is required: https://github.com/eclipse-theia/theia/issues/11284
    async revealLocationInEditor(location) {
        const { uri, range } = location;
        const editor = await this.editorManager.getByUri(new uri_1.default(uri), {
            mode: 'activate',
        });
        if (editor && this.shell) {
            // to avoid flickering, reveal the range here and not with `getByUri`, because it uses `at: 'center'` for the reveal option.
            // TODO: check the community reaction whether it is better to set the focus at the error marker. it might cause flickering even if errors are close to each other
            editor.editor.revealRange(range, { at: this.revealStrategy });
            const activeWidget = await this.shell.activateWidget(editor.id);
            if (!activeWidget) {
                console.warn('compiler-errors', `editor widget activation has failed. editor widget ${editor.id} expected to be the active one.`);
                return editor;
            }
            if (editor !== activeWidget) {
                console.warn('compiler-errors', `active widget was not the same as previously activated editor. editor widget ID ${editor.id}, active widget ID: ${activeWidget.id}`);
            }
            return editor;
        }
        console.warn('compiler-errors', `could not find editor widget for URI: ${uri}`);
        return undefined;
    }
    groupBy(elements, extractKey) {
        return elements.reduce((acc, curr) => {
            const key = extractKey(curr);
            let values = acc.get(key);
            if (!values) {
                values = [];
                acc.set(key, values);
            }
            values.push(curr);
            return acc;
        }, new Map());
    }
    monacoEditor(uriOrWidget) {
        if (uriOrWidget instanceof browser_1.EditorWidget) {
            const editor = uriOrWidget.editor;
            if (editor instanceof monaco_editor_1.MonacoEditor) {
                return editor;
            }
            return undefined;
        }
        else {
            return this.editorManager
                .getByUri(new uri_1.default(uriOrWidget))
                .then((editor) => {
                if (editor) {
                    return this.monacoEditor(editor);
                }
                return undefined;
            });
        }
    }
};
__decorate([
    (0, inversify_1.inject)(editor_manager_1.EditorManager),
    __metadata("design:type", editor_manager_1.EditorManager)
], CompilerErrors.prototype, "editorManager", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_to_monaco_converter_1.ProtocolToMonacoConverter),
    __metadata("design:type", protocol_to_monaco_converter_1.ProtocolToMonacoConverter)
], CompilerErrors.prototype, "p2m", void 0);
__decorate([
    (0, inversify_1.inject)(monaco_to_protocol_converter_1.MonacoToProtocolConverter),
    __metadata("design:type", monaco_to_protocol_converter_1.MonacoToProtocolConverter)
], CompilerErrors.prototype, "m2p", void 0);
__decorate([
    (0, inversify_1.inject)(core_error_handler_1.CoreErrorHandler),
    __metadata("design:type", core_error_handler_1.CoreErrorHandler)
], CompilerErrors.prototype, "coreErrorHandler", void 0);
CompilerErrors = CompilerErrors_1 = __decorate([
    (0, inversify_1.injectable)()
], CompilerErrors);
exports.CompilerErrors = CompilerErrors;
(function (CompilerErrors) {
    let Commands;
    (function (Commands) {
        Commands.NEXT_ERROR = {
            id: 'arduino-editor-next-error',
        };
        Commands.PREVIOUS_ERROR = {
            id: 'arduino-editor-previous-error',
        };
        Commands.MARK_AS_CURRENT = {
            id: 'arduino-editor-mark-as-current-error',
        };
    })(Commands = CompilerErrors.Commands || (CompilerErrors.Commands = {}));
})(CompilerErrors = exports.CompilerErrors || (exports.CompilerErrors = {}));
exports.CompilerErrors = CompilerErrors;
//# sourceMappingURL=compiler-errors.js.map