"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CoreServiceContribution = exports.SketchContribution = exports.Contribution = exports.open = exports.Sketch = exports.URI = exports.TabBarToolbarRegistry = exports.KeybindingRegistry = exports.MenuModelRegistry = exports.CommandRegistry = exports.Command = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
exports.URI = uri_1.default;
const logger_1 = require("@theia/core/lib/common/logger");
const saveable_1 = require("@theia/core/lib/browser/saveable");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const label_provider_1 = require("@theia/core/lib/browser/label-provider");
const editor_manager_1 = require("@theia/editor/lib/browser/editor-manager");
const message_service_1 = require("@theia/core/lib/common/message-service");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const opener_service_1 = require("@theia/core/lib/browser/opener-service");
Object.defineProperty(exports, "open", { enumerable: true, get: function () { return opener_service_1.open; } });
const menu_1 = require("@theia/core/lib/common/menu");
Object.defineProperty(exports, "MenuModelRegistry", { enumerable: true, get: function () { return menu_1.MenuModelRegistry; } });
const keybinding_1 = require("@theia/core/lib/browser/keybinding");
Object.defineProperty(exports, "KeybindingRegistry", { enumerable: true, get: function () { return keybinding_1.KeybindingRegistry; } });
const tab_bar_toolbar_1 = require("@theia/core/lib/browser/shell/tab-bar-toolbar");
Object.defineProperty(exports, "TabBarToolbarRegistry", { enumerable: true, get: function () { return tab_bar_toolbar_1.TabBarToolbarRegistry; } });
const frontend_application_1 = require("@theia/core/lib/browser/frontend-application");
const command_1 = require("@theia/core/lib/common/command");
Object.defineProperty(exports, "Command", { enumerable: true, get: function () { return command_1.Command; } });
Object.defineProperty(exports, "CommandRegistry", { enumerable: true, get: function () { return command_1.CommandRegistry; } });
const settings_1 = require("../dialogs/settings/settings");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
const protocol_1 = require("../../common/protocol");
Object.defineProperty(exports, "Sketch", { enumerable: true, get: function () { return protocol_1.Sketch; } });
const arduino_preferences_1 = require("../arduino-preferences");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const core_1 = require("@theia/core");
const output_channel_1 = require("../theia/output/output-channel");
const clipboard_service_1 = require("@theia/core/lib/browser/clipboard-service");
const progressible_1 = require("../../common/protocol/progressible");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const boards_data_store_1 = require("../boards/boards-data-store");
const notifications_manager_1 = require("../theia/messages/notifications-manager");
const message_service_protocol_1 = require("@theia/core/lib/common/message-service-protocol");
let Contribution = class Contribution {
    init() {
        this.appStateService.reachedState('ready').then(() => this.onReady());
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-empty-function, unused-imports/no-unused-vars
    onStart(app) { }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-empty-function, unused-imports/no-unused-vars
    registerCommands(registry) { }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-empty-function, unused-imports/no-unused-vars
    registerMenus(registry) { }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-empty-function, unused-imports/no-unused-vars
    registerKeybindings(registry) { }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-empty-function, unused-imports/no-unused-vars
    registerToolbarItems(registry) { }
    // eslint-disable-next-line @typescript-eslint/no-empty-function
    onReady() { }
};
__decorate([
    (0, inversify_1.inject)(logger_1.ILogger),
    __metadata("design:type", Object)
], Contribution.prototype, "logger", void 0);
__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], Contribution.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(command_1.CommandService),
    __metadata("design:type", Object)
], Contribution.prototype, "commandService", void 0);
__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], Contribution.prototype, "workspaceService", void 0);
__decorate([
    (0, inversify_1.inject)(label_provider_1.LabelProvider),
    __metadata("design:type", label_provider_1.LabelProvider)
], Contribution.prototype, "labelProvider", void 0);
__decorate([
    (0, inversify_1.inject)(settings_1.SettingsService),
    __metadata("design:type", settings_1.SettingsService)
], Contribution.prototype, "settingsService", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], Contribution.prototype, "preferences", void 0);
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], Contribution.prototype, "appStateService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], Contribution.prototype, "init", null);
Contribution = __decorate([
    (0, inversify_1.injectable)()
], Contribution);
exports.Contribution = Contribution;
let SketchContribution = class SketchContribution extends Contribution {
    async sourceOverride() {
        const override = {};
        const sketch = await this.sketchServiceClient.currentSketch();
        if (sketches_service_client_impl_1.CurrentSketch.isValid(sketch)) {
            for (const editor of this.editorManager.all) {
                const uri = editor.editor.uri;
                if (saveable_1.Saveable.isDirty(editor) && protocol_1.Sketch.isInSketch(uri, sketch)) {
                    override[uri.toString()] = editor.editor.document.getText();
                }
            }
        }
        return override;
    }
};
__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], SketchContribution.prototype, "fileService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.FileSystemExt),
    __metadata("design:type", Object)
], SketchContribution.prototype, "fileSystemExt", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ConfigService),
    __metadata("design:type", Object)
], SketchContribution.prototype, "configService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.SketchesService),
    __metadata("design:type", Object)
], SketchContribution.prototype, "sketchService", void 0);
__decorate([
    (0, inversify_1.inject)(opener_service_1.OpenerService),
    __metadata("design:type", Object)
], SketchContribution.prototype, "openerService", void 0);
__decorate([
    (0, inversify_1.inject)(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], SketchContribution.prototype, "sketchServiceClient", void 0);
__decorate([
    (0, inversify_1.inject)(editor_manager_1.EditorManager),
    __metadata("design:type", editor_manager_1.EditorManager)
], SketchContribution.prototype, "editorManager", void 0);
__decorate([
    (0, inversify_1.inject)(output_channel_1.OutputChannelManager),
    __metadata("design:type", output_channel_1.OutputChannelManager)
], SketchContribution.prototype, "outputChannelManager", void 0);
SketchContribution = __decorate([
    (0, inversify_1.injectable)()
], SketchContribution);
exports.SketchContribution = SketchContribution;
let CoreServiceContribution = class CoreServiceContribution extends SketchContribution {
    clearVisibleNotification() {
        if (this.visibleNotificationId) {
            this.notificationManager.clear(this.visibleNotificationId);
            this.visibleNotificationId = undefined;
        }
    }
    handleError(error) {
        this.tryToastErrorMessage(error);
    }
    tryToastErrorMessage(error) {
        let message = undefined;
        if (protocol_1.CoreError.is(error)) {
            message = error.message;
        }
        else if (error instanceof Error) {
            message = error.message;
        }
        else if (typeof error === 'string') {
            message = error;
        }
        else {
            try {
                message = JSON.stringify(error);
            }
            catch (_a) { }
        }
        if (message) {
            if (message.includes('Missing FQBN (Fully Qualified Board Name)')) {
                message = core_1.nls.localize('arduino/coreContribution/noBoardSelected', 'No board selected. Please select your Arduino board from the Tools > Board menu.');
            }
            const copyAction = core_1.nls.localize('arduino/coreContribution/copyError', 'Copy error messages');
            this.visibleNotificationId = this.notificationId(message, copyAction);
            this.messageService.error(message, copyAction).then(async (action) => {
                if (action === copyAction) {
                    const content = await this.outputChannelManager.contentOfChannel('Arduino');
                    if (content) {
                        this.clipboardService.writeText(content);
                    }
                }
            });
        }
        else {
            throw error;
        }
    }
    async doWithProgress(options) {
        const { progressText, keepOutput, task } = options;
        this.outputChannelManager
            .getChannel('Arduino')
            .show({ preserveFocus: true });
        const result = await progressible_1.ExecuteWithProgress.doWithProgress({
            messageService: this.messageService,
            responseService: this.responseService,
            progressText,
            run: ({ progressId }) => task(progressId, this.coreService),
            keepOutput,
        });
        return result;
    }
    notificationId(message, ...actions) {
        return this.notificationManager.getMessageId({
            text: message,
            actions,
            type: message_service_protocol_1.MessageType.Error,
        });
    }
};
__decorate([
    (0, inversify_1.inject)(boards_data_store_1.BoardsDataStore),
    __metadata("design:type", boards_data_store_1.BoardsDataStore)
], CoreServiceContribution.prototype, "boardsDataStore", void 0);
__decorate([
    (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], CoreServiceContribution.prototype, "boardsServiceProvider", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.CoreService),
    __metadata("design:type", Object)
], CoreServiceContribution.prototype, "coreService", void 0);
__decorate([
    (0, inversify_1.inject)(clipboard_service_1.ClipboardService),
    __metadata("design:type", Object)
], CoreServiceContribution.prototype, "clipboardService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ResponseServiceClient),
    __metadata("design:type", Object)
], CoreServiceContribution.prototype, "responseService", void 0);
__decorate([
    (0, inversify_1.inject)(notifications_manager_1.NotificationManager),
    __metadata("design:type", notifications_manager_1.NotificationManager)
], CoreServiceContribution.prototype, "notificationManager", void 0);
CoreServiceContribution = __decorate([
    (0, inversify_1.injectable)()
], CoreServiceContribution);
exports.CoreServiceContribution = CoreServiceContribution;
(function (Contribution) {
    function configure(bind, serviceIdentifier) {
        bind(serviceIdentifier).toSelf().inSingletonScope();
        bind(command_1.CommandContribution).toService(serviceIdentifier);
        bind(menu_1.MenuContribution).toService(serviceIdentifier);
        bind(keybinding_1.KeybindingContribution).toService(serviceIdentifier);
        bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(serviceIdentifier);
        bind(frontend_application_1.FrontendApplicationContribution).toService(serviceIdentifier);
    }
    Contribution.configure = configure;
})(Contribution = exports.Contribution || (exports.Contribution = {}));
exports.Contribution = Contribution;
//# sourceMappingURL=contribution.js.map