"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CoreErrorHandler = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
const core_service_1 = require("../../common/protocol/core-service");
let CoreErrorHandler = class CoreErrorHandler {
    constructor() {
        this.errors = [];
        this.compilerErrorsDidChangeEmitter = new core_1.Emitter();
    }
    tryHandle(error) {
        if (core_service_1.CoreError.is(error)) {
            this.errors.length = 0;
            this.errors.push(...error.data);
            this.fireCompilerErrorsDidChange();
        }
    }
    reset() {
        this.errors.length = 0;
        this.fireCompilerErrorsDidChange();
    }
    get onCompilerErrorsDidChange() {
        return this.compilerErrorsDidChangeEmitter.event;
    }
    fireCompilerErrorsDidChange() {
        this.compilerErrorsDidChangeEmitter.fire(this.errors.slice());
    }
};
CoreErrorHandler = __decorate([
    (0, inversify_1.injectable)()
], CoreErrorHandler);
exports.CoreErrorHandler = CoreErrorHandler;
//# sourceMappingURL=core-error-handler.js.map