"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var Daemon_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Daemon = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
const protocol_1 = require("../../common/protocol");
const contribution_1 = require("./contribution");
let Daemon = Daemon_1 = class Daemon extends contribution_1.Contribution {
    registerCommands(registry) {
        registry.registerCommand(Daemon_1.Commands.START_DAEMON, {
            execute: () => this.daemon.start(),
        });
        registry.registerCommand(Daemon_1.Commands.STOP_DAEMON, {
            execute: () => this.daemon.stop(),
        });
        registry.registerCommand(Daemon_1.Commands.RESTART_DAEMON, {
            execute: () => this.daemon.restart(),
        });
    }
};
__decorate([
    (0, inversify_1.inject)(protocol_1.ArduinoDaemon),
    __metadata("design:type", Object)
], Daemon.prototype, "daemon", void 0);
Daemon = Daemon_1 = __decorate([
    (0, inversify_1.injectable)()
], Daemon);
exports.Daemon = Daemon;
(function (Daemon) {
    let Commands;
    (function (Commands) {
        Commands.START_DAEMON = {
            id: 'arduino-start-daemon',
            label: core_1.nls.localize('arduino/daemon/start', 'Start Daemon'),
            category: 'Arduino',
        };
        Commands.STOP_DAEMON = {
            id: 'arduino-stop-daemon',
            label: core_1.nls.localize('arduino/daemon/stop', 'Stop Daemon'),
            category: 'Arduino',
        };
        Commands.RESTART_DAEMON = {
            id: 'arduino-restart-daemon',
            label: core_1.nls.localize('arduino/daemon/restart', 'Restart Daemon'),
            category: 'Arduino',
        };
    })(Commands = Daemon.Commands || (Daemon.Commands = {}));
})(Daemon = exports.Daemon || (exports.Daemon = {}));
exports.Daemon = Daemon;
//# sourceMappingURL=daemon.js.map