"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var Debug_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Debug = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const event_1 = require("@theia/core/lib/common/event");
const hosted_plugin_1 = require("@theia/plugin-ext/lib/hosted/browser/hosted-plugin");
const arduino_toolbar_1 = require("../toolbar/arduino-toolbar");
const notification_center_1 = require("../notification-center");
const protocol_1 = require("../../common/protocol");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
const arduino_menus_1 = require("../menu/arduino-menus");
const main_menu_manager_1 = require("../../common/main-menu-manager");
const COMPILE_FOR_DEBUG_KEY = 'arduino-compile-for-debug';
let Debug = Debug_1 = class Debug extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        /**
         * If `undefined`, debugging is enabled. Otherwise, the reason why it's disabled.
         */
        this._disabledMessages = common_1.nls.localize('arduino/common/noBoardSelected', 'No board selected'); // Initial pessimism.
        this.disabledMessageDidChangeEmitter = new event_1.Emitter();
        this.onDisabledMessageDidChange = this.disabledMessageDidChangeEmitter.event;
        this.debugToolbarItem = {
            id: Debug_1.Commands.START_DEBUGGING.id,
            command: Debug_1.Commands.START_DEBUGGING.id,
            tooltip: `${this.disabledMessage
                ? common_1.nls.localize('arduino/debug/debugWithMessage', 'Debug - {0}', this.disabledMessage)
                : Debug_1.Commands.START_DEBUGGING.label}`,
            priority: 3,
            onDidChange: this.onDisabledMessageDidChange,
        };
    }
    get disabledMessage() {
        return this._disabledMessages;
    }
    set disabledMessage(message) {
        this._disabledMessages = message;
        this.disabledMessageDidChangeEmitter.fire(this._disabledMessages);
    }
    onStart() {
        this.onDisabledMessageDidChange(() => (this.debugToolbarItem.tooltip = `${this.disabledMessage
            ? common_1.nls.localize('arduino/debug/debugWithMessage', 'Debug - {0}', this.disabledMessage)
            : Debug_1.Commands.START_DEBUGGING.label}`));
        this.boardsServiceProvider.onBoardsConfigChanged(({ selectedBoard }) => this.refreshState(selectedBoard));
        this.notificationCenter.onPlatformDidInstall(() => this.refreshState());
        this.notificationCenter.onPlatformDidUninstall(() => this.refreshState());
    }
    onReady() {
        this.refreshState();
    }
    registerCommands(registry) {
        registry.registerCommand(Debug_1.Commands.START_DEBUGGING, {
            execute: () => this.startDebug(),
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            isEnabled: () => !this.disabledMessage,
        });
        registry.registerCommand(Debug_1.Commands.TOGGLE_OPTIMIZE_FOR_DEBUG, {
            execute: () => this.toggleCompileForDebug(),
            isToggled: () => this.compileForDebug,
        });
        registry.registerCommand(Debug_1.Commands.IS_OPTIMIZE_FOR_DEBUG, {
            execute: () => this.compileForDebug,
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem(this.debugToolbarItem);
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: Debug_1.Commands.TOGGLE_OPTIMIZE_FOR_DEBUG.id,
            label: Debug_1.Commands.TOGGLE_OPTIMIZE_FOR_DEBUG.label,
            order: '5',
        });
    }
    async refreshState(board = this.boardsServiceProvider.boardsConfig
        .selectedBoard) {
        if (!board) {
            this.disabledMessage = common_1.nls.localize('arduino/common/noBoardSelected', 'No board selected');
            return;
        }
        const fqbn = board.fqbn;
        if (!fqbn) {
            this.disabledMessage = common_1.nls.localize('arduino/debug/noPlatformInstalledFor', "Platform is not installed for '{0}'", board.name);
            return;
        }
        const details = await this.boardService.getBoardDetails({ fqbn });
        if (!details) {
            this.disabledMessage = common_1.nls.localize('arduino/debug/noPlatformInstalledFor', "Platform is not installed for '{0}'", board.name);
            return;
        }
        const { debuggingSupported } = details;
        if (!debuggingSupported) {
            this.disabledMessage = common_1.nls.localize('arduino/debug/debuggingNotSupported', "Debugging is not supported by '{0}'", board.name);
        }
        else {
            this.disabledMessage = undefined;
        }
    }
    async startDebug(board = this.boardsServiceProvider.boardsConfig
        .selectedBoard) {
        if (!board) {
            return;
        }
        const { name, fqbn } = board;
        if (!fqbn) {
            return;
        }
        await this.hostedPluginSupport.didStart;
        const [sketch, executables] = await Promise.all([
            this.sketchServiceClient.currentSketch(),
            this.executableService.list(),
        ]);
        if (!sketches_service_client_impl_1.CurrentSketch.isValid(sketch)) {
            return;
        }
        const ideTempFolderUri = await this.sketchService.getIdeTempFolderUri(sketch);
        const [cliPath, sketchPath, configPath] = await Promise.all([
            this.fileService.fsPath(new contribution_1.URI(executables.cliUri)),
            this.fileService.fsPath(new contribution_1.URI(sketch.uri)),
            this.fileService.fsPath(new contribution_1.URI(ideTempFolderUri)),
        ]);
        const config = {
            cliPath,
            board: {
                fqbn,
                name,
            },
            sketchPath,
            configPath,
        };
        return this.commandService.executeCommand('arduino.debug.start', config);
    }
    get compileForDebug() {
        const value = window.localStorage.getItem(COMPILE_FOR_DEBUG_KEY);
        return value === 'true';
    }
    async toggleCompileForDebug() {
        const oldState = this.compileForDebug;
        const newState = !oldState;
        window.localStorage.setItem(COMPILE_FOR_DEBUG_KEY, String(newState));
        this.mainMenuManager.update();
    }
};
__decorate([
    (0, inversify_1.inject)(hosted_plugin_1.HostedPluginSupport),
    __metadata("design:type", hosted_plugin_1.HostedPluginSupport)
], Debug.prototype, "hostedPluginSupport", void 0);
__decorate([
    (0, inversify_1.inject)(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], Debug.prototype, "notificationCenter", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ExecutableService),
    __metadata("design:type", Object)
], Debug.prototype, "executableService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.BoardsService),
    __metadata("design:type", Object)
], Debug.prototype, "boardService", void 0);
__decorate([
    (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], Debug.prototype, "boardsServiceProvider", void 0);
__decorate([
    (0, inversify_1.inject)(main_menu_manager_1.MainMenuManager),
    __metadata("design:type", Object)
], Debug.prototype, "mainMenuManager", void 0);
Debug = Debug_1 = __decorate([
    (0, inversify_1.injectable)()
], Debug);
exports.Debug = Debug;
(function (Debug) {
    let Commands;
    (function (Commands) {
        Commands.START_DEBUGGING = contribution_1.Command.toLocalizedCommand({
            id: 'arduino-start-debug',
            label: 'Start Debugging',
            category: 'Arduino',
        }, 'vscode/debug.contribution/startDebuggingHelp');
        Commands.TOGGLE_OPTIMIZE_FOR_DEBUG = contribution_1.Command.toLocalizedCommand({
            id: 'arduino-toggle-optimize-for-debug',
            label: 'Optimize for Debugging',
            category: 'Arduino',
        }, 'arduino/debug/optimizeForDebugging');
        Commands.IS_OPTIMIZE_FOR_DEBUG = {
            id: 'arduino-is-optimize-for-debug',
        };
    })(Commands = Debug.Commands || (Debug.Commands = {}));
})(Debug = exports.Debug || (exports.Debug = {}));
exports.Debug = Debug;
//# sourceMappingURL=debug.js.map