"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var EditContributions_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditContributions = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const common_frontend_contribution_1 = require("@theia/core/lib/browser/common-frontend-contribution");
const clipboard_service_1 = require("@theia/core/lib/browser/clipboard-service");
const monaco_editor_service_1 = require("@theia/monaco/lib/browser/monaco-editor-service");
const contribution_1 = require("./contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const common_1 = require("@theia/core/lib/common");
// TODO: [macOS]: to remove `Start Dictation...` and `Emoji & Symbol` see this thread: https://github.com/electron/electron/issues/8283#issuecomment-269522072
// Depends on https://github.com/eclipse-theia/theia/pull/7964
let EditContributions = EditContributions_1 = class EditContributions extends contribution_1.Contribution {
    registerCommands(registry) {
        registry.registerCommand(EditContributions_1.Commands.GO_TO_LINE, {
            execute: () => this.run('editor.action.gotoLine'),
        });
        registry.registerCommand(EditContributions_1.Commands.TOGGLE_COMMENT, {
            execute: () => this.run('editor.action.commentLine'),
        });
        registry.registerCommand(EditContributions_1.Commands.INDENT_LINES, {
            execute: () => this.run('editor.action.indentLines'),
        });
        registry.registerCommand(EditContributions_1.Commands.OUTDENT_LINES, {
            execute: () => this.run('editor.action.outdentLines'),
        });
        registry.registerCommand(EditContributions_1.Commands.FIND, {
            execute: () => this.run('actions.find'),
        });
        registry.registerCommand(EditContributions_1.Commands.FIND_NEXT, {
            execute: () => this.run('editor.action.nextMatchFindAction'),
        });
        registry.registerCommand(EditContributions_1.Commands.FIND_PREVIOUS, {
            execute: () => this.run('editor.action.previousMatchFindAction'),
        });
        registry.registerCommand(EditContributions_1.Commands.USE_FOR_FIND, {
            execute: () => this.run('editor.action.previousSelectionMatchFindAction'),
        });
        registry.registerCommand(EditContributions_1.Commands.INCREASE_FONT_SIZE, {
            execute: async () => {
                const settings = await this.settingsService.settings();
                if (settings.autoScaleInterface) {
                    settings.interfaceScale = settings.interfaceScale + 1;
                }
                else {
                    settings.editorFontSize = settings.editorFontSize + 1;
                }
                await this.settingsService.update(settings);
                await this.settingsService.save();
            },
        });
        registry.registerCommand(EditContributions_1.Commands.DECREASE_FONT_SIZE, {
            execute: async () => {
                const settings = await this.settingsService.settings();
                if (settings.autoScaleInterface) {
                    settings.interfaceScale = settings.interfaceScale - 1;
                }
                else {
                    settings.editorFontSize = settings.editorFontSize - 1;
                }
                await this.settingsService.update(settings);
                await this.settingsService.save();
            },
        });
        /* Tools */ registry.registerCommand(EditContributions_1.Commands.AUTO_FORMAT, { execute: () => this.run('editor.action.formatDocument') });
        registry.registerCommand(EditContributions_1.Commands.COPY_FOR_FORUM, {
            execute: async () => {
                const value = await this.currentValue();
                if (value !== undefined) {
                    this.clipboardService.writeText(`\`\`\`cpp
${value}
\`\`\``);
                }
            },
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__TEXT_CONTROL_GROUP, {
            commandId: common_frontend_contribution_1.CommonCommands.CUT.id,
            order: '0',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__TEXT_CONTROL_GROUP, {
            commandId: common_frontend_contribution_1.CommonCommands.COPY.id,
            order: '1',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__TEXT_CONTROL_GROUP, {
            commandId: EditContributions_1.Commands.COPY_FOR_FORUM.id,
            label: common_1.nls.localize('arduino/editor/copyForForum', 'Copy for Forum (Markdown)'),
            order: '2',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__TEXT_CONTROL_GROUP, {
            commandId: common_frontend_contribution_1.CommonCommands.PASTE.id,
            order: '3',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__TEXT_CONTROL_GROUP, {
            commandId: common_frontend_contribution_1.CommonCommands.SELECT_ALL.id,
            order: '4',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__TEXT_CONTROL_GROUP, {
            commandId: EditContributions_1.Commands.GO_TO_LINE.id,
            label: common_1.nls.localize('vscode/standaloneStrings/gotoLineActionLabel', 'Go to Line...'),
            order: '5',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__CODE_CONTROL_GROUP, {
            commandId: EditContributions_1.Commands.TOGGLE_COMMENT.id,
            label: common_1.nls.localize('arduino/editor/commentUncomment', 'Comment/Uncomment'),
            order: '0',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__CODE_CONTROL_GROUP, {
            commandId: EditContributions_1.Commands.INDENT_LINES.id,
            label: common_1.nls.localize('arduino/editor/increaseIndent', 'Increase Indent'),
            order: '1',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__CODE_CONTROL_GROUP, {
            commandId: EditContributions_1.Commands.OUTDENT_LINES.id,
            label: common_1.nls.localize('arduino/editor/decreaseIndent', 'Decrease Indent'),
            order: '2',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__CODE_CONTROL_GROUP, {
            commandId: EditContributions_1.Commands.AUTO_FORMAT.id,
            label: common_1.nls.localize('arduino/editor/autoFormat', 'Auto Format'),
            order: '3',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__FONT_CONTROL_GROUP, {
            commandId: EditContributions_1.Commands.INCREASE_FONT_SIZE.id,
            label: common_1.nls.localize('arduino/editor/increaseFontSize', 'Increase Font Size'),
            order: '0',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__FONT_CONTROL_GROUP, {
            commandId: EditContributions_1.Commands.DECREASE_FONT_SIZE.id,
            label: common_1.nls.localize('arduino/editor/decreaseFontSize', 'Decrease Font Size'),
            order: '1',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__FIND_GROUP, {
            commandId: EditContributions_1.Commands.FIND.id,
            label: common_1.nls.localize('vscode/findController/startFindAction', 'Find'),
            order: '0',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__FIND_GROUP, {
            commandId: EditContributions_1.Commands.FIND_NEXT.id,
            label: common_1.nls.localize('vscode/findController/findNextMatchAction', 'Find Next'),
            order: '1',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__FIND_GROUP, {
            commandId: EditContributions_1.Commands.FIND_PREVIOUS.id,
            label: common_1.nls.localize('vscode/findController/findPreviousMatchAction', 'Find Previous'),
            order: '2',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.EDIT__FIND_GROUP, {
            commandId: EditContributions_1.Commands.USE_FOR_FIND.id,
            label: common_1.nls.localize('vscode/findController/startFindWithSelectionAction', 'Use Selection for Find'),
            order: '3',
        });
        // `Tools`
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__MAIN_GROUP, {
            commandId: EditContributions_1.Commands.AUTO_FORMAT.id,
            label: common_1.nls.localize('arduino/editor/autoFormat', 'Auto Format'),
            order: '0',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: EditContributions_1.Commands.COPY_FOR_FORUM.id,
            keybinding: 'CtrlCmd+Shift+C',
            when: 'editorFocus',
        });
        registry.registerKeybinding({
            command: EditContributions_1.Commands.GO_TO_LINE.id,
            keybinding: 'CtrlCmd+L',
            when: 'editorFocus',
        });
        registry.registerKeybinding({
            command: EditContributions_1.Commands.TOGGLE_COMMENT.id,
            keybinding: 'CtrlCmd+/',
            when: 'editorFocus',
        });
        registry.registerKeybinding({
            command: EditContributions_1.Commands.INCREASE_FONT_SIZE.id,
            keybinding: 'CtrlCmd+=',
        });
        registry.registerKeybinding({
            command: EditContributions_1.Commands.DECREASE_FONT_SIZE.id,
            keybinding: 'CtrlCmd+-',
        });
        registry.registerKeybinding({
            command: EditContributions_1.Commands.FIND.id,
            keybinding: 'CtrlCmd+F',
        });
        registry.registerKeybinding({
            command: EditContributions_1.Commands.FIND_NEXT.id,
            keybinding: 'CtrlCmd+G',
        });
        registry.registerKeybinding({
            command: EditContributions_1.Commands.FIND_PREVIOUS.id,
            keybinding: 'CtrlCmd+Shift+G',
        });
        registry.registerKeybinding({
            command: EditContributions_1.Commands.USE_FOR_FIND.id,
            keybinding: 'CtrlCmd+E',
        });
        // `Tools`
        registry.registerKeybinding({
            command: EditContributions_1.Commands.AUTO_FORMAT.id,
            keybinding: 'CtrlCmd+T',
        });
    }
    async current() {
        return (this.codeEditorService.getFocusedCodeEditor() ||
            this.codeEditorService.getActiveCodeEditor() ||
            undefined);
    }
    async currentValue() {
        var _a;
        const currentEditor = await this.current();
        if (currentEditor) {
            const selection = currentEditor.getSelection();
            if (!selection || selection.isEmpty()) {
                return currentEditor.getValue();
            }
            return (_a = currentEditor.getModel()) === null || _a === void 0 ? void 0 : _a.getValueInRange(selection);
        }
        return undefined;
    }
    async run(commandId) {
        const editor = await this.current();
        if (editor) {
            const action = editor.getAction(commandId);
            if (action) {
                return action.run();
            }
        }
    }
};
__decorate([
    (0, inversify_1.inject)(monaco_editor_service_1.MonacoEditorService),
    __metadata("design:type", monaco_editor_service_1.MonacoEditorService)
], EditContributions.prototype, "codeEditorService", void 0);
__decorate([
    (0, inversify_1.inject)(clipboard_service_1.ClipboardService),
    __metadata("design:type", Object)
], EditContributions.prototype, "clipboardService", void 0);
EditContributions = EditContributions_1 = __decorate([
    (0, inversify_1.injectable)()
], EditContributions);
exports.EditContributions = EditContributions;
(function (EditContributions) {
    let Commands;
    (function (Commands) {
        Commands.COPY_FOR_FORUM = {
            id: 'arduino-copy-for-forum',
        };
        Commands.GO_TO_LINE = {
            id: 'arduino-go-to-line',
        };
        Commands.TOGGLE_COMMENT = {
            id: 'arduino-toggle-comment',
        };
        Commands.INDENT_LINES = {
            id: 'arduino-indent-lines',
        };
        Commands.OUTDENT_LINES = {
            id: 'arduino-outdent-lines',
        };
        Commands.FIND = {
            id: 'arduino-find',
        };
        Commands.FIND_NEXT = {
            id: 'arduino-find-next',
        };
        Commands.FIND_PREVIOUS = {
            id: 'arduino-find-previous',
        };
        Commands.USE_FOR_FIND = {
            id: 'arduino-for-find',
        };
        Commands.INCREASE_FONT_SIZE = {
            id: 'arduino-increase-font-size',
        };
        Commands.DECREASE_FONT_SIZE = {
            id: 'arduino-decrease-font-size',
        };
        Commands.AUTO_FORMAT = {
            id: 'arduino-auto-format', // `Auto Format` should belong to `Tool`.
        };
    })(Commands = EditContributions.Commands || (EditContributions.Commands = {}));
})(EditContributions = exports.EditContributions || (exports.EditContributions = {}));
exports.EditContributions = EditContributions;
//# sourceMappingURL=edit-contributions.js.map