"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var FirstStartupInstaller_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirstStartupInstaller = void 0;
const browser_1 = require("@theia/core/lib/browser");
const inversify_1 = require("@theia/core/shared/inversify");
const protocol_1 = require("../../common/protocol");
const contribution_1 = require("./contribution");
let FirstStartupInstaller = FirstStartupInstaller_1 = class FirstStartupInstaller extends contribution_1.Contribution {
    async onReady() {
        const isFirstStartup = !(await this.localStorageService.getData(FirstStartupInstaller_1.INIT_LIBS_AND_PACKAGES));
        if (isFirstStartup) {
            const avrPackage = await this.boardsService.getBoardPackage({
                id: 'arduino:avr',
            });
            const builtInLibrary = (await this.libraryService.search({ query: 'Arduino_BuiltIn' }))[0];
            let avrPackageError;
            let builtInLibraryError;
            if (avrPackage) {
                try {
                    await this.boardsService.install({
                        item: avrPackage,
                        noOverwrite: true, // We don't want to automatically replace custom platforms the user might already have in place
                    });
                }
                catch (e) {
                    // There's no error code, I need to parse the error message: https://github.com/arduino/arduino-cli/commit/ffe4232b359fcfa87238d68acf1c3b64a1621f14#diff-10ffbdde46838dd9caa881fd1f2a5326a49f8061f6cfd7c9d430b4875a6b6895R62
                    if (e.message.includes(`Platform ${avrPackage.id}@${avrPackage.installedVersion} already installed`)) {
                        // If arduino:avr installation fails because it's already installed we don't want to retry on next start-up
                        console.error(e);
                    }
                    else {
                        // But if there is any other error (e.g.: no Internet connection), we want to retry next time
                        avrPackageError = e;
                    }
                }
            }
            else {
                avrPackageError = new Error('Could not find platform.');
            }
            if (builtInLibrary) {
                try {
                    await this.libraryService.install({
                        item: builtInLibrary,
                        installDependencies: true,
                        noOverwrite: true,
                        installLocation: protocol_1.LibraryLocation.BUILTIN,
                    });
                }
                catch (e) {
                    // There's no error code, I need to parse the error message: https://github.com/arduino/arduino-cli/commit/2ea3608453b17b1157f8a1dc892af2e13e40f4f0#diff-1de7569144d4e260f8dde0e0d00a4e2a218c57966d583da1687a70d518986649R95
                    if (/Library (.*) is already installed/.test(e.message)) {
                        // If Arduino_BuiltIn installation fails because it's already installed we don't want to retry on next start-up
                        console.log('error installing core', e);
                    }
                    else {
                        // But if there is any other error (e.g.: no Internet connection), we want to retry next time
                        builtInLibraryError = e;
                    }
                }
            }
            else {
                builtInLibraryError = new Error('Could not find library');
            }
            if (avrPackageError) {
                this.messageService.error(`Could not install Arduino AVR platform: ${avrPackageError}`);
            }
            if (builtInLibraryError) {
                this.messageService.error(`Could not install ${builtInLibrary.name} library: ${builtInLibraryError}`);
            }
            if (!avrPackageError && !builtInLibraryError) {
                await this.localStorageService.setData(FirstStartupInstaller_1.INIT_LIBS_AND_PACKAGES, true);
            }
        }
    }
};
__decorate([
    (0, inversify_1.inject)(browser_1.LocalStorageService),
    __metadata("design:type", browser_1.LocalStorageService)
], FirstStartupInstaller.prototype, "localStorageService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.BoardsService),
    __metadata("design:type", Object)
], FirstStartupInstaller.prototype, "boardsService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.LibraryService),
    __metadata("design:type", Object)
], FirstStartupInstaller.prototype, "libraryService", void 0);
FirstStartupInstaller = FirstStartupInstaller_1 = __decorate([
    (0, inversify_1.injectable)()
], FirstStartupInstaller);
exports.FirstStartupInstaller = FirstStartupInstaller;
(function (FirstStartupInstaller) {
    FirstStartupInstaller.INIT_LIBS_AND_PACKAGES = 'initializedLibsAndPackages';
})(FirstStartupInstaller = exports.FirstStartupInstaller || (exports.FirstStartupInstaller = {}));
exports.FirstStartupInstaller = FirstStartupInstaller;
//# sourceMappingURL=first-startup-installer.js.map