"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Format = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const monaco = require("@theia/monaco-editor-core");
const formatter_1 = require("../../common/protocol/formatter");
const selectors_1 = require("../selectors");
const contribution_1 = require("./contribution");
let Format = class Format extends contribution_1.Contribution {
    onStart() {
        monaco.languages.registerDocumentRangeFormattingEditProvider(selectors_1.InoSelector, this);
        monaco.languages.registerDocumentFormattingEditProvider(selectors_1.InoSelector, this);
    }
    async provideDocumentRangeFormattingEdits(model, range, options, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    _token) {
        const text = await this.format(model, range, options);
        return [{ range, text }];
    }
    async provideDocumentFormattingEdits(model, options, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    _token) {
        const range = model.getFullModelRange();
        const text = await this.format(model, range, options);
        return [{ range, text }];
    }
    /**
     * From the currently opened workspaces (IDE2 has always one), it calculates all possible
     * folder locations where the `.clang-format` file could be.
     */
    formatterConfigFolderUris(model) {
        const editorUri = new contribution_1.URI(model.uri.toString());
        return this.workspaceService
            .tryGetRoots()
            .map(({ resource }) => resource)
            .filter((workspaceUri) => workspaceUri.isEqualOrParent(editorUri))
            .map((uri) => uri.toString());
    }
    format(model, range, options) {
        console.info(`Formatting ${model.uri.toString()} [Range: ${JSON.stringify(range.toJSON())}]`);
        const content = model.getValueInRange(range);
        const formatterConfigFolderUris = this.formatterConfigFolderUris(model);
        return this.formatter.format({
            content,
            formatterConfigFolderUris,
            options,
        });
    }
};
__decorate([
    (0, inversify_1.inject)(formatter_1.Formatter),
    __metadata("design:type", Object)
], Format.prototype, "formatter", void 0);
Format = __decorate([
    (0, inversify_1.injectable)()
], Format);
exports.Format = Format;
//# sourceMappingURL=format.js.map