"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IndexesUpdateProgress = void 0;
const progress_service_1 = require("@theia/core/lib/common/progress-service");
const inversify_1 = require("@theia/core/shared/inversify");
const protocol_1 = require("../../common/protocol");
const notification_center_1 = require("../notification-center");
const contribution_1 = require("./contribution");
let IndexesUpdateProgress = class IndexesUpdateProgress extends contribution_1.Contribution {
    onStart() {
        this.notificationCenter.onIndexWillUpdate((progressId) => this.getOrCreateProgress(progressId));
        this.notificationCenter.onIndexUpdateDidProgress((progress) => {
            this.getOrCreateProgress(progress).then((delegate) => delegate.report(progress));
        });
        this.notificationCenter.onIndexDidUpdate((progressId) => {
            this.cancelProgress(progressId);
        });
        this.notificationCenter.onIndexUpdateDidFail(({ progressId, message }) => {
            this.cancelProgress(progressId);
            this.messageService.error(message);
        });
    }
    async getOrCreateProgress(progressOrId) {
        var _a;
        const progressId = protocol_1.ProgressMessage.is(progressOrId)
            ? progressOrId.progressId
            : progressOrId;
        if (((_a = this.currentProgress) === null || _a === void 0 ? void 0 : _a.progressId) === progressId) {
            return this.currentProgress;
        }
        if (this.currentProgress) {
            this.currentProgress.cancel();
        }
        this.currentProgress = undefined;
        const progress = await this.progressService.showProgress({
            text: '',
            options: { location: 'notification' },
        });
        if (protocol_1.ProgressMessage.is(progressOrId)) {
            progress.report(progressOrId);
        }
        this.currentProgress = Object.assign(Object.assign({}, progress), { progressId });
        return this.currentProgress;
    }
    cancelProgress(progressId) {
        if (this.currentProgress) {
            if (this.currentProgress.progressId !== progressId) {
                console.warn(`Mismatching progress IDs. Expected ${progressId}, got ${this.currentProgress.progressId}. Canceling anyway.`);
            }
            this.currentProgress.cancel();
            this.currentProgress = undefined;
        }
    }
};
__decorate([
    (0, inversify_1.inject)(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], IndexesUpdateProgress.prototype, "notificationCenter", void 0);
__decorate([
    (0, inversify_1.inject)(progress_service_1.ProgressService),
    __metadata("design:type", progress_service_1.ProgressService)
], IndexesUpdateProgress.prototype, "progressService", void 0);
IndexesUpdateProgress = __decorate([
    (0, inversify_1.injectable)()
], IndexesUpdateProgress);
exports.IndexesUpdateProgress = IndexesUpdateProgress;
//# sourceMappingURL=indexes-update-progress.js.map