"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InoLanguage = void 0;
const async_mutex_1 = require("async-mutex");
const inversify_1 = require("@theia/core/shared/inversify");
const protocol_1 = require("../../common/protocol");
const hosted_plugin_events_1 = require("../hosted-plugin-events");
const contribution_1 = require("./contribution");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
const boards_service_provider_1 = require("../boards/boards-service-provider");
let InoLanguage = class InoLanguage extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.languageServerStartMutex = new async_mutex_1.Mutex();
    }
    onReady() {
        const start = ({ selectedBoard }, forceStart = false) => {
            if (selectedBoard) {
                const { name, fqbn } = selectedBoard;
                if (fqbn) {
                    this.startLanguageServer(fqbn, name, forceStart);
                }
            }
        };
        this.boardsServiceProvider.onBoardsConfigChanged(start);
        this.hostedPluginEvents.onPluginsDidStart(() => start(this.boardsServiceProvider.boardsConfig));
        this.hostedPluginEvents.onPluginsWillUnload(() => (this.languageServerFqbn = undefined));
        this.preferences.onPreferenceChanged(({ preferenceName, oldValue, newValue }) => {
            if (oldValue !== newValue) {
                switch (preferenceName) {
                    case 'arduino.language.log':
                    case 'arduino.language.realTimeDiagnostics':
                        start(this.boardsServiceProvider.boardsConfig, true);
                }
            }
        });
        start(this.boardsServiceProvider.boardsConfig);
    }
    async startLanguageServer(fqbn, name, forceStart = false) {
        const port = await this.daemon.tryGetPort();
        if (!port) {
            return;
        }
        const release = await this.languageServerStartMutex.acquire();
        try {
            await this.hostedPluginEvents.didStart;
            const details = await this.boardsService.getBoardDetails({ fqbn });
            if (!details) {
                // Core is not installed for the selected board.
                console.info(`Could not start language server for ${fqbn}. The core is not installed for the board.`);
                if (this.languageServerFqbn) {
                    try {
                        await this.commandService.executeCommand('arduino.languageserver.stop');
                        console.info(`Stopped language server process for ${this.languageServerFqbn}.`);
                        this.languageServerFqbn = undefined;
                    }
                    catch (e) {
                        console.error(`Failed to start language server process for ${this.languageServerFqbn}`, e);
                        throw e;
                    }
                }
                return;
            }
            if (!forceStart && fqbn === this.languageServerFqbn) {
                // NOOP
                return;
            }
            this.logger.info(`Starting language server: ${fqbn}`);
            const log = this.preferences.get('arduino.language.log');
            const realTimeDiagnostics = this.preferences.get('arduino.language.realTimeDiagnostics');
            let currentSketchPath = undefined;
            if (log) {
                const currentSketch = await this.sketchServiceClient.currentSketch();
                if (sketches_service_client_impl_1.CurrentSketch.isValid(currentSketch)) {
                    currentSketchPath = await this.fileService.fsPath(new contribution_1.URI(currentSketch.uri));
                }
            }
            const { clangdUri, lsUri } = await this.executableService.list();
            const [clangdPath, lsPath] = await Promise.all([
                this.fileService.fsPath(new contribution_1.URI(clangdUri)),
                this.fileService.fsPath(new contribution_1.URI(lsUri)),
            ]);
            this.languageServerFqbn = await Promise.race([
                new Promise((_, reject) => setTimeout(() => reject(new Error(`Timeout after ${20000} ms.`)), 20000)),
                this.commandService.executeCommand('arduino.languageserver.start', {
                    lsPath,
                    cliDaemonAddr: `localhost:${port}`,
                    clangdPath,
                    log: currentSketchPath ? currentSketchPath : log,
                    cliDaemonInstance: '1',
                    board: {
                        fqbn,
                        name: name ? `"${name}"` : undefined,
                    },
                    realTimeDiagnostics,
                    silentOutput: true,
                }),
            ]);
        }
        catch (e) {
            console.log(`Failed to start language server for ${fqbn}`, e);
            this.languageServerFqbn = undefined;
        }
        finally {
            release();
        }
    }
};
__decorate([
    (0, inversify_1.inject)(hosted_plugin_events_1.HostedPluginEvents),
    __metadata("design:type", hosted_plugin_events_1.HostedPluginEvents)
], InoLanguage.prototype, "hostedPluginEvents", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ExecutableService),
    __metadata("design:type", Object)
], InoLanguage.prototype, "executableService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ArduinoDaemon),
    __metadata("design:type", Object)
], InoLanguage.prototype, "daemon", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.BoardsService),
    __metadata("design:type", Object)
], InoLanguage.prototype, "boardsService", void 0);
__decorate([
    (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], InoLanguage.prototype, "boardsServiceProvider", void 0);
InoLanguage = __decorate([
    (0, inversify_1.injectable)()
], InoLanguage);
exports.InoLanguage = InoLanguage;
//# sourceMappingURL=ino-language.js.map