"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var NewSketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewSketch = void 0;
const common_1 = require("@theia/core/lib/common");
const inversify_1 = require("@theia/core/shared/inversify");
const arduino_menus_1 = require("../menu/arduino-menus");
const arduino_toolbar_1 = require("../toolbar/arduino-toolbar");
const contribution_1 = require("./contribution");
let NewSketch = NewSketch_1 = class NewSketch extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(NewSketch_1.Commands.NEW_SKETCH, {
            execute: () => this.newSketch(),
        });
        registry.registerCommand(NewSketch_1.Commands.NEW_SKETCH__TOOLBAR, {
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            execute: () => registry.executeCommand(NewSketch_1.Commands.NEW_SKETCH.id),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__SKETCH_GROUP, {
            commandId: NewSketch_1.Commands.NEW_SKETCH.id,
            label: common_1.nls.localize('arduino/sketch/new', 'New'),
            order: '0',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: NewSketch_1.Commands.NEW_SKETCH.id,
            keybinding: 'CtrlCmd+N',
        });
    }
    async newSketch() {
        try {
            const sketch = await this.sketchService.createNewSketch();
            this.workspaceService.open(new contribution_1.URI(sketch.uri));
        }
        catch (e) {
            await this.messageService.error(e.toString());
        }
    }
};
NewSketch = NewSketch_1 = __decorate([
    (0, inversify_1.injectable)()
], NewSketch);
exports.NewSketch = NewSketch;
(function (NewSketch) {
    let Commands;
    (function (Commands) {
        Commands.NEW_SKETCH = {
            id: 'arduino-new-sketch',
        };
        Commands.NEW_SKETCH__TOOLBAR = {
            id: 'arduino-new-sketch--toolbar',
        };
    })(Commands = NewSketch.Commands || (NewSketch.Commands = {}));
})(NewSketch = exports.NewSketch || (exports.NewSketch = {}));
exports.NewSketch = NewSketch;
//# sourceMappingURL=new-sketch.js.map