"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var OpenSketchFiles_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSketchFiles = void 0;
const nls_1 = require("@theia/core/lib/common/nls");
const inversify_1 = require("@theia/core/shared/inversify");
const nls_2 = require("../../common/nls");
const protocol_1 = require("../../common/protocol");
const contribution_1 = require("./contribution");
const save_as_sketch_1 = require("./save-as-sketch");
let OpenSketchFiles = OpenSketchFiles_1 = class OpenSketchFiles extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(OpenSketchFiles_1.Commands.OPEN_SKETCH_FILES, {
            execute: (uri) => this.openSketchFiles(uri),
        });
        registry.registerCommand(OpenSketchFiles_1.Commands.ENSURE_OPENED, {
            execute: (uri, forceOpen, options) => {
                this.ensureOpened(uri, forceOpen, options);
            },
        });
    }
    async openSketchFiles(uri) {
        try {
            const sketch = await this.sketchService.loadSketch(uri.toString());
            const { mainFileUri, rootFolderFileUris } = sketch;
            for (const uri of [mainFileUri, ...rootFolderFileUris]) {
                await this.ensureOpened(uri);
            }
            if (mainFileUri.endsWith('.pde')) {
                const message = nls_1.nls.localize('arduino/common/oldFormat', "The '{0}' still uses the old `.pde` format. Do you want to switch to the new `.ino` extension?", sketch.name);
                const yes = nls_1.nls.localize('vscode/extensionsUtils/yes', 'Yes');
                this.messageService.info(message, nls_2.Later, yes).then((answer) => {
                    if (answer === yes) {
                        this.commandService.executeCommand(save_as_sketch_1.SaveAsSketch.Commands.SAVE_AS_SKETCH.id, {
                            execOnlyIfTemp: false,
                            openAfterMove: true,
                            wipeOriginal: false,
                        });
                    }
                });
            }
        }
        catch (err) {
            if (protocol_1.SketchesError.NotFound.is(err)) {
                this.openFallbackSketch();
            }
            else {
                console.error(err);
                const message = err instanceof Error
                    ? err.message
                    : typeof err === 'string'
                        ? err
                        : String(err);
                this.messageService.error(message);
            }
        }
    }
    async openFallbackSketch() {
        const sketch = await this.sketchService.createNewSketch();
        this.workspaceService.open(new contribution_1.URI(sketch.uri), { preserveWindow: true });
    }
    async ensureOpened(uri, forceOpen = false, options) {
        const widget = this.editorManager.all.find((widget) => widget.editor.uri.toString() === uri);
        if (!widget || forceOpen) {
            return this.editorManager.open(new contribution_1.URI(uri), options !== null && options !== void 0 ? options : {
                mode: 'reveal',
                preview: false,
                counter: 0,
            });
        }
    }
};
OpenSketchFiles = OpenSketchFiles_1 = __decorate([
    (0, inversify_1.injectable)()
], OpenSketchFiles);
exports.OpenSketchFiles = OpenSketchFiles;
(function (OpenSketchFiles) {
    let Commands;
    (function (Commands) {
        Commands.OPEN_SKETCH_FILES = {
            id: 'arduino-open-sketch-files',
        };
        Commands.ENSURE_OPENED = {
            id: 'arduino-ensure-opened',
        };
    })(Commands = OpenSketchFiles.Commands || (OpenSketchFiles.Commands = {}));
})(OpenSketchFiles = exports.OpenSketchFiles || (exports.OpenSketchFiles = {}));
exports.OpenSketchFiles = OpenSketchFiles;
//# sourceMappingURL=open-sketch-files.js.map