"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var OpenSketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSketch = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const browser_1 = require("@theia/core/lib/browser");
const disposable_1 = require("@theia/core/lib/common/disposable");
const arduino_menus_1 = require("../menu/arduino-menus");
const arduino_toolbar_1 = require("../toolbar/arduino-toolbar");
const contribution_1 = require("./contribution");
const examples_service_1 = require("../../common/protocol/examples-service");
const examples_1 = require("./examples");
const sketchbook_1 = require("./sketchbook");
const protocol_1 = require("../../common/protocol");
const common_1 = require("@theia/core/lib/common");
let OpenSketch = OpenSketch_1 = class OpenSketch extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.toDispose = new disposable_1.DisposableCollection();
    }
    registerCommands(registry) {
        registry.registerCommand(OpenSketch_1.Commands.OPEN_SKETCH, {
            execute: (arg) => contribution_1.Sketch.is(arg) ? this.openSketch(arg) : this.openSketch(),
        });
        registry.registerCommand(OpenSketch_1.Commands.OPEN_SKETCH__TOOLBAR, {
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            execute: async (_, target) => {
                const container = await this.sketchService.getSketches({
                    exclude: ['**/hardware/**'],
                });
                if (protocol_1.SketchContainer.isEmpty(container)) {
                    this.openSketch();
                }
                else {
                    this.toDispose.dispose();
                    if (!(target instanceof HTMLElement)) {
                        return;
                    }
                    const { parentElement } = target;
                    if (!parentElement) {
                        return;
                    }
                    this.menuRegistry.registerMenuAction(arduino_menus_1.ArduinoMenus.OPEN_SKETCH__CONTEXT__OPEN_GROUP, {
                        commandId: OpenSketch_1.Commands.OPEN_SKETCH.id,
                        label: common_1.nls.localize('vscode/workspaceActions/openFileFolder', 'Open...'),
                    });
                    this.toDispose.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(OpenSketch_1.Commands.OPEN_SKETCH)));
                    this.sketchbook.registerRecursively([...container.children, ...container.sketches], arduino_menus_1.ArduinoMenus.OPEN_SKETCH__CONTEXT__RECENT_GROUP, this.toDispose);
                    try {
                        const containers = await this.examplesService.builtIns();
                        for (const container of containers) {
                            this.builtInExamples.registerRecursively(container, arduino_menus_1.ArduinoMenus.OPEN_SKETCH__CONTEXT__EXAMPLES_GROUP, this.toDispose);
                        }
                    }
                    catch (e) {
                        console.error('Error when collecting built-in examples.', e);
                    }
                    const options = {
                        menuPath: arduino_menus_1.ArduinoMenus.OPEN_SKETCH__CONTEXT,
                        anchor: {
                            x: parentElement.getBoundingClientRect().left,
                            y: parentElement.getBoundingClientRect().top +
                                parentElement.offsetHeight,
                        },
                    };
                    this.contextMenuRenderer.render(options);
                }
            },
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__SKETCH_GROUP, {
            commandId: OpenSketch_1.Commands.OPEN_SKETCH.id,
            label: common_1.nls.localize('vscode/workspaceActions/openFileFolder', 'Open...'),
            order: '1',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: OpenSketch_1.Commands.OPEN_SKETCH.id,
            keybinding: 'CtrlCmd+O',
        });
    }
    async openSketch(toOpen = this.selectSketch()) {
        const sketch = await toOpen;
        if (sketch) {
            this.workspaceService.open(new contribution_1.URI(sketch.uri));
        }
    }
    async selectSketch() {
        const config = await this.configService.getConfiguration();
        const defaultPath = await this.fileService.fsPath(new contribution_1.URI(config.sketchDirUri));
        const { filePaths } = await remote.dialog.showOpenDialog({
            defaultPath,
            properties: ['createDirectory', 'openFile'],
            filters: [
                {
                    name: common_1.nls.localize('arduino/sketch/sketch', 'Sketch'),
                    extensions: ['ino', 'pde'],
                },
            ],
        });
        if (!filePaths.length) {
            return undefined;
        }
        if (filePaths.length > 1) {
            this.logger.warn(`Multiple sketches were selected: ${filePaths}. Using the first one.`);
        }
        const sketchFilePath = filePaths[0];
        const sketchFileUri = await this.fileSystemExt.getUri(sketchFilePath);
        const sketch = await this.sketchService.getSketchFolder(sketchFileUri);
        if (sketch) {
            return sketch;
        }
        if (contribution_1.Sketch.isSketchFile(sketchFileUri)) {
            const name = new contribution_1.URI(sketchFileUri).path.name;
            const nameWithExt = this.labelProvider.getName(new contribution_1.URI(sketchFileUri));
            const { response } = await remote.dialog.showMessageBox({
                title: common_1.nls.localize('arduino/sketch/moving', 'Moving'),
                type: 'question',
                buttons: [
                    common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'),
                    common_1.nls.localize('vscode/issueMainService/ok', 'OK'),
                ],
                message: common_1.nls.localize('arduino/sketch/movingMsg', 'The file "{0}" needs to be inside a sketch folder named "{1}".\nCreate this folder, move the file, and continue?', nameWithExt, name),
            });
            if (response === 1) {
                // OK
                const newSketchUri = new contribution_1.URI(sketchFileUri).parent.resolve(name);
                const exists = await this.fileService.exists(newSketchUri);
                if (exists) {
                    await remote.dialog.showMessageBox({
                        type: 'error',
                        title: common_1.nls.localize('vscode/dialog/dialogErrorMessage', 'Error'),
                        message: common_1.nls.localize('arduino/sketch/cantOpen', 'A folder named "{0}" already exists. Can\'t open sketch.', name),
                    });
                    return undefined;
                }
                await this.fileService.createFolder(newSketchUri);
                await this.fileService.move(new contribution_1.URI(sketchFileUri), new contribution_1.URI(newSketchUri.resolve(nameWithExt).toString()));
                return this.sketchService.getSketchFolder(newSketchUri.toString());
            }
        }
    }
};
__decorate([
    (0, inversify_1.inject)(contribution_1.MenuModelRegistry),
    __metadata("design:type", contribution_1.MenuModelRegistry)
], OpenSketch.prototype, "menuRegistry", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    __metadata("design:type", browser_1.ContextMenuRenderer)
], OpenSketch.prototype, "contextMenuRenderer", void 0);
__decorate([
    (0, inversify_1.inject)(examples_1.BuiltInExamples),
    __metadata("design:type", examples_1.BuiltInExamples)
], OpenSketch.prototype, "builtInExamples", void 0);
__decorate([
    (0, inversify_1.inject)(examples_service_1.ExamplesService),
    __metadata("design:type", Object)
], OpenSketch.prototype, "examplesService", void 0);
__decorate([
    (0, inversify_1.inject)(sketchbook_1.Sketchbook),
    __metadata("design:type", sketchbook_1.Sketchbook)
], OpenSketch.prototype, "sketchbook", void 0);
OpenSketch = OpenSketch_1 = __decorate([
    (0, inversify_1.injectable)()
], OpenSketch);
exports.OpenSketch = OpenSketch;
(function (OpenSketch) {
    let Commands;
    (function (Commands) {
        Commands.OPEN_SKETCH = {
            id: 'arduino-open-sketch',
        };
        Commands.OPEN_SKETCH__TOOLBAR = {
            id: 'arduino-open-sketch--toolbar',
        };
    })(Commands = OpenSketch.Commands || (OpenSketch.Commands = {}));
})(OpenSketch = exports.OpenSketch || (exports.OpenSketch = {}));
exports.OpenSketch = OpenSketch;
//# sourceMappingURL=open-sketch.js.map