"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var QuitApp_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QuitApp = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const os_1 = require("@theia/core/lib/common/os");
const contribution_1 = require("./contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const common_1 = require("@theia/core/lib/common");
let QuitApp = QuitApp_1 = class QuitApp extends contribution_1.Contribution {
    registerCommands(registry) {
        if (!os_1.isOSX) {
            registry.registerCommand(QuitApp_1.Commands.QUIT_APP, {
                execute: () => remote.app.quit(),
            });
        }
    }
    registerMenus(registry) {
        // On macOS we will get the `Quit ${YOUR_APP_NAME}` menu item natively, no need to duplicate it.
        if (!os_1.isOSX) {
            registry.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__QUIT_GROUP, {
                commandId: QuitApp_1.Commands.QUIT_APP.id,
                label: common_1.nls.localize('vscode/bulkEditService/quit', 'Quit'),
                order: '0',
            });
        }
    }
    registerKeybindings(registry) {
        if (!os_1.isOSX) {
            registry.registerKeybinding({
                command: QuitApp_1.Commands.QUIT_APP.id,
                keybinding: 'CtrlCmd+Q',
            });
        }
    }
};
QuitApp = QuitApp_1 = __decorate([
    (0, inversify_1.injectable)()
], QuitApp);
exports.QuitApp = QuitApp;
(function (QuitApp) {
    let Commands;
    (function (Commands) {
        Commands.QUIT_APP = {
            id: 'arduino-quit-app',
        };
    })(Commands = QuitApp.Commands || (QuitApp.Commands = {}));
})(QuitApp = exports.QuitApp || (exports.QuitApp = {}));
exports.QuitApp = QuitApp;
//# sourceMappingURL=quit-app.js.map