"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var SaveAsSketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaveAsSketch = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const dateFormat = require("dateformat");
const arduino_menus_1 = require("../menu/arduino-menus");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
const browser_1 = require("@theia/core/lib/browser");
const browser_2 = require("@theia/editor/lib/browser");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
let SaveAsSketch = SaveAsSketch_1 = class SaveAsSketch extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(SaveAsSketch_1.Commands.SAVE_AS_SKETCH, {
            execute: (args) => this.saveAs(args),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__SKETCH_GROUP, {
            commandId: SaveAsSketch_1.Commands.SAVE_AS_SKETCH.id,
            label: common_1.nls.localize('vscode/fileCommands/saveAs', 'Save As...'),
            order: '7',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: SaveAsSketch_1.Commands.SAVE_AS_SKETCH.id,
            keybinding: 'CtrlCmd+Shift+S',
        });
    }
    /**
     * Resolves `true` if the sketch was successfully saved as something.
     */
    async saveAs({ execOnlyIfTemp, openAfterMove, wipeOriginal, markAsRecentlyOpened, } = SaveAsSketch_1.Options.DEFAULT) {
        const sketch = await this.sketchServiceClient.currentSketch();
        if (!sketches_service_client_impl_1.CurrentSketch.isValid(sketch)) {
            return false;
        }
        const isTemp = await this.sketchService.isTemp(sketch);
        if (!isTemp && !!execOnlyIfTemp) {
            return false;
        }
        // If target does not exist, propose a `directories.user`/${sketch.name} path
        // If target exists, propose `directories.user`/${sketch.name}_copy_${yyyymmddHHMMss}
        const sketchDirUri = new contribution_1.URI((await this.configService.getConfiguration()).sketchDirUri);
        const exists = await this.fileService.exists(sketchDirUri.resolve(sketch.name));
        const defaultUri = sketchDirUri.resolve(exists
            ? `${sketch.name}_copy_${dateFormat(new Date(), 'yyyymmddHHMMss')}`
            : sketch.name);
        const defaultPath = await this.fileService.fsPath(defaultUri);
        const { filePath, canceled } = await remote.dialog.showSaveDialog({
            title: common_1.nls.localize('arduino/sketch/saveFolderAs', 'Save sketch folder as...'),
            defaultPath,
        });
        if (!filePath || canceled) {
            return false;
        }
        const destinationUri = await this.fileSystemExt.getUri(filePath);
        if (!destinationUri) {
            return false;
        }
        const workspaceUri = await this.sketchService.copy(sketch, {
            destinationUri,
        });
        if (workspaceUri) {
            await this.saveOntoCopiedSketch(sketch.mainFileUri, sketch.uri, workspaceUri);
            if (markAsRecentlyOpened) {
                this.sketchService.markAsRecentlyOpened(workspaceUri);
            }
        }
        if (workspaceUri && openAfterMove) {
            this.windowService.setSafeToShutDown();
            if (wipeOriginal || (openAfterMove && execOnlyIfTemp)) {
                // This window will navigate away.
                // Explicitly stop the contribution to dispose the file watcher before deleting the temp sketch.
                // Otherwise, users might see irrelevant _Unable to watch for file changes in this large workspace._ notification.
                // https://github.com/arduino/arduino-ide/issues/39.
                this.sketchServiceClient.onStop();
                // TODO: consider implementing the temp sketch deletion the following way:
                // Open the other sketch with a `delete the temp sketch` startup-task.
                this.sketchService.notifyDeleteSketch(sketch); // This is a notification and will execute on the backend.
            }
            this.workspaceService.open(new contribution_1.URI(workspaceUri), {
                preserveWindow: true,
            });
        }
        return !!workspaceUri;
    }
    async saveOntoCopiedSketch(mainFileUri, sketchUri, newSketchUri) {
        const widgets = this.applicationShell.widgets;
        const snapshots = new Map();
        for (const widget of widgets) {
            const saveable = browser_1.Saveable.getDirty(widget);
            const uri = browser_1.NavigatableWidget.getUri(widget);
            const uriString = uri === null || uri === void 0 ? void 0 : uri.toString();
            let relativePath;
            if (uri && uriString.includes(sketchUri) && saveable && saveable.createSnapshot) {
                // The main file will change its name during the copy process
                // We need to store the new name in the map
                if (mainFileUri === uriString) {
                    const lastPart = new contribution_1.URI(newSketchUri).path.base + uri.path.ext;
                    relativePath = '/' + lastPart;
                }
                else {
                    relativePath = uri.toString().substring(sketchUri.length);
                }
                snapshots.set(relativePath, saveable.createSnapshot());
            }
        }
        await Promise.all(Array.from(snapshots.entries()).map(async ([path, snapshot]) => {
            const widgetUri = new contribution_1.URI(newSketchUri + path);
            try {
                const widget = await this.editorManager.getOrCreateByUri(widgetUri);
                const saveable = browser_1.Saveable.get(widget);
                if (saveable && saveable.applySnapshot) {
                    saveable.applySnapshot(snapshot);
                    await saveable.save();
                }
            }
            catch (e) {
                console.error(e);
            }
        }));
    }
};
__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    __metadata("design:type", browser_1.ApplicationShell)
], SaveAsSketch.prototype, "applicationShell", void 0);
__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    __metadata("design:type", browser_2.EditorManager)
], SaveAsSketch.prototype, "editorManager", void 0);
__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    __metadata("design:type", Object)
], SaveAsSketch.prototype, "windowService", void 0);
SaveAsSketch = SaveAsSketch_1 = __decorate([
    (0, inversify_1.injectable)()
], SaveAsSketch);
exports.SaveAsSketch = SaveAsSketch;
(function (SaveAsSketch) {
    let Commands;
    (function (Commands) {
        Commands.SAVE_AS_SKETCH = {
            id: 'arduino-save-as-sketch',
        };
    })(Commands = SaveAsSketch.Commands || (SaveAsSketch.Commands = {}));
    let Options;
    (function (Options) {
        Options.DEFAULT = {
            execOnlyIfTemp: false,
            openAfterMove: true,
            wipeOriginal: false,
            markAsRecentlyOpened: false,
        };
    })(Options = SaveAsSketch.Options || (SaveAsSketch.Options = {}));
})(SaveAsSketch = exports.SaveAsSketch || (exports.SaveAsSketch = {}));
exports.SaveAsSketch = SaveAsSketch;
//# sourceMappingURL=save-as-sketch.js.map