"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SelectedBoard = void 0;
const status_bar_1 = require("@theia/core/lib/browser/status-bar/status-bar");
const nls_1 = require("@theia/core/lib/common/nls");
const inversify_1 = require("@theia/core/shared/inversify");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const contribution_1 = require("./contribution");
let SelectedBoard = class SelectedBoard extends contribution_1.Contribution {
    onStart() {
        this.boardsServiceProvider.onBoardsConfigChanged((config) => this.update(config));
    }
    onReady() {
        this.update(this.boardsServiceProvider.boardsConfig);
    }
    update({ selectedBoard, selectedPort }) {
        this.statusBar.setElement('arduino-selected-board', {
            alignment: status_bar_1.StatusBarAlignment.RIGHT,
            text: selectedBoard
                ? `$(microchip) ${selectedBoard.name}`
                : `$(close) ${nls_1.nls.localize('arduino/common/noBoardSelected', 'No board selected')}`,
            className: 'arduino-selected-board',
        });
        if (selectedBoard) {
            this.statusBar.setElement('arduino-selected-port', {
                alignment: status_bar_1.StatusBarAlignment.RIGHT,
                text: selectedPort
                    ? nls_1.nls.localize('arduino/common/selectedOn', 'on {0}', selectedPort.address)
                    : nls_1.nls.localize('arduino/common/notConnected', '[not connected]'),
                className: 'arduino-selected-port',
            });
        }
    }
};
__decorate([
    (0, inversify_1.inject)(status_bar_1.StatusBar),
    __metadata("design:type", Object)
], SelectedBoard.prototype, "statusBar", void 0);
__decorate([
    (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], SelectedBoard.prototype, "boardsServiceProvider", void 0);
SelectedBoard = __decorate([
    (0, inversify_1.injectable)()
], SelectedBoard);
exports.SelectedBoard = SelectedBoard;
//# sourceMappingURL=selected-board.js.map