"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var Settings_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Settings = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const contribution_1 = require("./contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const settings_dialog_1 = require("../dialogs/settings/settings-dialog");
const common_1 = require("@theia/core/lib/common");
let Settings = Settings_1 = class Settings extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.settingsOpened = false;
    }
    registerCommands(registry) {
        registry.registerCommand(Settings_1.Commands.OPEN, {
            execute: async () => {
                let settings = undefined;
                try {
                    this.settingsOpened = true;
                    settings = await this.settingsDialog.open();
                }
                finally {
                    this.settingsOpened = false;
                }
                if (settings) {
                    await this.settingsService.update(settings);
                    await this.settingsService.save();
                }
                else {
                    await this.settingsService.reset();
                }
            },
            isEnabled: () => !this.settingsOpened,
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__PREFERENCES_GROUP, {
            commandId: Settings_1.Commands.OPEN.id,
            label: common_1.nls.localize('vscode/preferences.contribution/preferences', 'Preferences') + '...',
            order: '0',
        });
        registry.registerSubmenu(arduino_menus_1.ArduinoMenus.FILE__ADVANCED_SUBMENU, common_1.nls.localize('arduino/menu/advanced', 'Advanced'));
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: Settings_1.Commands.OPEN.id,
            keybinding: 'CtrlCmd+,',
        });
    }
};
__decorate([
    (0, inversify_1.inject)(settings_dialog_1.SettingsDialog),
    __metadata("design:type", settings_dialog_1.SettingsDialog)
], Settings.prototype, "settingsDialog", void 0);
Settings = Settings_1 = __decorate([
    (0, inversify_1.injectable)()
], Settings);
exports.Settings = Settings;
(function (Settings) {
    let Commands;
    (function (Commands) {
        Commands.OPEN = {
            id: 'arduino-settings-open',
            label: common_1.nls.localize('vscode/preferences.contribution/openSettings2', 'Open Preferences') + '...',
            category: 'Arduino',
        };
    })(Commands = Settings.Commands || (Settings.Commands = {}));
})(Settings = exports.Settings || (exports.Settings = {}));
exports.Settings = Settings;
//# sourceMappingURL=settings.js.map