"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchFilesTracker = void 0;
const saveable_1 = require("@theia/core/lib/browser/saveable");
const disposable_1 = require("@theia/core/lib/common/disposable");
const inversify_1 = require("@theia/core/shared/inversify");
const filesystem_frontend_contribution_1 = require("@theia/filesystem/lib/browser/filesystem-frontend-contribution");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
const contribution_1 = require("./contribution");
const open_sketch_files_1 = require("./open-sketch-files");
let SketchFilesTracker = class SketchFilesTracker extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.toDisposeOnStop = new disposable_1.DisposableCollection();
    }
    onStart() {
        this.fileSystemFrontendContribution.onDidChangeEditorFile(({ type, editor }) => {
            if (type === 2 /* DELETED */) {
                const editorWidget = editor;
                if (saveable_1.SaveableWidget.is(editorWidget)) {
                    editorWidget.closeWithoutSaving();
                }
                else {
                    editorWidget.close();
                }
            }
        });
    }
    onReady() {
        this.sketchServiceClient.currentSketch().then(async (sketch) => {
            if (sketches_service_client_impl_1.CurrentSketch.isValid(sketch)) {
                this.toDisposeOnStop.push(this.fileService.watch(new contribution_1.URI(sketch.uri)));
                this.toDisposeOnStop.push(this.fileService.onDidFilesChange(async (event) => {
                    for (const { type, resource } of event.changes) {
                        if (type === 1 /* ADDED */ &&
                            resource.parent.toString() === sketch.uri) {
                            const reloadedSketch = await this.sketchService.loadSketch(sketch.uri);
                            if (contribution_1.Sketch.isInSketch(resource, reloadedSketch)) {
                                this.commandService.executeCommand(open_sketch_files_1.OpenSketchFiles.Commands.ENSURE_OPENED.id, resource.toString(), true, {
                                    mode: 'open',
                                });
                            }
                        }
                    }
                }));
            }
        });
    }
    onStop() {
        this.toDisposeOnStop.dispose();
    }
};
__decorate([
    (0, inversify_1.inject)(filesystem_frontend_contribution_1.FileSystemFrontendContribution),
    __metadata("design:type", filesystem_frontend_contribution_1.FileSystemFrontendContribution)
], SketchFilesTracker.prototype, "fileSystemFrontendContribution", void 0);
SketchFilesTracker = __decorate([
    (0, inversify_1.injectable)()
], SketchFilesTracker);
exports.SketchFilesTracker = SketchFilesTracker;
//# sourceMappingURL=sketch-files-tracker.js.map