"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sketchbook = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const contribution_1 = require("./contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const main_menu_manager_1 = require("../../common/main-menu-manager");
const notification_center_1 = require("../notification-center");
const examples_1 = require("./examples");
const protocol_1 = require("../../common/protocol");
const open_sketch_1 = require("./open-sketch");
const common_1 = require("@theia/core/lib/common");
let Sketchbook = class Sketchbook extends examples_1.Examples {
    onStart() {
        this.sketchServiceClient.onSketchbookDidChange(() => this.update());
    }
    async onReady() {
        this.update();
    }
    update() {
        this.sketchService.getSketches({}).then((container) => {
            this.register(container);
            this.mainMenuManager.update();
        });
    }
    registerMenus(registry) {
        registry.registerSubmenu(arduino_menus_1.ArduinoMenus.FILE__SKETCHBOOK_SUBMENU, common_1.nls.localize('arduino/sketch/sketchbook', 'Sketchbook'), { order: '3' });
    }
    register(container) {
        this.toDispose.dispose();
        this.registerRecursively([...container.children, ...container.sketches], arduino_menus_1.ArduinoMenus.FILE__SKETCHBOOK_SUBMENU, this.toDispose);
    }
    createHandler(uri) {
        return {
            execute: async () => {
                let sketch = undefined;
                try {
                    sketch = await this.sketchService.loadSketch(uri);
                }
                catch (err) {
                    if (protocol_1.SketchesError.NotFound.is(err)) {
                        // To handle the following:
                        // Open IDE2, delete a sketch from sketchbook, click on File > Sketchbook > the deleted sketch.
                        // Filesystem watcher misses out delete events on macOS; hence IDE2 has no chance to update the menu items.
                        this.messageService.error(err.message);
                        this.update();
                    }
                }
                if (sketch) {
                    await this.commandService.executeCommand(open_sketch_1.OpenSketch.Commands.OPEN_SKETCH.id, sketch);
                }
            },
        };
    }
};
__decorate([
    (0, inversify_1.inject)(contribution_1.CommandRegistry),
    __metadata("design:type", contribution_1.CommandRegistry)
], Sketchbook.prototype, "commandRegistry", void 0);
__decorate([
    (0, inversify_1.inject)(contribution_1.MenuModelRegistry),
    __metadata("design:type", contribution_1.MenuModelRegistry)
], Sketchbook.prototype, "menuRegistry", void 0);
__decorate([
    (0, inversify_1.inject)(main_menu_manager_1.MainMenuManager),
    __metadata("design:type", Object)
], Sketchbook.prototype, "mainMenuManager", void 0);
__decorate([
    (0, inversify_1.inject)(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], Sketchbook.prototype, "notificationCenter", void 0);
Sketchbook = __decorate([
    (0, inversify_1.injectable)()
], Sketchbook);
exports.Sketchbook = Sketchbook;
//# sourceMappingURL=sketchbook.js.map