"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SurveyNotification = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/core/lib/browser");
const common_1 = require("@theia/core/lib/common");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const arduino_preferences_1 = require("../arduino-preferences");
const survey_service_1 = require("../../common/protocol/survey-service");
const SURVEY_MESSAGE = common_1.nls.localize('arduino/survey/surveyMessage', 'Please help us improve by answering this super short survey. We value our community and would like to get to know our supporters a little better.');
const DO_NOT_SHOW_AGAIN = common_1.nls.localize('arduino/survey/dismissSurvey', "Don't show again");
const GO_TO_SURVEY = common_1.nls.localize('arduino/survey/answerSurvey', 'Answer survey');
const SURVEY_BASE_URL = 'https://surveys.hotjar.com/';
const surveyId = '17887b40-e1f0-4bd6-b9f0-a37f229ccd8b';
let SurveyNotification = class SurveyNotification {
    onStart() {
        this.arduinoPreferences.ready.then(async () => {
            if ((await this.surveyNotificationService.isFirstInstance()) &&
                this.arduinoPreferences.get('arduino.survey.notification')) {
                const surveyAnswered = await this.localStorageService.getData(this.surveyKey(surveyId));
                if (surveyAnswered !== undefined) {
                    return;
                }
                const answer = await this.messageService.info(SURVEY_MESSAGE, DO_NOT_SHOW_AGAIN, GO_TO_SURVEY);
                switch (answer) {
                    case GO_TO_SURVEY:
                        this.windowService.openNewWindow(SURVEY_BASE_URL + surveyId, {
                            external: true,
                        });
                        this.localStorageService.setData(this.surveyKey(surveyId), true);
                        break;
                    case DO_NOT_SHOW_AGAIN:
                        this.localStorageService.setData(this.surveyKey(surveyId), false);
                        break;
                }
            }
        });
    }
    surveyKey(id) {
        return `answered_survey:${id}`;
    }
};
__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    __metadata("design:type", core_1.MessageService)
], SurveyNotification.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.LocalStorageService),
    __metadata("design:type", browser_1.LocalStorageService)
], SurveyNotification.prototype, "localStorageService", void 0);
__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    __metadata("design:type", Object)
], SurveyNotification.prototype, "windowService", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], SurveyNotification.prototype, "arduinoPreferences", void 0);
__decorate([
    (0, inversify_1.inject)(survey_service_1.SurveyNotificationService),
    __metadata("design:type", Object)
], SurveyNotification.prototype, "surveyNotificationService", void 0);
SurveyNotification = __decorate([
    (0, inversify_1.injectable)()
], SurveyNotification);
exports.SurveyNotification = SurveyNotification;
//# sourceMappingURL=survey-notification.js.map