"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UploadSketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadSketch = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const event_1 = require("@theia/core/lib/common/event");
const protocol_1 = require("../../common/protocol");
const arduino_menus_1 = require("../menu/arduino-menus");
const arduino_toolbar_1 = require("../toolbar/arduino-toolbar");
const contribution_1 = require("./contribution");
const user_fields_dialog_1 = require("../dialogs/user-fields/user-fields-dialog");
const common_1 = require("@theia/core/lib/common");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
let UploadSketch = UploadSketch_1 = class UploadSketch extends contribution_1.CoreServiceContribution {
    constructor() {
        super(...arguments);
        this.boardRequiresUserFields = false;
        this.cachedUserFields = new Map();
        this.menuActionsDisposables = new common_1.DisposableCollection();
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.uploadInProgress = false;
    }
    init() {
        super.init();
        this.boardsServiceProvider.onBoardsConfigChanged(async () => {
            const userFields = await this.boardsServiceProvider.selectedBoardUserFields();
            this.boardRequiresUserFields = userFields.length > 0;
            this.registerMenus(this.menuRegistry);
        });
    }
    selectedFqbnAddress() {
        var _a, _b, _c, _d;
        const { boardsConfig } = this.boardsServiceProvider;
        const fqbn = (_a = boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn;
        if (!fqbn) {
            return '';
        }
        const address = ((_c = (_b = boardsConfig.selectedBoard) === null || _b === void 0 ? void 0 : _b.port) === null || _c === void 0 ? void 0 : _c.address) ||
            ((_d = boardsConfig.selectedPort) === null || _d === void 0 ? void 0 : _d.address);
        if (!address) {
            return '';
        }
        return fqbn + '|' + address;
    }
    registerCommands(registry) {
        registry.registerCommand(UploadSketch_1.Commands.UPLOAD_SKETCH, {
            execute: async () => {
                const key = this.selectedFqbnAddress();
                if (this.boardRequiresUserFields &&
                    key &&
                    !this.cachedUserFields.has(key)) {
                    // Deep clone the array of board fields to avoid editing the cached ones
                    this.userFieldsDialog.value = (await this.boardsServiceProvider.selectedBoardUserFields()).map((f) => (Object.assign({}, f)));
                    const result = await this.userFieldsDialog.open();
                    if (!result) {
                        return;
                    }
                    this.cachedUserFields.set(key, result);
                }
                this.uploadSketch();
            },
            isEnabled: () => !this.uploadInProgress,
        });
        registry.registerCommand(UploadSketch_1.Commands.UPLOAD_WITH_CONFIGURATION, {
            execute: async () => {
                const key = this.selectedFqbnAddress();
                if (!key) {
                    return;
                }
                const cached = this.cachedUserFields.get(key);
                // Deep clone the array of board fields to avoid editing the cached ones
                this.userFieldsDialog.value = (cached !== null && cached !== void 0 ? cached : (await this.boardsServiceProvider.selectedBoardUserFields())).map((f) => (Object.assign({}, f)));
                const result = await this.userFieldsDialog.open();
                if (!result) {
                    return;
                }
                this.cachedUserFields.set(key, result);
                this.uploadSketch();
            },
            isEnabled: () => !this.uploadInProgress && this.boardRequiresUserFields,
        });
        registry.registerCommand(UploadSketch_1.Commands.UPLOAD_SKETCH_USING_PROGRAMMER, {
            execute: () => this.uploadSketch(true),
            isEnabled: () => !this.uploadInProgress,
        });
        registry.registerCommand(UploadSketch_1.Commands.UPLOAD_SKETCH_TOOLBAR, {
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            isEnabled: () => !this.uploadInProgress,
            isToggled: () => this.uploadInProgress,
            execute: () => registry.executeCommand(UploadSketch_1.Commands.UPLOAD_SKETCH.id),
        });
    }
    registerMenus(registry) {
        this.menuActionsDisposables.dispose();
        this.menuActionsDisposables.push(registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: UploadSketch_1.Commands.UPLOAD_SKETCH.id,
            label: common_1.nls.localize('arduino/sketch/upload', 'Upload'),
            order: '1',
        }));
        if (this.boardRequiresUserFields) {
            this.menuActionsDisposables.push(registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
                commandId: UploadSketch_1.Commands.UPLOAD_WITH_CONFIGURATION.id,
                label: UploadSketch_1.Commands.UPLOAD_WITH_CONFIGURATION.label,
                order: '2',
            }));
        }
        else {
            this.menuActionsDisposables.push(registry.registerMenuNode(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, new arduino_menus_1.PlaceholderMenuNode(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, 
            // commandId: UploadSketch.Commands.UPLOAD_WITH_CONFIGURATION.id,
            UploadSketch_1.Commands.UPLOAD_WITH_CONFIGURATION.label, { order: '2' })));
        }
        this.menuActionsDisposables.push(registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: UploadSketch_1.Commands.UPLOAD_SKETCH_USING_PROGRAMMER.id,
            label: common_1.nls.localize('arduino/sketch/uploadUsingProgrammer', 'Upload Using Programmer'),
            order: '3',
        }));
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: UploadSketch_1.Commands.UPLOAD_SKETCH.id,
            keybinding: 'CtrlCmd+U',
        });
        registry.registerKeybinding({
            command: UploadSketch_1.Commands.UPLOAD_SKETCH_USING_PROGRAMMER.id,
            keybinding: 'CtrlCmd+Shift+U',
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: UploadSketch_1.Commands.UPLOAD_SKETCH_TOOLBAR.id,
            command: UploadSketch_1.Commands.UPLOAD_SKETCH_TOOLBAR.id,
            tooltip: common_1.nls.localize('arduino/sketch/upload', 'Upload'),
            priority: 1,
            onDidChange: this.onDidChange,
        });
    }
    async uploadSketch(usingProgrammer = false) {
        if (this.uploadInProgress) {
            return;
        }
        try {
            // toggle the toolbar button and menu item state.
            // uploadInProgress will be set to false whether the upload fails or not
            this.uploadInProgress = true;
            this.boardsServiceProvider.snapshotBoardDiscoveryOnUpload();
            this.onDidChangeEmitter.fire();
            this.clearVisibleNotification();
            const verifyOptions = await this.commandService.executeCommand('arduino-verify-sketch', {
                exportBinaries: false,
                silent: true,
            });
            if (!verifyOptions) {
                return;
            }
            const uploadOptions = await this.uploadOptions(usingProgrammer, verifyOptions);
            if (!uploadOptions) {
                return;
            }
            // TODO: This does not belong here.
            // IDE2 should not do any preliminary checks but let the CLI fail and then toast a user consumable error message.
            if (uploadOptions.userFields.length === 0 &&
                this.boardRequiresUserFields) {
                this.messageService.error(common_1.nls.localize('arduino/sketch/userFieldsNotFoundError', "Can't find user fields for connected board"));
                return;
            }
            await this.doWithProgress({
                progressText: common_1.nls.localize('arduino/sketch/uploading', 'Uploading...'),
                task: (progressId, coreService) => coreService.upload(Object.assign(Object.assign({}, uploadOptions), { progressId })),
                keepOutput: true,
            });
            this.messageService.info(common_1.nls.localize('arduino/sketch/doneUploading', 'Done uploading.'), { timeout: 3000 });
        }
        catch (e) {
            this.handleError(e);
        }
        finally {
            this.uploadInProgress = false;
            this.boardsServiceProvider.attemptPostUploadAutoSelect();
            this.onDidChangeEmitter.fire();
        }
    }
    async uploadOptions(usingProgrammer, verifyOptions) {
        const sketch = await this.sketchServiceClient.currentSketch();
        if (!sketches_service_client_impl_1.CurrentSketch.isValid(sketch)) {
            return undefined;
        }
        const userFields = this.userFields();
        const { boardsConfig } = this.boardsServiceProvider;
        const [fqbn, { selectedProgrammer: programmer }, verify, verbose] = await Promise.all([
            verifyOptions.fqbn,
            this.boardsDataStore.getData(this.sanitizeFqbn(verifyOptions.fqbn)),
            this.preferences.get('arduino.upload.verify'),
            this.preferences.get('arduino.upload.verbose'),
        ]);
        const port = this.maybeUpdatePortProperties(boardsConfig.selectedPort);
        return Object.assign(Object.assign({ sketch,
            fqbn }, (usingProgrammer && { programmer })), { port,
            verbose,
            verify,
            userFields });
    }
    /**
     * This is a hack to ensure that the port object has the `properties` when uploading.(https://github.com/arduino/arduino-ide/issues/740)
     * This method works around a bug when restoring a `port` persisted by an older version of IDE2. See the bug [here](https://github.com/arduino/arduino-ide/pull/1335#issuecomment-1224355236).
     *
     * Before the upload, this method checks the available ports and makes sure that the `properties` of an available port, and the port selected by the user have the same `properties`.
     * This method does not update any state (for example, the `BoardsConfig.Config`) but uses the correct `properties` for the `upload`.
     */
    maybeUpdatePortProperties(port) {
        if (port) {
            const key = protocol_1.Port.keyOf(port);
            for (const candidate of this.boardsServiceProvider.availablePorts) {
                if (key === protocol_1.Port.keyOf(candidate) && candidate.properties) {
                    return Object.assign(Object.assign({}, port), { properties: (0, common_1.deepClone)(candidate.properties) });
                }
            }
        }
        return port;
    }
    userFields() {
        var _a;
        return (_a = this.cachedUserFields.get(this.selectedFqbnAddress())) !== null && _a !== void 0 ? _a : [];
    }
    /**
     * Converts the `VENDOR:ARCHITECTURE:BOARD_ID[:MENU_ID=OPTION_ID[,MENU2_ID=OPTION_ID ...]]` FQBN to
     * `VENDOR:ARCHITECTURE:BOARD_ID` format.
     * See the details of the `{build.fqbn}` entry in the [specs](https://arduino.github.io/arduino-cli/latest/platform-specification/#global-predefined-properties).
     */
    sanitizeFqbn(fqbn) {
        if (!fqbn) {
            return undefined;
        }
        const [vendor, arch, id] = fqbn.split(':');
        return `${vendor}:${arch}:${id}`;
    }
};
__decorate([
    (0, inversify_1.inject)(contribution_1.MenuModelRegistry),
    __metadata("design:type", contribution_1.MenuModelRegistry)
], UploadSketch.prototype, "menuRegistry", void 0);
__decorate([
    (0, inversify_1.inject)(user_fields_dialog_1.UserFieldsDialog),
    __metadata("design:type", user_fields_dialog_1.UserFieldsDialog)
], UploadSketch.prototype, "userFieldsDialog", void 0);
UploadSketch = UploadSketch_1 = __decorate([
    (0, inversify_1.injectable)()
], UploadSketch);
exports.UploadSketch = UploadSketch;
(function (UploadSketch) {
    let Commands;
    (function (Commands) {
        Commands.UPLOAD_SKETCH = {
            id: 'arduino-upload-sketch',
        };
        Commands.UPLOAD_WITH_CONFIGURATION = {
            id: 'arduino-upload-with-configuration-sketch',
            label: common_1.nls.localize('arduino/sketch/configureAndUpload', 'Configure And Upload'),
            category: 'Arduino',
        };
        Commands.UPLOAD_SKETCH_USING_PROGRAMMER = {
            id: 'arduino-upload-sketch-using-programmer',
        };
        Commands.UPLOAD_SKETCH_TOOLBAR = {
            id: 'arduino-upload-sketch--toolbar',
        };
    })(Commands = UploadSketch.Commands || (UploadSketch.Commands = {}));
})(UploadSketch = exports.UploadSketch || (exports.UploadSketch = {}));
exports.UploadSketch = UploadSketch;
//# sourceMappingURL=upload-sketch.js.map