"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var VerifySketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VerifySketch = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const event_1 = require("@theia/core/lib/common/event");
const arduino_menus_1 = require("../menu/arduino-menus");
const arduino_toolbar_1 = require("../toolbar/arduino-toolbar");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
const core_error_handler_1 = require("./core-error-handler");
let VerifySketch = VerifySketch_1 = class VerifySketch extends contribution_1.CoreServiceContribution {
    constructor() {
        super(...arguments);
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.verifyInProgress = false;
    }
    registerCommands(registry) {
        registry.registerCommand(VerifySketch_1.Commands.VERIFY_SKETCH, {
            execute: (params) => this.verifySketch(params),
            isEnabled: () => !this.verifyInProgress,
        });
        registry.registerCommand(VerifySketch_1.Commands.EXPORT_BINARIES, {
            execute: () => this.verifySketch({ exportBinaries: true }),
            isEnabled: () => !this.verifyInProgress,
        });
        registry.registerCommand(VerifySketch_1.Commands.VERIFY_SKETCH_TOOLBAR, {
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            isEnabled: () => !this.verifyInProgress,
            isToggled: () => this.verifyInProgress,
            execute: () => registry.executeCommand(VerifySketch_1.Commands.VERIFY_SKETCH.id),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: VerifySketch_1.Commands.VERIFY_SKETCH.id,
            label: common_1.nls.localize('arduino/sketch/verifyOrCompile', 'Verify/Compile'),
            order: '0',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: VerifySketch_1.Commands.EXPORT_BINARIES.id,
            label: common_1.nls.localize('arduino/sketch/exportBinary', 'Export Compiled Binary'),
            order: '4',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: VerifySketch_1.Commands.VERIFY_SKETCH.id,
            keybinding: 'CtrlCmd+R',
        });
        registry.registerKeybinding({
            command: VerifySketch_1.Commands.EXPORT_BINARIES.id,
            keybinding: 'CtrlCmd+Alt+S',
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: VerifySketch_1.Commands.VERIFY_SKETCH_TOOLBAR.id,
            command: VerifySketch_1.Commands.VERIFY_SKETCH_TOOLBAR.id,
            tooltip: common_1.nls.localize('arduino/sketch/verify', 'Verify'),
            priority: 0,
            onDidChange: this.onDidChange,
        });
    }
    handleError(error) {
        this.coreErrorHandler.tryHandle(error);
        super.handleError(error);
    }
    async verifySketch(params) {
        if (this.verifyInProgress) {
            return undefined;
        }
        try {
            if (!(params === null || params === void 0 ? void 0 : params.silent)) {
                this.verifyInProgress = true;
                this.onDidChangeEmitter.fire();
            }
            this.clearVisibleNotification();
            this.coreErrorHandler.reset();
            const options = await this.options(params === null || params === void 0 ? void 0 : params.exportBinaries);
            if (!options) {
                return undefined;
            }
            await this.doWithProgress({
                progressText: common_1.nls.localize('arduino/sketch/compile', 'Compiling sketch...'),
                task: (progressId, coreService) => coreService.compile(Object.assign(Object.assign({}, options), { progressId })),
            });
            this.messageService.info(common_1.nls.localize('arduino/sketch/doneCompiling', 'Done compiling.'), { timeout: 3000 });
            // Returns with the used options for the compilation
            // so that follow-up tasks (such as upload) can reuse the compiled code.
            // Note that the `fqbn` is already decorated with the board settings, if any.
            return options;
        }
        catch (e) {
            this.handleError(e);
            return undefined;
        }
        finally {
            this.verifyInProgress = false;
            if (!(params === null || params === void 0 ? void 0 : params.silent)) {
                this.onDidChangeEmitter.fire();
            }
        }
    }
    async options(exportBinaries) {
        var _a;
        const sketch = await this.sketchServiceClient.currentSketch();
        if (!sketches_service_client_impl_1.CurrentSketch.isValid(sketch)) {
            return undefined;
        }
        const { boardsConfig } = this.boardsServiceProvider;
        const [fqbn, sourceOverride, optimizeForDebug] = await Promise.all([
            this.boardsDataStore.appendConfigToFqbn((_a = boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn),
            this.sourceOverride(),
            this.commandService.executeCommand('arduino-is-optimize-for-debug'),
        ]);
        const verbose = this.preferences.get('arduino.compile.verbose');
        const compilerWarnings = this.preferences.get('arduino.compile.warnings');
        return {
            sketch,
            fqbn,
            optimizeForDebug: Boolean(optimizeForDebug),
            verbose,
            exportBinaries,
            sourceOverride,
            compilerWarnings,
        };
    }
};
__decorate([
    (0, inversify_1.inject)(core_error_handler_1.CoreErrorHandler),
    __metadata("design:type", core_error_handler_1.CoreErrorHandler)
], VerifySketch.prototype, "coreErrorHandler", void 0);
VerifySketch = VerifySketch_1 = __decorate([
    (0, inversify_1.injectable)()
], VerifySketch);
exports.VerifySketch = VerifySketch;
(function (VerifySketch) {
    let Commands;
    (function (Commands) {
        Commands.VERIFY_SKETCH = {
            id: 'arduino-verify-sketch',
        };
        Commands.EXPORT_BINARIES = {
            id: 'arduino-export-binaries',
        };
        Commands.VERIFY_SKETCH_TOOLBAR = {
            id: 'arduino-verify-sketch--toolbar',
        };
    })(Commands = VerifySketch.Commands || (VerifySketch.Commands = {}));
})(VerifySketch = exports.VerifySketch || (exports.VerifySketch = {}));
exports.VerifySketch = VerifySketch;
//# sourceMappingURL=verify-sketch.js.map