"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateFsProvider = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const event_1 = require("@theia/core/lib/common/event");
const disposable_1 = require("@theia/core/lib/common/disposable");
const files_1 = require("@theia/filesystem/lib/common/files");
const authentication_client_service_1 = require("../auth/authentication-client-service");
const create_api_1 = require("./create-api");
const create_uri_1 = require("./create-uri");
const protocol_1 = require("../../common/protocol");
const arduino_preferences_1 = require("../arduino-preferences");
let CreateFsProvider = class CreateFsProvider {
    constructor() {
        this.toDispose = new disposable_1.DisposableCollection();
        this.onFileWatchError = event_1.Event.None;
        this.onDidChangeFile = event_1.Event.None;
        this.onDidChangeCapabilities = event_1.Event.None;
        this.capabilities = 2 /* FileReadWrite */ |
            1024 /* PathCaseSensitive */ |
            16777216 /* Access */;
    }
    onStop() {
        this.toDispose.dispose();
    }
    registerFileSystemProviders(service) {
        service.onWillActivateFileSystemProvider((event) => {
            if (event.scheme === create_uri_1.CreateUri.scheme) {
                event.waitUntil((async () => {
                    service.registerProvider(create_uri_1.CreateUri.scheme, this);
                })());
            }
        });
    }
    watch(uri, opts) {
        return disposable_1.Disposable.NULL;
    }
    async stat(uri) {
        if (create_uri_1.CreateUri.equals(create_uri_1.CreateUri.root, uri)) {
            this.getCreateApi; // This will throw when not logged in.
            return {
                type: files_1.FileType.Directory,
                ctime: 0,
                mtime: 0,
                size: 0,
            };
        }
        const resource = await this.getCreateApi.stat(uri.path.toString());
        const mtime = Date.parse(resource.modified_at);
        return {
            type: this.toFileType(resource.type),
            ctime: mtime,
            mtime,
            size: 0,
        };
    }
    async mkdir(uri) {
        await this.getCreateApi.createDirectory(uri.path.toString());
    }
    async readdir(uri) {
        const resources = await this.getCreateApi.readDirectory(uri.path.toString());
        return resources.map(({ name, type }) => [name, this.toFileType(type)]);
    }
    async delete(uri, opts) {
        if (!opts.recursive) {
            throw new Error('Arduino Create file-system provider does not support non-recursive deletion.');
        }
        const stat = await this.stat(uri);
        if (!stat) {
            throw new files_1.FileSystemProviderError('File not found.', files_1.FileSystemProviderErrorCode.FileNotFound);
        }
        switch (stat.type) {
            case files_1.FileType.Directory: {
                await this.getCreateApi.deleteDirectory(uri.path.toString());
                break;
            }
            case files_1.FileType.File: {
                await this.getCreateApi.deleteFile(uri.path.toString());
                break;
            }
            default: {
                throw new files_1.FileSystemProviderError(`Unexpected file type '${stat.type}' for resource: ${uri.toString()}`, files_1.FileSystemProviderErrorCode.Unknown);
            }
        }
    }
    async rename(oldUri, newUri, options) {
        await this.getCreateApi.rename(oldUri.path.toString(), newUri.path.toString());
    }
    async readFile(uri) {
        const content = await this.getCreateApi.readFile(uri.path.toString());
        return new TextEncoder().encode(content);
    }
    async writeFile(uri, content, options) {
        await this.getCreateApi.writeFile(uri.path.toString(), content);
    }
    async access(uri, mode) {
        this.getCreateApi; // Will throw if not logged in.
    }
    toFileType(type) {
        switch (type) {
            case 'file':
                return files_1.FileType.File;
            case 'sketch':
            case 'folder':
                return files_1.FileType.Directory;
            default:
                return files_1.FileType.Unknown;
        }
    }
    get getCreateApi() {
        const { session } = this.authenticationService;
        if (!session) {
            throw new files_1.FileSystemProviderError('Not logged in.', files_1.FileSystemProviderErrorCode.NoPermissions);
        }
        return this.createApi.init(this.authenticationService, this.arduinoPreferences);
    }
};
__decorate([
    (0, inversify_1.inject)(authentication_client_service_1.AuthenticationClientService),
    __metadata("design:type", authentication_client_service_1.AuthenticationClientService)
], CreateFsProvider.prototype, "authenticationService", void 0);
__decorate([
    (0, inversify_1.inject)(create_api_1.CreateApi),
    __metadata("design:type", create_api_1.CreateApi)
], CreateFsProvider.prototype, "createApi", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.SketchesService),
    __metadata("design:type", Object)
], CreateFsProvider.prototype, "sketchesService", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], CreateFsProvider.prototype, "arduinoPreferences", void 0);
CreateFsProvider = __decorate([
    (0, inversify_1.injectable)()
], CreateFsProvider);
exports.CreateFsProvider = CreateFsProvider;
//# sourceMappingURL=create-fs-provider.js.map