"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toPosixPath = exports.splitSketchPath = exports.posixSegments = exports.basename = exports.parentPosix = exports.posix = void 0;
exports.posix = { sep: '/' };
// TODO: poor man's `path.join(path, '..')` in the browser.
function parentPosix(path) {
    const segments = path.split(exports.posix.sep) || [];
    segments.pop();
    let modified = segments.join(exports.posix.sep);
    if (path.charAt(path.length - 1) === exports.posix.sep) {
        modified += exports.posix.sep;
    }
    return modified;
}
exports.parentPosix = parentPosix;
function basename(path) {
    const segments = path.split(exports.posix.sep) || [];
    return segments.pop();
}
exports.basename = basename;
function posixSegments(posixPath) {
    return posixPath.split(exports.posix.sep).filter((segment) => !!segment);
}
exports.posixSegments = posixSegments;
/**
 * Splits the `raw` path into two segments, a root that contains user information and the relevant POSIX path. \
 * For examples:
 * ```
 * `29ad0829759028dde9b877343fa3b0e1:testrest/sketches_v2/xxx_folder/xxx_sub_folder/sketch_in_folder/sketch_in_folder.ino`
 * ```
 * will be:
 * ```
 * ['29ad0829759028dde9b877343fa3b0e1:testrest/sketches_v2', '/xxx_folder/xxx_sub_folder/sketch_in_folder/sketch_in_folder.ino']
 * ```
 */
function splitSketchPath(raw, sep = '/sketches_v2/') {
    if (!sep) {
        throw new Error('Invalid separator. Cannot be zero length.');
    }
    const index = raw.indexOf(sep);
    if (index === -1) {
        throw new Error(`Invalid path pattern. Raw path was '${raw}'.`);
    }
    const createRoot = raw.substring(0, index + sep.length - 1); // TODO: validate the `createRoot` format.
    const posixPath = raw.substr(index + sep.length - 1);
    if (!posixPath) {
        throw new Error(`Could not extract POSIX path from '${raw}'.`);
    }
    return [createRoot, posixPath];
}
exports.splitSketchPath = splitSketchPath;
function toPosixPath(raw) {
    if (raw === exports.posix.sep) {
        return exports.posix.sep; // Handles the root resource case.
    }
    const [, posixPath] = splitSketchPath(raw);
    return posixPath;
}
exports.toPosixPath = toPosixPath;
//# sourceMappingURL=create-paths.js.map