"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateUploaderComponent = void 0;
const React = require("@theia/core/shared/react");
const react_1 = require("@tippyjs/react");
const certificate_list_1 = require("./certificate-list");
const select_board_components_1 = require("./select-board-components");
const certificate_add_new_1 = require("./certificate-add-new");
const common_1 = require("@theia/core/lib/common");
const CertificateUploaderComponent = ({ availableBoards, certificates, addCertificate, updatableFqbns, uploadCertificates, openContextMenu, }) => {
    const [installFeedback, setInstallFeedback] = React.useState(null);
    const [showAdd, setShowAdd] = React.useState(false);
    const [selectedCerts, setSelectedCerts] = React.useState([]);
    const [selectedBoard, setSelectedBoard] = React.useState(null);
    const installCertificates = async () => {
        if (!selectedBoard || !selectedBoard.fqbn || !selectedBoard.port) {
            return;
        }
        setInstallFeedback('installing');
        try {
            await uploadCertificates(selectedBoard.fqbn, selectedBoard.port.address, selectedCerts);
            setInstallFeedback('ok');
        }
        catch (_a) {
            setInstallFeedback('fail');
        }
    };
    const onBoardSelect = React.useCallback((board) => {
        const newFqbn = (board && board.fqbn) || null;
        const prevFqbn = (selectedBoard && selectedBoard.fqbn) || null;
        if (newFqbn !== prevFqbn) {
            setInstallFeedback(null);
            setSelectedBoard(board);
        }
    }, [selectedBoard]);
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: "dialogSection" },
            React.createElement("div", { className: "dialogRow" },
                React.createElement("strong", { className: "fl1" }, common_1.nls.localize('arduino/certificate/selectCertificateToUpload', '1. Select certificate to upload')),
                React.createElement(react_1.default, { content: React.createElement(certificate_add_new_1.CertificateAddComponent, { addCertificate: (cert) => {
                            addCertificate(cert);
                            setShowAdd(false);
                        } }), placement: "bottom-end", onClickOutside: () => setShowAdd(false), visible: showAdd, interactive: true },
                    React.createElement("button", { type: "button", className: "theia-button secondary add-cert-btn", onClick: () => {
                            showAdd ? setShowAdd(false) : setShowAdd(true);
                        } },
                        common_1.nls.localize('arduino/certificate/addNew', 'Add New'),
                        ' ',
                        React.createElement("span", { className: "fa fa-caret-down caret" })))),
            React.createElement("div", { className: "dialogRow" },
                React.createElement(certificate_list_1.CertificateListComponent, { certificates: certificates, selectedCerts: selectedCerts, setSelectedCerts: setSelectedCerts, openContextMenu: openContextMenu }))),
        React.createElement("div", { className: "dialogSection" },
            React.createElement("div", { className: "dialogRow" },
                React.createElement("strong", null, common_1.nls.localize('arduino/certificate/selectDestinationBoardToUpload', '2. Select destination board and upload certificate'))),
            React.createElement("div", { className: "dialogRow" },
                React.createElement("div", { className: "fl1" },
                    React.createElement(select_board_components_1.SelectBoardComponent, { availableBoards: availableBoards, updatableFqbns: updatableFqbns, onBoardSelect: onBoardSelect, selectedBoard: selectedBoard, busy: installFeedback === 'installing' }))),
            React.createElement("div", { className: "dialogRow" },
                React.createElement("div", { className: "upload-status" },
                    installFeedback === 'installing' && (React.createElement("div", { className: "success" },
                        React.createElement("div", { className: "spinner" }),
                        common_1.nls.localize('arduino/certificate/uploadingCertificates', 'Uploading certificates.'))),
                    installFeedback === 'ok' && (React.createElement("div", { className: "success" },
                        React.createElement("i", { className: "fa fa-info status-icon" }),
                        common_1.nls.localize('arduino/certificate/certificatesUploaded', 'Certificates uploaded.'))),
                    installFeedback === 'fail' && (React.createElement("div", { className: "warn" },
                        React.createElement("i", { className: "fa fa-exclamation status-icon" }),
                        common_1.nls.localize('arduino/certificate/uploadFailed', 'Upload failed. Please try again.')))),
                React.createElement("button", { type: "button", className: "theia-button primary install-cert-btn", onClick: installCertificates, disabled: selectedCerts.length === 0 || !selectedBoard }, common_1.nls.localize('arduino/certificate/upload', 'Upload'))))));
};
exports.CertificateUploaderComponent = CertificateUploaderComponent;
//# sourceMappingURL=certificate-uploader-component.js.map