"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadCertificateDialog = exports.UploadCertificateDialogProps = exports.UploadCertificateDialogWidget = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const dialogs_1 = require("@theia/core/lib/browser/dialogs");
const dialogs_2 = require("../../theia/dialogs/dialogs");
const widgets_1 = require("@theia/core/shared/@phosphor/widgets");
const react_widget_1 = require("@theia/core/lib/browser/widgets/react-widget");
const boards_service_provider_1 = require("../../boards/boards-service-provider");
const certificate_uploader_component_1 = require("./certificate-uploader-component");
const arduino_preferences_1 = require("../../arduino-preferences");
const preference_service_1 = require("@theia/core/lib/browser/preferences/preference-service");
const command_1 = require("@theia/core/lib/common/command");
const utils_1 = require("./utils");
const arduino_firmware_uploader_1 = require("../../../common/protocol/arduino-firmware-uploader");
const common_1 = require("@theia/core/lib/common");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
let UploadCertificateDialogWidget = class UploadCertificateDialogWidget extends react_widget_1.ReactWidget {
    constructor() {
        super();
        this.certificates = [];
        this.updatableFqbns = [];
        this.availableBoards = [];
        this.busyCallback = (busy) => {
            return;
        };
    }
    init() {
        this.arduinoPreferences.ready.then(() => {
            this.certificates = (0, utils_1.certificateList)(this.arduinoPreferences.get('arduino.board.certificates'));
        });
        this.arduinoPreferences.onPreferenceChanged((event) => {
            if (event.preferenceName === 'arduino.board.certificates' &&
                event.newValue !== event.oldValue) {
                this.certificates = (0, utils_1.certificateList)(event.newValue);
                this.update();
            }
        });
        this.appStateService.reachedState('ready').then(() => this.arduinoFirmwareUploader.updatableBoards().then((fqbns) => {
            this.updatableFqbns = fqbns;
            this.update();
        }));
        this.boardsServiceClient.onAvailableBoardsChanged((availableBoards) => {
            this.availableBoards = availableBoards;
            this.update();
        });
    }
    addCertificate(certificate) {
        const certString = (0, utils_1.sanifyCertString)(certificate);
        if (certString.length > 0) {
            this.certificates.push((0, utils_1.sanifyCertString)(certificate));
        }
        this.preferenceService.set('arduino.board.certificates', this.certificates.join(','), preference_service_1.PreferenceScope.User);
    }
    openContextMenu(x, y, cert) {
        this.commandRegistry.executeCommand('arduino-certificate-open-context', Object.assign({}, { x, y, cert }));
    }
    uploadCertificates(fqbn, address, urls) {
        this.busyCallback(true);
        return this.commandRegistry
            .executeCommand('arduino-certificate-upload', {
            fqbn,
            address,
            urls,
        })
            .finally(() => this.busyCallback(false));
    }
    render() {
        return (React.createElement(certificate_uploader_component_1.CertificateUploaderComponent, { availableBoards: this.availableBoards, certificates: this.certificates, updatableFqbns: this.updatableFqbns, addCertificate: this.addCertificate.bind(this), uploadCertificates: this.uploadCertificates.bind(this), openContextMenu: this.openContextMenu.bind(this) }));
    }
};
__decorate([
    (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], UploadCertificateDialogWidget.prototype, "boardsServiceClient", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], UploadCertificateDialogWidget.prototype, "arduinoPreferences", void 0);
__decorate([
    (0, inversify_1.inject)(preference_service_1.PreferenceService),
    __metadata("design:type", Object)
], UploadCertificateDialogWidget.prototype, "preferenceService", void 0);
__decorate([
    (0, inversify_1.inject)(command_1.CommandRegistry),
    __metadata("design:type", command_1.CommandRegistry)
], UploadCertificateDialogWidget.prototype, "commandRegistry", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_firmware_uploader_1.ArduinoFirmwareUploader),
    __metadata("design:type", Object)
], UploadCertificateDialogWidget.prototype, "arduinoFirmwareUploader", void 0);
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], UploadCertificateDialogWidget.prototype, "appStateService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], UploadCertificateDialogWidget.prototype, "init", null);
UploadCertificateDialogWidget = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], UploadCertificateDialogWidget);
exports.UploadCertificateDialogWidget = UploadCertificateDialogWidget;
let UploadCertificateDialogProps = class UploadCertificateDialogProps extends dialogs_1.DialogProps {
};
UploadCertificateDialogProps = __decorate([
    (0, inversify_1.injectable)()
], UploadCertificateDialogProps);
exports.UploadCertificateDialogProps = UploadCertificateDialogProps;
let UploadCertificateDialog = class UploadCertificateDialog extends dialogs_2.AbstractDialog {
    constructor(props) {
        super({
            title: common_1.nls.localize('arduino/certificate/uploadRootCertificates', 'Upload SSL Root Certificates'),
        });
        this.props = props;
        this.busy = false;
        this.node.id = 'certificate-uploader-dialog-container';
        this.contentNode.classList.add('certificate-uploader-dialog');
        this.acceptButton = undefined;
    }
    get value() {
        return;
    }
    onAfterAttach(msg) {
        if (this.widget.isAttached) {
            widgets_1.Widget.detach(this.widget);
        }
        widgets_1.Widget.attach(this.widget, this.contentNode);
        this.widget.busyCallback = this.busyCallback.bind(this);
        super.onAfterAttach(msg);
        this.update();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.widget.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.widget.activate();
    }
    handleEnter(event) {
        return false;
    }
    close() {
        if (this.busy) {
            return;
        }
        super.close();
    }
    busyCallback(busy) {
        this.busy = busy;
        if (busy) {
            this.closeCrossNode.classList.add('disabled');
        }
        else {
            this.closeCrossNode.classList.remove('disabled');
        }
    }
};
__decorate([
    (0, inversify_1.inject)(UploadCertificateDialogWidget),
    __metadata("design:type", UploadCertificateDialogWidget)
], UploadCertificateDialog.prototype, "widget", void 0);
UploadCertificateDialog = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(UploadCertificateDialogProps)),
    __metadata("design:paramtypes", [UploadCertificateDialogProps])
], UploadCertificateDialog);
exports.UploadCertificateDialog = UploadCertificateDialog;
//# sourceMappingURL=certificate-uploader-dialog.js.map