"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.certificateList = exports.sanifyCertString = exports.arduinoCert = void 0;
exports.arduinoCert = 'arduino.cc:443';
function sanifyCertString(cert) {
    const regex = /^(?:.*:\/\/)*(\S+\.+[^:]*):*(\d*)*$/gm;
    const m = regex.exec(cert);
    if (!m) {
        return '';
    }
    const domain = m[1] || '';
    const port = m[2] || '443';
    if (domain.length === 0 || port.length === 0) {
        return '';
    }
    return `${domain}:${port}`;
}
exports.sanifyCertString = sanifyCertString;
function certificateList(certificates) {
    let certs = certificates
        .split(',')
        .map((cert) => sanifyCertString(cert.trim()))
        .filter((cert) => {
        // remove empty certificates
        if (!cert || cert.length === 0) {
            return false;
        }
        return true;
    });
    // add arduino certificate at the top of the list
    certs = certs.filter((cert) => cert !== exports.arduinoCert);
    certs.unshift(exports.arduinoCert);
    return certs;
}
exports.certificateList = certificateList;
//# sourceMappingURL=utils.js.map