"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShareSketchDialog = exports.ShareSketchDialogProps = exports.ShareSketchWidget = exports.ShareSketchComponent = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const widgets_1 = require("@theia/core/shared/@phosphor/widgets");
const electron_1 = require("electron");
const browser_1 = require("@theia/core/lib/browser");
const dialogs_1 = require("../theia/dialogs/dialogs");
const create_api_1 = require("../create/create-api");
const common_1 = require("@theia/core/lib/common");
const RadioButton = (props) => {
    return (React.createElement("p", { className: "RadioButton" },
        React.createElement("input", { id: props.id, onChange: props.changed, value: props.value, type: "radio", checked: props.isSelected, disabled: props.isDisabled }),
        React.createElement("label", { htmlFor: props.id }, props.label)));
};
const ShareSketchComponent = ({ treeNode, createApi, domain = 'https://create.arduino.cc', }) => {
    const [loading, setloading] = React.useState(false);
    const radioChangeHandler = async (event) => {
        setloading(true);
        const sketch = await createApi.editSketch({
            id: treeNode.sketchId,
            params: {
                is_public: event.target.value === 'private' ? false : true,
            },
        });
        // setPublicVisibility(sketch.is_public);
        treeNode.isPublic = sketch.is_public;
        setloading(false);
    };
    const sketchLink = `${domain}/editor/_/${treeNode.sketchId}/preview`;
    const embedLink = `<iframe src="${sketchLink}?embed" style="height:510px;width:100%;margin:10px 0" frameborder=0></iframe>`;
    return (React.createElement("div", { id: "widget-container arduino-sharesketch-dialog" },
        React.createElement("p", null, common_1.nls.localize('arduino/cloud/chooseSketchVisibility', 'Choose visibility of your Sketch:')),
        React.createElement(RadioButton, { changed: radioChangeHandler, id: "1", isSelected: treeNode.isPublic === false, label: common_1.nls.localize('arduino/cloud/privateVisibility', 'Private. Only you can view the Sketch.'), value: "private", isDisabled: loading }),
        React.createElement(RadioButton, { changed: radioChangeHandler, id: "2", isSelected: treeNode.isPublic === true, label: common_1.nls.localize('arduino/cloud/publicVisibility', 'Public. Anyone with the link can view the Sketch.'), value: "public", isDisabled: loading }),
        treeNode.isPublic && (React.createElement("div", null,
            React.createElement("p", null, common_1.nls.localize('arduino/cloud/link', 'Link:')),
            React.createElement("div", { className: "sketch-link" },
                React.createElement("input", { type: "text", readOnly: true, value: sketchLink, className: "theia-input" }),
                React.createElement("button", { onClick: () => electron_1.clipboard.writeText(sketchLink), value: "copy", className: "theia-button secondary" }, common_1.nls.localize('vscode/textInputActions/copy', 'Copy'))),
            React.createElement("p", null, common_1.nls.localize('arduino/cloud/embed', 'Embed:')),
            React.createElement("div", { className: "sketch-link-embed" },
                React.createElement("textarea", { readOnly: true, value: embedLink, className: "theia-input stretch" }))))));
};
exports.ShareSketchComponent = ShareSketchComponent;
let ShareSketchWidget = class ShareSketchWidget extends browser_1.ReactWidget {
    constructor(treeNode, createApi) {
        super();
        this.treeNode = treeNode;
        this.createApi = createApi;
    }
    render() {
        return (React.createElement(exports.ShareSketchComponent, { treeNode: this.treeNode, createApi: this.createApi }));
    }
};
ShareSketchWidget = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [Object, create_api_1.CreateApi])
], ShareSketchWidget);
exports.ShareSketchWidget = ShareSketchWidget;
let ShareSketchDialogProps = class ShareSketchDialogProps extends browser_1.DialogProps {
};
ShareSketchDialogProps = __decorate([
    (0, inversify_1.injectable)()
], ShareSketchDialogProps);
exports.ShareSketchDialogProps = ShareSketchDialogProps;
let ShareSketchDialog = class ShareSketchDialog extends dialogs_1.AbstractDialog {
    constructor(props) {
        super({ title: props.title });
        this.props = props;
        this.contentNode.classList.add('arduino-share-sketch-dialog');
        this.widget = new ShareSketchWidget(props.node, props.createApi);
    }
    get value() {
        return;
    }
    onAfterAttach(msg) {
        if (this.widget.isAttached) {
            widgets_1.Widget.detach(this.widget);
        }
        widgets_1.Widget.attach(this.widget, this.contentNode);
        super.onAfterAttach(msg);
        this.update();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.widget.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.widget.activate();
    }
};
ShareSketchDialog = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(ShareSketchDialogProps)),
    __metadata("design:paramtypes", [ShareSketchDialogProps])
], ShareSketchDialog);
exports.ShareSketchDialog = ShareSketchDialog;
//# sourceMappingURL=cloud-share-sketch-dialog.js.map