"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirmwareUploaderComponent = void 0;
const common_1 = require("@theia/core/lib/common");
const React = require("@theia/core/shared/react");
const arduino_select_1 = require("../../widgets/arduino-select");
const select_board_components_1 = require("../certificate-uploader/select-board-components");
const FirmwareUploaderComponent = ({ availableBoards, firmwareUploader, updatableFqbns, flashFirmware, isOpen, }) => {
    // boolean states for buttons
    const [firmwaresFetching, setFirmwaresFetching] = React.useState(false);
    const [installFeedback, setInstallFeedback] = React.useState(null);
    const [selectedBoard, setSelectedBoard] = React.useState(null);
    const [availableFirmwares, setAvailableFirmwares] = React.useState([]);
    React.useEffect(() => {
        setAvailableFirmwares([]);
    }, [isOpen]);
    const [selectedFirmware, setSelectedFirmware] = React.useState(null);
    const [firmwareOptions, setFirmwareOptions] = React.useState([]);
    const fetchFirmwares = React.useCallback(async () => {
        setInstallFeedback(null);
        setFirmwaresFetching(true);
        if (!selectedBoard) {
            return;
        }
        // fetch the firmwares for the selected board
        const firmwaresForFqbn = await firmwareUploader.availableFirmwares(selectedBoard.fqbn || '');
        setAvailableFirmwares(firmwaresForFqbn);
        const firmwaresOpts = firmwaresForFqbn.map((f) => ({
            label: f.firmware_version,
            value: f.firmware_version,
        }));
        setFirmwareOptions(firmwaresOpts);
        if (firmwaresForFqbn.length > 0)
            setSelectedFirmware(firmwaresOpts[0]);
        setFirmwaresFetching(false);
    }, [firmwareUploader, selectedBoard]);
    const installFirmware = React.useCallback(async () => {
        setInstallFeedback('installing');
        const firmwareToFlash = availableFirmwares.find((firmware) => firmware.firmware_version === (selectedFirmware === null || selectedFirmware === void 0 ? void 0 : selectedFirmware.value));
        try {
            const installStatus = !!firmwareToFlash &&
                !!(selectedBoard === null || selectedBoard === void 0 ? void 0 : selectedBoard.port) &&
                (await flashFirmware(firmwareToFlash, selectedBoard === null || selectedBoard === void 0 ? void 0 : selectedBoard.port));
            setInstallFeedback((installStatus && 'ok') || 'fail');
        }
        catch (_a) {
            setInstallFeedback('fail');
        }
    }, [firmwareUploader, selectedBoard, selectedFirmware, availableFirmwares]);
    const onBoardSelect = React.useCallback((board) => {
        const newFqbn = (board && board.fqbn) || null;
        const prevFqbn = (selectedBoard && selectedBoard.fqbn) || null;
        if (newFqbn !== prevFqbn) {
            setInstallFeedback(null);
            setAvailableFirmwares([]);
            setSelectedBoard(board);
        }
    }, [selectedBoard]);
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: "dialogSection" },
            React.createElement("div", { className: "dialogRow" },
                React.createElement("label", { htmlFor: "board-select" }, common_1.nls.localize('arduino/firmware/selectBoard', 'Select Board'))),
            React.createElement("div", { className: "dialogRow" },
                React.createElement("div", { className: "fl1" },
                    React.createElement(select_board_components_1.SelectBoardComponent, { availableBoards: availableBoards, updatableFqbns: updatableFqbns, onBoardSelect: onBoardSelect, selectedBoard: selectedBoard, busy: installFeedback === 'installing' })),
                React.createElement("button", { type: "button", className: "theia-button secondary", disabled: selectedBoard === null ||
                        firmwaresFetching ||
                        installFeedback === 'installing', onClick: fetchFirmwares }, common_1.nls.localize('arduino/firmware/checkUpdates', 'Check Updates')))),
        availableFirmwares.length > 0 && (React.createElement(React.Fragment, null,
            React.createElement("div", { className: "dialogSection" },
                React.createElement("div", { className: "dialogRow" },
                    React.createElement("label", { htmlFor: "firmware-select", className: "fl1" }, common_1.nls.localize('arduino/firmware/selectVersion', 'Select firmware version')),
                    React.createElement(arduino_select_1.ArduinoSelect, { id: "firmware-select", menuPosition: "fixed", isDisabled: !selectedBoard ||
                            firmwaresFetching ||
                            installFeedback === 'installing', options: firmwareOptions, value: selectedFirmware, tabSelectsValue: false, onChange: (value) => {
                            if (value) {
                                setInstallFeedback(null);
                                setSelectedFirmware(value);
                            }
                        } }),
                    React.createElement("button", { type: "button", className: "theia-button primary", disabled: selectedFirmware === null ||
                            firmwaresFetching ||
                            installFeedback === 'installing', onClick: installFirmware }, common_1.nls.localize('arduino/firmware/install', 'Install')))),
            React.createElement("div", { className: "dialogSection" },
                installFeedback === null && (React.createElement("div", { className: "dialogRow warn" },
                    React.createElement("i", { className: "fa fa-exclamation status-icon" }),
                    common_1.nls.localize('arduino/firmware/overwriteSketch', 'Installation will overwrite the Sketch on the board.'))),
                installFeedback === 'installing' && (React.createElement("div", { className: "dialogRow success" },
                    React.createElement("div", { className: "spinner" }),
                    common_1.nls.localize('arduino/firmware/installingFirmware', 'Installing firmware.'))),
                installFeedback === 'ok' && (React.createElement("div", { className: "dialogRow success" },
                    React.createElement("i", { className: "fa fa-info status-icon" }),
                    common_1.nls.localize('arduino/firmware/successfullyInstalled', 'Firmware successfully installed.'))),
                installFeedback === 'fail' && (React.createElement("div", { className: "dialogRow warn" },
                    React.createElement("i", { className: "fa fa-exclamation status-icon" }),
                    common_1.nls.localize('arduino/firmware/failedInstall', 'Installation failed. Please try again.'))))))));
};
exports.FirmwareUploaderComponent = FirmwareUploaderComponent;
//# sourceMappingURL=firmware-uploader-component.js.map