"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadFirmwareDialog = exports.UploadFirmwareDialogProps = exports.UploadFirmwareDialogWidget = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const dialogs_1 = require("@theia/core/lib/browser/dialogs");
const dialogs_2 = require("../../theia/dialogs/dialogs");
const widgets_1 = require("@theia/core/shared/@phosphor/widgets");
const react_widget_1 = require("@theia/core/lib/browser/widgets/react-widget");
const boards_service_provider_1 = require("../../boards/boards-service-provider");
const arduino_firmware_uploader_1 = require("../../../common/protocol/arduino-firmware-uploader");
const firmware_uploader_component_1 = require("./firmware-uploader-component");
const upload_firmware_1 = require("../../contributions/upload-firmware");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
let UploadFirmwareDialogWidget = class UploadFirmwareDialogWidget extends react_widget_1.ReactWidget {
    constructor() {
        super();
        this.updatableFqbns = [];
        this.availableBoards = [];
        this.isOpen = new Object();
        this.busyCallback = (busy) => {
            return;
        };
    }
    init() {
        this.appStatusService.reachedState('ready').then(async () => {
            const fqbns = await this.arduinoFirmwareUploader.updatableBoards();
            this.updatableFqbns = fqbns;
            this.update();
        });
        this.boardsServiceClient.onAvailableBoardsChanged((availableBoards) => {
            this.availableBoards = availableBoards;
            this.update();
        });
    }
    flashFirmware(firmware, port) {
        this.busyCallback(true);
        return this.arduinoFirmwareUploader
            .flash(firmware, port)
            .finally(() => this.busyCallback(false));
    }
    onCloseRequest(msg) {
        super.onCloseRequest(msg);
        this.isOpen = new Object();
    }
    render() {
        return (React.createElement("form", null,
            React.createElement(firmware_uploader_component_1.FirmwareUploaderComponent, { availableBoards: this.availableBoards, firmwareUploader: this.arduinoFirmwareUploader, flashFirmware: this.flashFirmware.bind(this), updatableFqbns: this.updatableFqbns, isOpen: this.isOpen })));
    }
};
__decorate([
    (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], UploadFirmwareDialogWidget.prototype, "boardsServiceClient", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_firmware_uploader_1.ArduinoFirmwareUploader),
    __metadata("design:type", Object)
], UploadFirmwareDialogWidget.prototype, "arduinoFirmwareUploader", void 0);
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], UploadFirmwareDialogWidget.prototype, "appStatusService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], UploadFirmwareDialogWidget.prototype, "init", null);
UploadFirmwareDialogWidget = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], UploadFirmwareDialogWidget);
exports.UploadFirmwareDialogWidget = UploadFirmwareDialogWidget;
let UploadFirmwareDialogProps = class UploadFirmwareDialogProps extends dialogs_1.DialogProps {
};
UploadFirmwareDialogProps = __decorate([
    (0, inversify_1.injectable)()
], UploadFirmwareDialogProps);
exports.UploadFirmwareDialogProps = UploadFirmwareDialogProps;
let UploadFirmwareDialog = class UploadFirmwareDialog extends dialogs_2.AbstractDialog {
    constructor(props) {
        super({ title: upload_firmware_1.UploadFirmware.Commands.OPEN.label || '' });
        this.props = props;
        this.busy = false;
        this.node.id = 'firmware-uploader-dialog-container';
        this.contentNode.classList.add('firmware-uploader-dialog');
        this.acceptButton = undefined;
    }
    get value() {
        return;
    }
    onAfterAttach(msg) {
        if (this.widget.isAttached) {
            widgets_1.Widget.detach(this.widget);
        }
        widgets_1.Widget.attach(this.widget, this.contentNode);
        this.widget.busyCallback = this.busyCallback.bind(this);
        super.onAfterAttach(msg);
        this.update();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.widget.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.widget.activate();
    }
    handleEnter(event) {
        return false;
    }
    close() {
        if (this.busy) {
            return;
        }
        this.widget.close();
        super.close();
    }
    busyCallback(busy) {
        this.busy = busy;
        if (busy) {
            this.closeCrossNode.classList.add('disabled');
        }
        else {
            this.closeCrossNode.classList.remove('disabled');
        }
    }
};
__decorate([
    (0, inversify_1.inject)(UploadFirmwareDialogWidget),
    __metadata("design:type", UploadFirmwareDialogWidget)
], UploadFirmwareDialog.prototype, "widget", void 0);
UploadFirmwareDialog = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(UploadFirmwareDialogProps)),
    __metadata("design:paramtypes", [UploadFirmwareDialogProps])
], UploadFirmwareDialog);
exports.UploadFirmwareDialog = UploadFirmwareDialog;
//# sourceMappingURL=firmware-uploader-dialog.js.map