"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDEUpdaterDialog = exports.IDEUpdaterDialogProps = exports.IDEUpdaterDialogWidget = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const dialogs_1 = require("@theia/core/lib/browser/dialogs");
const dialogs_2 = require("../../theia/dialogs/dialogs");
const widgets_1 = require("@theia/core/shared/@phosphor/widgets");
const react_widget_1 = require("@theia/core/lib/browser/widgets/react-widget");
const core_1 = require("@theia/core");
const ide_updater_component_1 = require("./ide-updater-component");
const ide_updater_1 = require("../../../common/protocol/ide-updater");
const browser_1 = require("@theia/core/lib/browser");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const DOWNLOAD_PAGE_URL = 'https://www.arduino.cc/en/software#experimental-software';
let IDEUpdaterDialogWidget = class IDEUpdaterDialogWidget extends react_widget_1.ReactWidget {
    constructor() {
        super(...arguments);
        this._updateProgress = {};
    }
    setUpdateInfo(updateInfo) {
        this._updateInfo = updateInfo;
        this.update();
    }
    mergeUpdateProgress(updateProgress) {
        this._updateProgress = Object.assign(Object.assign({}, this._updateProgress), updateProgress);
        this.update();
    }
    get updateInfo() {
        return this._updateInfo;
    }
    get updateProgress() {
        return this._updateProgress;
    }
    render() {
        return !!this._updateInfo ? (React.createElement(ide_updater_component_1.IDEUpdaterComponent, { updateInfo: this._updateInfo, updateProgress: this._updateProgress })) : null;
    }
};
IDEUpdaterDialogWidget = __decorate([
    (0, inversify_1.injectable)()
], IDEUpdaterDialogWidget);
exports.IDEUpdaterDialogWidget = IDEUpdaterDialogWidget;
let IDEUpdaterDialogProps = class IDEUpdaterDialogProps extends dialogs_1.DialogProps {
};
IDEUpdaterDialogProps = __decorate([
    (0, inversify_1.injectable)()
], IDEUpdaterDialogProps);
exports.IDEUpdaterDialogProps = IDEUpdaterDialogProps;
let IDEUpdaterDialog = class IDEUpdaterDialog extends dialogs_2.AbstractDialog {
    constructor(props) {
        super({
            title: core_1.nls.localize('arduino/ide-updater/ideUpdaterDialog', 'Software Update'),
        });
        this.props = props;
        this.node.id = 'ide-updater-dialog-container';
        this.contentNode.classList.add('ide-updater-dialog');
        this.acceptButton = undefined;
    }
    init() {
        this.updaterClient.onUpdaterDidFail((error) => {
            this.appendErrorButtons();
            this.widget.mergeUpdateProgress({ error });
        });
        this.updaterClient.onDownloadProgressDidChange((progressInfo) => {
            this.widget.mergeUpdateProgress({ progressInfo });
        });
        this.updaterClient.onDownloadDidFinish(() => {
            this.appendInstallButtons();
            this.widget.mergeUpdateProgress({ downloadFinished: true });
        });
    }
    get value() {
        return this.widget.updateInfo;
    }
    onAfterAttach(msg) {
        if (this.widget.isAttached) {
            widgets_1.Widget.detach(this.widget);
        }
        widgets_1.Widget.attach(this.widget, this.contentNode);
        this.appendInitialButtons();
        super.onAfterAttach(msg);
    }
    clearButtons() {
        while (this.controlPanel.firstChild) {
            this.controlPanel.removeChild(this.controlPanel.firstChild);
        }
        this.closeButton = undefined;
    }
    appendNotNowButton() {
        this.appendCloseButton(core_1.nls.localize('arduino/ide-updater/notNowButton', 'Not now'));
        if (this.closeButton) {
            this.addCloseAction(this.closeButton, 'click');
        }
    }
    appendInitialButtons() {
        this.clearButtons();
        const skipVersionButton = this.createButton(core_1.nls.localize('arduino/ide-updater/skipVersionButton', 'Skip Version'));
        skipVersionButton.classList.add('secondary');
        skipVersionButton.classList.add('skip-version-button');
        this.addAction(skipVersionButton, this.skipVersion.bind(this), 'click');
        this.controlPanel.appendChild(skipVersionButton);
        this.appendNotNowButton();
        const downloadButton = this.createButton(core_1.nls.localize('arduino/ide-updater/downloadButton', 'Download'));
        this.addAction(downloadButton, this.startDownload.bind(this), 'click');
        this.controlPanel.appendChild(downloadButton);
        downloadButton.focus();
    }
    appendInstallButtons() {
        this.clearButtons();
        this.appendNotNowButton();
        const closeAndInstallButton = this.createButton(core_1.nls.localize('arduino/ide-updater/closeAndInstallButton', 'Close and Install'));
        this.addAction(closeAndInstallButton, this.closeAndInstall.bind(this), 'click');
        this.controlPanel.appendChild(closeAndInstallButton);
        closeAndInstallButton.focus();
    }
    appendErrorButtons() {
        this.clearButtons();
        this.appendNotNowButton();
        const goToDownloadPageButton = this.createButton(core_1.nls.localize('arduino/ide-updater/goToDownloadButton', 'Go To Download'));
        this.addAction(goToDownloadPageButton, this.openDownloadPage.bind(this), 'click');
        this.controlPanel.appendChild(goToDownloadPageButton);
        goToDownloadPageButton.focus();
    }
    openDownloadPage() {
        this.windowService.openNewWindow(DOWNLOAD_PAGE_URL, { external: true });
        this.close();
    }
    skipVersion() {
        this.localStorageService.setData(ide_updater_1.SKIP_IDE_VERSION, this.widget.updateInfo.version);
        this.close();
    }
    startDownload() {
        this.widget.mergeUpdateProgress({
            downloadStarted: true,
        });
        this.clearButtons();
        this.updater.downloadUpdate();
    }
    closeAndInstall() {
        this.updater.quitAndInstall();
        this.close();
    }
    async open(data = undefined) {
        if (data && data.version) {
            this.widget.mergeUpdateProgress({
                progressInfo: undefined,
                downloadStarted: false,
                downloadFinished: false,
                error: undefined,
            });
            this.widget.setUpdateInfo(data);
            return super.open();
        }
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.widget.activate();
    }
    close() {
        var _a, _b;
        this.widget.dispose();
        if (((_a = this.widget.updateProgress) === null || _a === void 0 ? void 0 : _a.downloadStarted) &&
            !((_b = this.widget.updateProgress) === null || _b === void 0 ? void 0 : _b.downloadFinished)) {
            this.updater.stopDownload();
        }
        super.close();
    }
};
__decorate([
    (0, inversify_1.inject)(IDEUpdaterDialogWidget),
    __metadata("design:type", IDEUpdaterDialogWidget)
], IDEUpdaterDialog.prototype, "widget", void 0);
__decorate([
    (0, inversify_1.inject)(ide_updater_1.IDEUpdater),
    __metadata("design:type", Object)
], IDEUpdaterDialog.prototype, "updater", void 0);
__decorate([
    (0, inversify_1.inject)(ide_updater_1.IDEUpdaterClient),
    __metadata("design:type", Object)
], IDEUpdaterDialog.prototype, "updaterClient", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.LocalStorageService),
    __metadata("design:type", browser_1.LocalStorageService)
], IDEUpdaterDialog.prototype, "localStorageService", void 0);
__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    __metadata("design:type", Object)
], IDEUpdaterDialog.prototype, "windowService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], IDEUpdaterDialog.prototype, "init", null);
IDEUpdaterDialog = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(IDEUpdaterDialogProps)),
    __metadata("design:paramtypes", [IDEUpdaterDialogProps])
], IDEUpdaterDialog);
exports.IDEUpdaterDialog = IDEUpdaterDialog;
//# sourceMappingURL=ide-updater-dialog.js.map