"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("@theia/core/shared/react");
const classnames_1 = require("classnames");
const SettingsStepInput = (props) => {
    const { value, setSettingsStateValue, step, maxValue, minValue, unitOfMeasure, classNames, } = props;
    const clamp = (value, min, max) => {
        return Math.min(Math.max(value, min), max);
    };
    const onStep = (roundingOperation, stepOperation) => {
        const valueRoundedToScale = Math[roundingOperation](value / step) * step;
        const calculatedValue = valueRoundedToScale === value
            ? stepOperation(value, step)
            : valueRoundedToScale;
        const newValue = clamp(calculatedValue, minValue, maxValue);
        setSettingsStateValue(newValue);
    };
    const onStepUp = () => {
        onStep('ceil', (a, b) => a + b);
    };
    const onStepDown = () => {
        onStep('floor', (a, b) => a - b);
    };
    const onUserInput = (event) => {
        const { value: eventValue } = event.target;
        if (eventValue === '') {
            setSettingsStateValue(0);
        }
        const number = Number(eventValue);
        if (!isNaN(number) && number !== value) {
            const newValue = clamp(number, minValue, maxValue);
            setSettingsStateValue(newValue);
        }
    };
    const upDisabled = value >= maxValue;
    const downDisabled = value <= minValue;
    return (React.createElement("div", { className: "settings-step-input-container" },
        React.createElement("input", { className: (0, classnames_1.default)('settings-step-input-element', classNames === null || classNames === void 0 ? void 0 : classNames.input), value: value.toString(), onChange: onUserInput, type: "number", pattern: "[0-9]+" }),
        React.createElement("div", { className: "settings-step-input-buttons-container" },
            React.createElement("button", { className: "settings-step-input-button settings-step-input-up-button", disabled: upDisabled, onClick: onStepUp }, "\u25BE"),
            React.createElement("button", { className: "settings-step-input-button", disabled: downDisabled, onClick: onStepDown }, "\u25BE")),
        unitOfMeasure && `${unitOfMeasure}`));
};
exports.default = SettingsStepInput;
//# sourceMappingURL=settings-step-input.js.map