"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserFieldsDialog = exports.UserFieldsDialogProps = exports.UserFieldsDialogWidget = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/core/lib/browser");
const widgets_1 = require("@theia/core/shared/@phosphor/widgets");
const upload_sketch_1 = require("../../contributions/upload-sketch");
const user_fields_component_1 = require("./user-fields-component");
let UserFieldsDialogWidget = class UserFieldsDialogWidget extends browser_1.ReactWidget {
    constructor(cancel, accept) {
        super();
        this.cancel = cancel;
        this.accept = accept;
        this._currentUserFields = [];
    }
    set currentUserFields(userFields) {
        this.setUserFields(userFields);
    }
    get currentUserFields() {
        return this._currentUserFields;
    }
    resetUserFieldsValue() {
        this._currentUserFields = this._currentUserFields.map((field) => {
            field.value = '';
            return field;
        });
    }
    setUserFields(userFields) {
        this._currentUserFields = userFields;
    }
    render() {
        return (React.createElement("form", null,
            React.createElement(user_fields_component_1.UserFieldsComponent, { initialBoardUserFields: this._currentUserFields, updateUserFields: this.setUserFields.bind(this), cancel: this.cancel, accept: this.accept })));
    }
};
UserFieldsDialogWidget = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [Function, Function])
], UserFieldsDialogWidget);
exports.UserFieldsDialogWidget = UserFieldsDialogWidget;
let UserFieldsDialogProps = class UserFieldsDialogProps extends browser_1.DialogProps {
};
UserFieldsDialogProps = __decorate([
    (0, inversify_1.injectable)()
], UserFieldsDialogProps);
exports.UserFieldsDialogProps = UserFieldsDialogProps;
let UserFieldsDialog = class UserFieldsDialog extends browser_1.AbstractDialog {
    constructor(props) {
        super({
            title: upload_sketch_1.UploadSketch.Commands.UPLOAD_WITH_CONFIGURATION.label || '',
        });
        this.props = props;
        this.titleNode.classList.add('user-fields-dialog-title');
        this.contentNode.classList.add('user-fields-dialog-content');
        this.acceptButton = undefined;
        this.widget = new UserFieldsDialogWidget(this.close.bind(this), this.accept.bind(this));
    }
    set value(userFields) {
        this.widget.currentUserFields = userFields;
    }
    get value() {
        return this.widget.currentUserFields;
    }
    onAfterAttach(msg) {
        if (this.widget.isAttached) {
            widgets_1.Widget.detach(this.widget);
        }
        widgets_1.Widget.attach(this.widget, this.contentNode);
        super.onAfterAttach(msg);
        this.update();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.widget.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.widget.activate();
    }
    async accept() {
        // If the user presses enter and at least
        // a field is empty don't accept the input
        for (const field of this.value) {
            if (field.value.length === 0) {
                return;
            }
        }
        return super.accept();
    }
    close() {
        this.widget.resetUserFieldsValue();
        this.widget.close();
        super.close();
    }
};
UserFieldsDialog = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(UserFieldsDialogProps)),
    __metadata("design:paramtypes", [UserFieldsDialogProps])
], UserFieldsDialog);
exports.UserFieldsDialog = UserFieldsDialog;
//# sourceMappingURL=user-fields-dialog.js.map