"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostedPluginEvents = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
const hosted_plugin_1 = require("./theia/plugin-ext/hosted-plugin");
/**
 * Frontend contribution to watch VS Code extension start/stop events from Theia.
 *
 * In Theia, there are no events when a VS Code extension is loaded, started, unloaded, and stopped.
 * Currently, it's possible to `@inject` the `HostedPluginSupport` service from Theia and `await`
 * for the `didStart` promise to resolve. But if the OS goes to sleep, the VS Code extensions will
 * be unloaded and loaded and started again when the OS awakes. Theia reloads the VS Code extensions
 * after the OS awake event, but the `didStart` promise was already resolved, so IDE2 cannot restart the LS.
 * This service is meant to work around the limitation of Theia and fire an event every time the VS Code extensions
 * loaded and started.
 */
let HostedPluginEvents = class HostedPluginEvents {
    constructor() {
        this.firstStart = true;
        this.onPluginsDidStartEmitter = new core_1.Emitter();
        this.onPluginsWillUnloadEmitter = new core_1.Emitter();
        this.toDispose = new core_1.DisposableCollection(this.onPluginsDidStartEmitter, this.onPluginsWillUnloadEmitter);
    }
    onStart() {
        this.hostedPluginSupport.onDidLoad(() => {
            // Fire the first event, when `didStart` resolves.
            if (!this.firstStart) {
                console.debug('HostedPluginEvents', "Received 'onDidLoad' event.");
                this.onPluginsDidStartEmitter.fire();
            }
            else {
                console.debug('HostedPluginEvents', "Received 'onDidLoad' event before the first start. Skipping.");
            }
        });
        this.hostedPluginSupport.didStart.then(() => {
            console.debug('HostedPluginEvents', "Hosted plugins 'didStart'.");
            if (!this.firstStart) {
                throw new Error('Unexpectedly received a `didStart` event after the first start.');
            }
            this.firstStart = false;
            this.onPluginsDidStartEmitter.fire();
        });
        this.hostedPluginSupport.onDidCloseConnection(() => {
            console.debug('HostedPluginEvents', "Received 'onDidCloseConnection'.");
            this.onPluginsWillUnloadEmitter.fire();
        });
    }
    onStop() {
        this.toDispose.dispose();
    }
    get onPluginsDidStart() {
        return this.onPluginsDidStartEmitter.event;
    }
    get onPluginsWillUnload() {
        return this.onPluginsWillUnloadEmitter.event;
    }
    get didStart() {
        return this.hostedPluginSupport.didStart;
    }
};
__decorate([
    (0, inversify_1.inject)(hosted_plugin_1.HostedPluginSupport),
    __metadata("design:type", hosted_plugin_1.HostedPluginSupport)
], HostedPluginEvents.prototype, "hostedPluginSupport", void 0);
HostedPluginEvents = __decorate([
    (0, inversify_1.injectable)()
], HostedPluginEvents);
exports.HostedPluginEvents = HostedPluginEvents;
//# sourceMappingURL=hosted-plugin-events.js.map