"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDEUpdaterClientImpl = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
let IDEUpdaterClientImpl = class IDEUpdaterClientImpl {
    constructor() {
        this.onUpdaterDidFailEmitter = new core_1.Emitter();
        this.onUpdaterDidCheckForUpdateEmitter = new core_1.Emitter();
        this.onUpdaterDidFindUpdateAvailableEmitter = new core_1.Emitter();
        this.onUpdaterDidNotFindUpdateAvailableEmitter = new core_1.Emitter();
        this.onDownloadProgressDidChangeEmitter = new core_1.Emitter();
        this.onDownloadDidFinishEmitter = new core_1.Emitter();
        this.onUpdaterDidFail = this.onUpdaterDidFailEmitter.event;
        this.onUpdaterDidCheckForUpdate = this.onUpdaterDidCheckForUpdateEmitter.event;
        this.onUpdaterDidFindUpdateAvailable = this.onUpdaterDidFindUpdateAvailableEmitter.event;
        this.onUpdaterDidNotFindUpdateAvailable = this.onUpdaterDidNotFindUpdateAvailableEmitter.event;
        this.onDownloadProgressDidChange = this.onDownloadProgressDidChangeEmitter.event;
        this.onDownloadDidFinish = this.onDownloadDidFinishEmitter.event;
    }
    notifyUpdaterFailed(message) {
        this.onUpdaterDidFailEmitter.fire(message);
    }
    notifyCheckedForUpdate(message) {
        this.onUpdaterDidCheckForUpdateEmitter.fire(message);
    }
    notifyUpdateAvailableFound(message) {
        this.onUpdaterDidFindUpdateAvailableEmitter.fire(message);
    }
    notifyUpdateAvailableNotFound(message) {
        this.onUpdaterDidNotFindUpdateAvailableEmitter.fire(message);
    }
    notifyDownloadProgressChanged(message) {
        this.onDownloadProgressDidChangeEmitter.fire(message);
    }
    notifyDownloadFinished(message) {
        this.onDownloadDidFinishEmitter.fire(message);
    }
};
IDEUpdaterClientImpl = __decorate([
    (0, inversify_1.injectable)()
], IDEUpdaterClientImpl);
exports.IDEUpdaterClientImpl = IDEUpdaterClientImpl;
//# sourceMappingURL=ide-updater-client-impl.js.map