"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var LibraryListWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryListWidget = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const widget_1 = require("@theia/core/lib/browser/widgets/widget");
const dialogs_1 = require("../theia/dialogs/dialogs");
const library_service_1 = require("../../common/protocol/library-service");
const list_widget_1 = require("../widgets/component-list/list-widget");
const list_item_renderer_1 = require("../widgets/component-list/list-item-renderer");
const common_1 = require("@theia/core/lib/common");
const filter_renderer_1 = require("../widgets/component-list/filter-renderer");
let LibraryListWidget = LibraryListWidget_1 = class LibraryListWidget extends list_widget_1.ListWidget {
    constructor(service, itemRenderer, filterRenderer) {
        super({
            id: LibraryListWidget_1.WIDGET_ID,
            label: LibraryListWidget_1.WIDGET_LABEL,
            iconClass: 'fa fa-arduino-library',
            searchable: service,
            installable: service,
            itemLabel: (item) => item.name,
            itemDeprecated: (item) => item.deprecated,
            itemRenderer,
            filterRenderer,
            defaultSearchOptions: { query: '', type: 'All', topic: 'All' },
        });
        this.service = service;
    }
    init() {
        super.init();
        this.toDispose.pushAll([
            this.notificationCenter.onLibraryDidInstall(() => this.refresh(undefined)),
            this.notificationCenter.onLibraryDidUninstall(() => this.refresh(undefined)),
        ]);
    }
    async install({ item, progressId, version, }) {
        const dependencies = await this.service.listDependencies({
            item,
            version,
            filterSelf: true,
        });
        let installDependencies = undefined;
        if (dependencies.length) {
            const message = document.createElement('div');
            message.innerHTML =
                dependencies.length === 1
                    ? common_1.nls.localize('arduino/library/needsOneDependency', 'The library <b>{0}:{1}</b> needs another dependency currently not installed:', item.name, version)
                    : common_1.nls.localize('arduino/library/needsMultipleDependencies', 'The library <b>{0}:{1}</b> needs some other dependencies currently not installed:', item.name, version);
            const listContainer = document.createElement('div');
            listContainer.style.maxHeight = '300px';
            listContainer.style.overflowY = 'auto';
            const list = document.createElement('ul');
            list.style.listStyleType = 'none';
            for (const { name } of dependencies) {
                const listItem = document.createElement('li');
                listItem.textContent = ` - ${name}`;
                listItem.style.fontWeight = 'bold';
                list.appendChild(listItem);
            }
            listContainer.appendChild(list);
            message.appendChild(listContainer);
            const question = document.createElement('div');
            question.textContent =
                dependencies.length === 1
                    ? common_1.nls.localize('arduino/library/installOneMissingDependency', 'Would you like to install the missing dependency?')
                    : common_1.nls.localize('arduino/library/installMissingDependencies', 'Would you like to install all the missing dependencies?');
            message.appendChild(question);
            const result = await new MessageBoxDialog({
                title: common_1.nls.localize('arduino/library/dependenciesForLibrary', 'Dependencies for library {0}:{1}', item.name, version),
                message,
                buttons: [
                    common_1.nls.localize('arduino/library/installAll', 'Install all'),
                    common_1.nls.localize('arduino/library/installOnly', 'Install {0} only', item.name),
                    common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'),
                ],
                maxWidth: 740, // Aligned with `settings-dialog.css`.
            }).open();
            if (result) {
                const { response } = result;
                if (response === 0) {
                    // All
                    installDependencies = true;
                }
                else if (response === 1) {
                    // Current only
                    installDependencies = false;
                }
            }
        }
        else {
            // The lib does not have any dependencies.
            installDependencies = false;
        }
        if (typeof installDependencies === 'boolean') {
            await this.service.install({
                item,
                version,
                progressId,
                installDependencies,
            });
            this.messageService.info(common_1.nls.localize('arduino/library/installedSuccessfully', 'Successfully installed library {0}:{1}', item.name, version), { timeout: 3000 });
        }
    }
    async uninstall({ item, progressId, }) {
        await super.uninstall({ item, progressId });
        this.messageService.info(common_1.nls.localize('arduino/library/uninstalledSuccessfully', 'Successfully uninstalled library {0}:{1}', item.name, item.installedVersion), { timeout: 3000 });
    }
};
LibraryListWidget.WIDGET_ID = 'library-list-widget';
LibraryListWidget.WIDGET_LABEL = common_1.nls.localize('arduino/library/title', 'Library Manager');
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], LibraryListWidget.prototype, "init", null);
LibraryListWidget = LibraryListWidget_1 = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(library_service_1.LibraryService)),
    __param(1, (0, inversify_1.inject)(list_item_renderer_1.ListItemRenderer)),
    __param(2, (0, inversify_1.inject)(filter_renderer_1.LibraryFilterRenderer)),
    __metadata("design:paramtypes", [Object, list_item_renderer_1.ListItemRenderer,
        filter_renderer_1.LibraryFilterRenderer])
], LibraryListWidget);
exports.LibraryListWidget = LibraryListWidget;
class MessageBoxDialog extends dialogs_1.AbstractDialog {
    constructor(options) {
        super(options);
        this.options = options;
        this.contentNode.appendChild(this.createMessageNode(this.options.message));
        (options.buttons || [common_1.nls.localize('vscode/issueMainService/ok', 'OK')]).forEach((text, index) => {
            const button = this.createButton(text);
            button.classList.add(index === 0 ? 'main' : 'secondary');
            this.controlPanel.appendChild(button);
            this.toDisposeOnDetach.push((0, widget_1.addEventListener)(button, 'click', () => {
                this.response = index;
                this.accept();
            }));
        });
    }
    onCloseRequest(message) {
        super.onCloseRequest(message);
        this.accept();
    }
    get value() {
        return { response: this.response };
    }
    createMessageNode(message) {
        if (typeof message === 'string') {
            const messageNode = document.createElement('div');
            messageNode.textContent = message;
            return messageNode;
        }
        return message;
    }
    handleEnter(event) {
        this.response = 0;
        super.handleEnter(event);
    }
}
//# sourceMappingURL=library-list-widget.js.map