"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalCacheFsProvider = exports.LocalCacheUri = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const vscode_uri_1 = require("vscode-uri");
const uri_1 = require("@theia/core/lib/common/uri");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
const files_1 = require("@theia/filesystem/lib/common/files");
const disposable_1 = require("@theia/core/lib/common/disposable");
const delegating_file_system_provider_1 = require("@theia/filesystem/lib/common/delegating-file-system-provider");
const authentication_client_service_1 = require("../auth/authentication-client-service");
const protocol_1 = require("../../common/protocol");
var LocalCacheUri;
(function (LocalCacheUri) {
    LocalCacheUri.scheme = 'arduino-local-cache';
    LocalCacheUri.root = new uri_1.default(vscode_uri_1.URI.parse('/').with({ scheme: LocalCacheUri.scheme, authority: 'create' }));
})(LocalCacheUri = exports.LocalCacheUri || (exports.LocalCacheUri = {}));
let LocalCacheFsProvider = class LocalCacheFsProvider {
    constructor() {
        // TODO: do we need this? Cannot we `await` on the `init` call from `registerFileSystemProviders`?
        this.ready = new promise_util_1.Deferred();
    }
    registerFileSystemProviders(fileService) {
        fileService.onWillActivateFileSystemProvider(async (event) => {
            if (event.scheme === LocalCacheUri.scheme) {
                event.waitUntil((async () => {
                    this.init(fileService);
                    const provider = await this.createProvider(fileService);
                    fileService.registerProvider(LocalCacheUri.scheme, provider);
                })());
            }
        });
    }
    to(resource) {
        const relativePath = LocalCacheUri.root.relative(resource);
        if (relativePath) {
            return this.currentUserUri.resolve(relativePath).normalizePath();
        }
        return undefined;
    }
    from(resource) {
        const relativePath = this.currentUserUri.relative(resource);
        if (relativePath) {
            return LocalCacheUri.root.resolve(relativePath);
        }
        return undefined;
    }
    async createProvider(fileService) {
        const delegate = await fileService.activateProvider('file');
        await this.ready.promise;
        return new delegating_file_system_provider_1.DelegatingFileSystemProvider(delegate, {
            uriConverter: this,
        }, new disposable_1.DisposableCollection(delegate.watch(this.localCacheRoot, {
            excludes: [],
            recursive: true,
        })));
    }
    async init(fileService) {
        const config = await this.configService.getConfiguration();
        this._localCacheRoot = new uri_1.default(config.dataDirUri);
        for (const segment of ['RemoteSketchbook', 'ArduinoCloud']) {
            this._localCacheRoot = this._localCacheRoot.resolve(segment);
            await fileService.createFolder(this._localCacheRoot);
        }
        this.session(fileService).then(() => this.ready.resolve());
        this.authenticationService.onSessionDidChange(async (session) => {
            if (session) {
                await this.ensureExists(session, fileService);
            }
        });
    }
    get currentUserUri() {
        const { session } = this.authenticationService;
        if (!session) {
            throw new files_1.FileSystemProviderError('Not logged in.', files_1.FileSystemProviderErrorCode.NoPermissions);
        }
        return this.toUri(session);
    }
    get localCacheRoot() {
        return this._localCacheRoot;
    }
    async session(fileService) {
        return new Promise(async (resolve) => {
            const { session } = this.authenticationService;
            if (session) {
                await this.ensureExists(session, fileService);
                resolve(session);
                return;
            }
            const toDispose = new disposable_1.DisposableCollection();
            toDispose.push(this.authenticationService.onSessionDidChange(async (session) => {
                if (session) {
                    await this.ensureExists(session, fileService);
                    toDispose.dispose();
                    resolve(session);
                }
            }));
        });
    }
    async ensureExists(session, fileService) {
        const uri = this.toUri(session);
        const exists = await fileService.exists(uri);
        if (!exists) {
            await fileService.createFolder(uri);
        }
        return uri;
    }
    toUri(session) {
        // Hack: instead of getting the UUID only, we get `auth0|UUID` after the authentication. `|` cannot be part of filesystem path or filename.
        return this._localCacheRoot.resolve(session.id.split('|')[1]);
    }
};
__decorate([
    (0, inversify_1.inject)(protocol_1.ConfigService),
    __metadata("design:type", Object)
], LocalCacheFsProvider.prototype, "configService", void 0);
__decorate([
    (0, inversify_1.inject)(authentication_client_service_1.AuthenticationClientService),
    __metadata("design:type", authentication_client_service_1.AuthenticationClientService)
], LocalCacheFsProvider.prototype, "authenticationService", void 0);
LocalCacheFsProvider = __decorate([
    (0, inversify_1.injectable)()
], LocalCacheFsProvider);
exports.LocalCacheFsProvider = LocalCacheFsProvider;
//# sourceMappingURL=local-cache-fs-provider.js.map