"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaceholderMenuNode = exports.unregisterSubmenu = exports.ArduinoMenus = void 0;
const os_1 = require("@theia/core/lib/common/os");
const common_frontend_contribution_1 = require("@theia/core/lib/browser/common-frontend-contribution");
const menu_1 = require("@theia/core/lib/common/menu");
var ArduinoMenus;
(function (ArduinoMenus) {
    // Main menu
    // -- File
    ArduinoMenus.FILE__SKETCH_GROUP = [...common_frontend_contribution_1.CommonMenus.FILE, '0_sketch'];
    ArduinoMenus.FILE__PRINT_GROUP = [...common_frontend_contribution_1.CommonMenus.FILE, '1_print'];
    // XXX: on macOS, the "Preferences" and "Advanced" group is not under `File`
    // The empty path ensures no top level menu is created for the preferences, even if they contains sub menus
    ArduinoMenus.FILE__PREFERENCES_GROUP = [
        ...(os_1.isOSX ? [''] : common_frontend_contribution_1.CommonMenus.FILE),
        '2_preferences',
    ];
    ArduinoMenus.FILE__ADVANCED_GROUP = [
        ...(os_1.isOSX ? [''] : common_frontend_contribution_1.CommonMenus.FILE),
        '3_advanced',
    ];
    ArduinoMenus.FILE__ADVANCED_SUBMENU = [
        ...ArduinoMenus.FILE__ADVANCED_GROUP,
        '0_advanced_sub',
    ];
    ArduinoMenus.FILE__QUIT_GROUP = [...common_frontend_contribution_1.CommonMenus.FILE, '3_quit'];
    // -- File / Open Recent
    ArduinoMenus.FILE__OPEN_RECENT_SUBMENU = [
        ...ArduinoMenus.FILE__SKETCH_GROUP,
        '0_open_recent',
    ];
    // -- File / Sketchbook
    ArduinoMenus.FILE__SKETCHBOOK_SUBMENU = [
        ...ArduinoMenus.FILE__SKETCH_GROUP,
        '1_sketchbook',
    ];
    // -- File / Examples
    ArduinoMenus.FILE__EXAMPLES_SUBMENU = [...ArduinoMenus.FILE__SKETCH_GROUP, '2_examples'];
    ArduinoMenus.EXAMPLES__BUILT_IN_GROUP = [
        ...ArduinoMenus.FILE__EXAMPLES_SUBMENU,
        '0_built_ins',
    ];
    ArduinoMenus.EXAMPLES__ANY_BOARD_GROUP = [
        ...ArduinoMenus.FILE__EXAMPLES_SUBMENU,
        '1_any_board',
    ];
    ArduinoMenus.EXAMPLES__CURRENT_BOARD_GROUP = [
        ...ArduinoMenus.FILE__EXAMPLES_SUBMENU,
        '2_current_board',
    ];
    ArduinoMenus.EXAMPLES__USER_LIBS_GROUP = [
        ...ArduinoMenus.FILE__EXAMPLES_SUBMENU,
        '3_user_libs',
    ];
    // -- Edit
    // `Copy`, `Copy to Forum`, `Paste`, etc.
    // Note: `1_undo` is the first group from Theia, we start with `2`
    ArduinoMenus.EDIT__TEXT_CONTROL_GROUP = [
        ...common_frontend_contribution_1.CommonMenus.EDIT,
        '2_text_control',
    ];
    // `Comment/Uncomment`, etc.
    ArduinoMenus.EDIT__CODE_CONTROL_GROUP = [
        ...common_frontend_contribution_1.CommonMenus.EDIT,
        '3_code_control',
    ];
    ArduinoMenus.EDIT__FONT_CONTROL_GROUP = [
        ...common_frontend_contribution_1.CommonMenus.EDIT,
        '4_font_control',
    ];
    ArduinoMenus.EDIT__FIND_GROUP = [...common_frontend_contribution_1.CommonMenus.EDIT, '5_find'];
    // -- Sketch
    ArduinoMenus.SKETCH = [...menu_1.MAIN_MENU_BAR, '3_sketch'];
    ArduinoMenus.SKETCH__MAIN_GROUP = [...ArduinoMenus.SKETCH, '0_main'];
    ArduinoMenus.SKETCH__UTILS_GROUP = [...ArduinoMenus.SKETCH, '1_utils'];
    // -- Tools
    ArduinoMenus.TOOLS = [...menu_1.MAIN_MENU_BAR, '4_tools'];
    // `Auto Format`, `Archive Sketch`, `Manage Libraries...`, `Serial Monitor`, Serial Plotter
    ArduinoMenus.TOOLS__MAIN_GROUP = [...ArduinoMenus.TOOLS, '0_main'];
    // `WiFi101 /  WiFiNINA Firmware Updater`
    ArduinoMenus.TOOLS__FIRMWARE_UPLOADER_GROUP = [
        ...ArduinoMenus.TOOLS,
        '1_firmware_uploader',
    ];
    // `Board`, `Port`, and `Get Board Info`.
    ArduinoMenus.TOOLS__BOARD_SELECTION_GROUP = [...ArduinoMenus.TOOLS, '2_board_selection'];
    // Core settings, such as `Processor` and `Programmers` for the board and `Burn Bootloader`
    ArduinoMenus.TOOLS__BOARD_SETTINGS_GROUP = [...ArduinoMenus.TOOLS, '3_board_settings'];
    // -- Help
    // `Getting Started`, `Environment`, `Troubleshooting`, etc.
    ArduinoMenus.HELP__MAIN_GROUP = [...common_frontend_contribution_1.CommonMenus.HELP, '0_main'];
    // `Find in reference`, `FAQ`, etc.
    ArduinoMenus.HELP__FIND_GROUP = [...common_frontend_contribution_1.CommonMenus.HELP, '1_find'];
    // `Advanced Mode`.
    // XXX: this will be removed.
    ArduinoMenus.HELP__CONTROL_GROUP = [...common_frontend_contribution_1.CommonMenus.HELP, '2_control'];
    // `About` group
    // XXX: on macOS, the about group is not under `Help`
    ArduinoMenus.HELP__ABOUT_GROUP = [
        ...(os_1.isOSX ? menu_1.MAIN_MENU_BAR : common_frontend_contribution_1.CommonMenus.HELP),
        '999_about',
    ];
    // ------------
    // Context menus
    // -- Open
    ArduinoMenus.OPEN_SKETCH__CONTEXT = ['arduino-open-sketch--context'];
    ArduinoMenus.OPEN_SKETCH__CONTEXT__OPEN_GROUP = [
        ...ArduinoMenus.OPEN_SKETCH__CONTEXT,
        '0_open',
    ];
    ArduinoMenus.OPEN_SKETCH__CONTEXT__RECENT_GROUP = [
        ...ArduinoMenus.OPEN_SKETCH__CONTEXT,
        '1_recent',
    ];
    ArduinoMenus.OPEN_SKETCH__CONTEXT__EXAMPLES_GROUP = [
        ...ArduinoMenus.OPEN_SKETCH__CONTEXT,
        '2_examples',
    ];
    // -- Sketch control
    ArduinoMenus.SKETCH_CONTROL__CONTEXT = ['arduino-sketch-control--context'];
    // `New Tab`, `Rename`, `Delete`
    ArduinoMenus.SKETCH_CONTROL__CONTEXT__MAIN_GROUP = [
        ...ArduinoMenus.SKETCH_CONTROL__CONTEXT,
        '0_main',
    ];
    // `Previous Tab`, `Next Tab`
    ArduinoMenus.SKETCH_CONTROL__CONTEXT__NAVIGATION_GROUP = [
        ...ArduinoMenus.SKETCH_CONTROL__CONTEXT,
        '1_navigation',
    ];
    // Sketch files opened in editors
    ArduinoMenus.SKETCH_CONTROL__CONTEXT__RESOURCES_GROUP = [
        ...ArduinoMenus.SKETCH_CONTROL__CONTEXT,
        '2_resources',
    ];
    // -- ROOT SSL CERTIFICATES
    ArduinoMenus.ROOT_CERTIFICATES__CONTEXT = [
        'arduino-root-certificates--context',
    ];
})(ArduinoMenus = exports.ArduinoMenus || (exports.ArduinoMenus = {}));
/**
 * This is a hack. It removes a submenu with all its children if any.
 * Theia cannot dispose submenu entries with a proper API: https://github.com/eclipse-theia/theia/issues/7299
 */
function unregisterSubmenu(menuPath, menuRegistry) {
    if (menuPath.length < 2) {
        throw new Error(`Expected at least two item as a menu-path. Got ${JSON.stringify(menuPath)} instead.`);
    }
    const toRemove = menuPath[menuPath.length - 1];
    const parentMenuPath = menuPath.slice(0, menuPath.length - 1);
    // This is unsafe. Calling `getMenu` with a non-existing menu-path will result in a new menu creation.
    // https://github.com/eclipse-theia/theia/issues/7300
    const parent = menuRegistry.getMenu(parentMenuPath);
    const index = parent.children.findIndex(({ id }) => id === toRemove);
    if (index === -1) {
        throw new Error(`Could not find menu with menu-path: ${JSON.stringify(menuPath)}.`);
    }
    parent.children.splice(index, 1);
}
exports.unregisterSubmenu = unregisterSubmenu;
/**
 * Special menu node that is not backed by any commands and is always disabled.
 */
class PlaceholderMenuNode {
    constructor(menuPath, label, options = { order: '0' }) {
        this.menuPath = menuPath;
        this.label = label;
        this.options = options;
    }
    get icon() {
        var _a;
        return (_a = this.options) === null || _a === void 0 ? void 0 : _a.iconClass;
    }
    get sortString() {
        var _a;
        return ((_a = this.options) === null || _a === void 0 ? void 0 : _a.order) || this.label;
    }
    get id() {
        return [...this.menuPath, 'placeholder'].join('-');
    }
}
exports.PlaceholderMenuNode = PlaceholderMenuNode;
//# sourceMappingURL=arduino-menus.js.map