"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitorManagerProxyClientImpl = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
const protocol_1 = require("../common/protocol");
const monitor_service_1 = require("../common/protocol/monitor-service");
const boards_service_provider_1 = require("./boards/boards-service-provider");
let MonitorManagerProxyClientImpl = class MonitorManagerProxyClientImpl {
    constructor(messageService, 
    // This is necessary to call the backend methods from the frontend
    server, commandRegistry, boardsServiceProvider) {
        this.messageService = messageService;
        this.server = server;
        this.commandRegistry = commandRegistry;
        this.boardsServiceProvider = boardsServiceProvider;
        // When pluggable monitor messages are received from the backend
        // this event is triggered.
        // Ideally a frontend component is connected to this event
        // to update the UI.
        this.onMessagesReceivedEmitter = new core_1.Emitter();
        this.onMessagesReceived = this.onMessagesReceivedEmitter.event;
        this.onMonitorSettingsDidChangeEmitter = new core_1.Emitter();
        this.onMonitorSettingsDidChange = this.onMonitorSettingsDidChangeEmitter.event;
        this.onMonitorShouldResetEmitter = new core_1.Emitter();
        this.onMonitorShouldReset = this.onMonitorShouldResetEmitter.event;
    }
    getWebSocketPort() {
        return this.wsPort;
    }
    /**
     * Connects a localhost WebSocket using the specified port.
     * @param addressPort port of the WebSocket
     */
    async connect(addressPort) {
        if (!!this.webSocket) {
            if (this.wsPort === addressPort)
                return;
            else
                this.disconnect();
        }
        try {
            this.webSocket = new WebSocket(`ws://localhost:${addressPort}`);
        }
        catch (_a) {
            this.messageService.error(core_1.nls.localize('arduino/monitor/unableToConnectToWebSocket', 'Unable to connect to websocket'));
            return;
        }
        this.webSocket.onmessage = (message) => {
            const parsedMessage = JSON.parse(message.data);
            if (Array.isArray(parsedMessage))
                this.onMessagesReceivedEmitter.fire({ messages: parsedMessage });
            else if (parsedMessage.command ===
                monitor_service_1.Monitor.MiddlewareCommand.ON_SETTINGS_DID_CHANGE) {
                this.onMonitorSettingsDidChangeEmitter.fire(parsedMessage.data);
            }
        };
        this.wsPort = addressPort;
    }
    /**
     * Disconnects the WebSocket if connected.
     */
    disconnect() {
        var _a, _b;
        if (!this.webSocket)
            return;
        (_a = this.onBoardsConfigChanged) === null || _a === void 0 ? void 0 : _a.dispose();
        this.onBoardsConfigChanged = undefined;
        try {
            (_b = this.webSocket) === null || _b === void 0 ? void 0 : _b.close();
            this.webSocket = undefined;
        }
        catch (_c) {
            this.messageService.error(core_1.nls.localize('arduino/monitor/unableToCloseWebSocket', 'Unable to close websocket'));
        }
    }
    async isWSConnected() {
        return !!this.webSocket;
    }
    async startMonitor(settings) {
        this.lastConnectedBoard = {
            selectedBoard: this.boardsServiceProvider.boardsConfig.selectedBoard,
            selectedPort: this.boardsServiceProvider.boardsConfig.selectedPort,
        };
        if (!this.onBoardsConfigChanged) {
            this.onBoardsConfigChanged =
                this.boardsServiceProvider.onBoardsConfigChanged(async ({ selectedBoard, selectedPort }) => {
                    var _a, _b;
                    if (typeof selectedBoard === 'undefined' ||
                        typeof selectedPort === 'undefined')
                        return;
                    // a board is plugged and it's different from the old connected board
                    if ((selectedBoard === null || selectedBoard === void 0 ? void 0 : selectedBoard.fqbn) !==
                        ((_b = (_a = this.lastConnectedBoard) === null || _a === void 0 ? void 0 : _a.selectedBoard) === null || _b === void 0 ? void 0 : _b.fqbn) ||
                        protocol_1.Port.keyOf(selectedPort) !==
                            (this.lastConnectedBoard.selectedPort
                                ? protocol_1.Port.keyOf(this.lastConnectedBoard.selectedPort)
                                : undefined)) {
                        this.onMonitorShouldResetEmitter.fire(null);
                        this.lastConnectedBoard = {
                            selectedBoard: selectedBoard,
                            selectedPort: selectedPort,
                        };
                    }
                    else {
                        // a board is plugged and it's the same as prev, rerun "this.startMonitor" to
                        // recreate the listener callback
                        this.startMonitor();
                    }
                });
        }
        const { selectedBoard, selectedPort } = this.boardsServiceProvider.boardsConfig;
        if (!selectedBoard || !selectedBoard.fqbn || !selectedPort)
            return;
        await this.server().startMonitor(selectedBoard, selectedPort, settings);
    }
    getCurrentSettings(board, port) {
        return this.server().getCurrentSettings(board, port);
    }
    send(message) {
        if (!this.webSocket) {
            return;
        }
        this.webSocket.send(JSON.stringify({
            command: monitor_service_1.Monitor.ClientCommand.SEND_MESSAGE,
            data: message,
        }));
    }
    changeSettings(settings) {
        if (!this.webSocket) {
            return;
        }
        this.webSocket.send(JSON.stringify({
            command: monitor_service_1.Monitor.ClientCommand.CHANGE_SETTINGS,
            data: settings,
        }));
    }
};
MonitorManagerProxyClientImpl = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(core_1.MessageService)),
    __param(1, (0, inversify_1.inject)(monitor_service_1.MonitorManagerProxyFactory)),
    __param(2, (0, inversify_1.inject)(core_1.CommandRegistry)),
    __param(3, (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider)),
    __metadata("design:paramtypes", [core_1.MessageService, Function, core_1.CommandRegistry,
        boards_service_provider_1.BoardsServiceProvider])
], MonitorManagerProxyClientImpl);
exports.MonitorManagerProxyClientImpl = MonitorManagerProxyClientImpl;
//# sourceMappingURL=monitor-manager-proxy-client-impl.js.map