"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MonitorModel_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitorModel = void 0;
const core_1 = require("@theia/core");
const browser_1 = require("@theia/core/lib/browser");
const inversify_1 = require("@theia/core/shared/inversify");
const protocol_1 = require("../common/protocol");
const utils_1 = require("../common/utils");
let MonitorModel = MonitorModel_1 = class MonitorModel {
    constructor() {
        this.onMonitorSettingsDidChange = (settings) => {
            const { monitorUISettings } = settings;
            if (!monitorUISettings)
                return;
            const { autoscroll, interpolate, lineEnding, timestamp, darkTheme, wsPort, serialPort, connected, } = monitorUISettings;
            if (!(0, utils_1.isNullOrUndefined)(autoscroll))
                this.autoscroll = autoscroll;
            if (!(0, utils_1.isNullOrUndefined)(interpolate))
                this.interpolate = interpolate;
            if (!(0, utils_1.isNullOrUndefined)(lineEnding))
                this.lineEnding = lineEnding;
            if (!(0, utils_1.isNullOrUndefined)(timestamp))
                this.timestamp = timestamp;
            if (!(0, utils_1.isNullOrUndefined)(darkTheme))
                this.darkTheme = darkTheme;
            if (!(0, utils_1.isNullOrUndefined)(wsPort))
                this.wsPort = wsPort;
            if (!(0, utils_1.isNullOrUndefined)(serialPort))
                this.serialPort = serialPort;
            if (!(0, utils_1.isNullOrUndefined)(connected))
                this.connected = connected;
        };
        this._autoscroll = true;
        this._timestamp = false;
        this._interpolate = false;
        this._lineEnding = MonitorModel_1.EOL.DEFAULT;
        this._darkTheme = false;
        this._wsPort = 0;
        this._serialPort = '';
        this._connected = true;
        this.onChangeEmitter = new core_1.Emitter();
    }
    onStart() {
        this.localStorageService
            .getData(MonitorModel_1.STORAGE_ID)
            .then(this.restoreState.bind(this));
        this.monitorManagerProxy.onMonitorSettingsDidChange(this.onMonitorSettingsDidChange.bind(this));
    }
    get onChange() {
        return this.onChangeEmitter.event;
    }
    restoreState(state) {
        if (!state) {
            return;
        }
        this._autoscroll = state.autoscroll;
        this._timestamp = state.timestamp;
        this._lineEnding = state.lineEnding;
        this._interpolate = state.interpolate;
        this._serialPort = state.serialPort;
    }
    async storeState() {
        return this.localStorageService.setData(MonitorModel_1.STORAGE_ID, {
            autoscroll: this._autoscroll,
            timestamp: this._timestamp,
            lineEnding: this._lineEnding,
            interpolate: this._interpolate,
            serialPort: this._serialPort,
        });
    }
    get autoscroll() {
        return this._autoscroll;
    }
    set autoscroll(autoscroll) {
        if (autoscroll === this._autoscroll)
            return;
        this._autoscroll = autoscroll;
        this.monitorManagerProxy.changeSettings({
            monitorUISettings: { autoscroll },
        });
        this.storeState().then(() => {
            this.onChangeEmitter.fire({
                property: 'autoscroll',
                value: this._autoscroll,
            });
        });
    }
    toggleAutoscroll() {
        this.autoscroll = !this._autoscroll;
    }
    get timestamp() {
        return this._timestamp;
    }
    set timestamp(timestamp) {
        if (timestamp === this._timestamp)
            return;
        this._timestamp = timestamp;
        this.monitorManagerProxy.changeSettings({
            monitorUISettings: { timestamp },
        });
        this.storeState().then(() => this.onChangeEmitter.fire({
            property: 'timestamp',
            value: this._timestamp,
        }));
    }
    toggleTimestamp() {
        this.timestamp = !this._timestamp;
    }
    get lineEnding() {
        return this._lineEnding;
    }
    set lineEnding(lineEnding) {
        if (lineEnding === this._lineEnding)
            return;
        this._lineEnding = lineEnding;
        this.monitorManagerProxy.changeSettings({
            monitorUISettings: { lineEnding },
        });
        this.storeState().then(() => this.onChangeEmitter.fire({
            property: 'lineEnding',
            value: this._lineEnding,
        }));
    }
    get interpolate() {
        return this._interpolate;
    }
    set interpolate(interpolate) {
        if (interpolate === this._interpolate)
            return;
        this._interpolate = interpolate;
        this.monitorManagerProxy.changeSettings({
            monitorUISettings: { interpolate },
        });
        this.storeState().then(() => this.onChangeEmitter.fire({
            property: 'interpolate',
            value: this._interpolate,
        }));
    }
    get darkTheme() {
        return this._darkTheme;
    }
    set darkTheme(darkTheme) {
        if (darkTheme === this._darkTheme)
            return;
        this._darkTheme = darkTheme;
        this.monitorManagerProxy.changeSettings({
            monitorUISettings: { darkTheme },
        });
        this.onChangeEmitter.fire({
            property: 'darkTheme',
            value: this._darkTheme,
        });
    }
    get wsPort() {
        return this._wsPort;
    }
    set wsPort(wsPort) {
        if (wsPort === this._wsPort)
            return;
        this._wsPort = wsPort;
        this.monitorManagerProxy.changeSettings({
            monitorUISettings: { wsPort },
        });
        this.onChangeEmitter.fire({
            property: 'wsPort',
            value: this._wsPort,
        });
    }
    get serialPort() {
        return this._serialPort;
    }
    set serialPort(serialPort) {
        if (serialPort === this._serialPort)
            return;
        this._serialPort = serialPort;
        this.monitorManagerProxy.changeSettings({
            monitorUISettings: { serialPort },
        });
        this.storeState().then(() => this.onChangeEmitter.fire({
            property: 'serialPort',
            value: this._serialPort,
        }));
    }
    get connected() {
        return this._connected;
    }
    set connected(connected) {
        if (connected === this._connected)
            return;
        this._connected = connected;
        this.monitorManagerProxy.changeSettings({
            monitorUISettings: { connected },
        });
        this.onChangeEmitter.fire({
            property: 'connected',
            value: this._connected,
        });
    }
};
MonitorModel.STORAGE_ID = 'arduino-monitor-model';
__decorate([
    (0, inversify_1.inject)(browser_1.LocalStorageService),
    __metadata("design:type", browser_1.LocalStorageService)
], MonitorModel.prototype, "localStorageService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.MonitorManagerProxyClient),
    __metadata("design:type", Object)
], MonitorModel.prototype, "monitorManagerProxy", void 0);
MonitorModel = MonitorModel_1 = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], MonitorModel);
exports.MonitorModel = MonitorModel;
// TODO: Move this to /common
(function (MonitorModel) {
    let EOL;
    (function (EOL) {
        EOL.DEFAULT = '\n';
    })(EOL = MonitorModel.EOL || (MonitorModel.EOL = {}));
})(MonitorModel = exports.MonitorModel || (exports.MonitorModel = {}));
exports.MonitorModel = MonitorModel;
//# sourceMappingURL=monitor-model.js.map