"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationCenter = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const event_1 = require("@theia/core/lib/common/event");
const disposable_1 = require("@theia/core/lib/common/disposable");
const notification_service_1 = require("../common/protocol/notification-service");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
let NotificationCenter = class NotificationCenter {
    constructor() {
        this.indexDidUpdateEmitter = new event_1.Emitter();
        this.indexWillUpdateEmitter = new event_1.Emitter();
        this.indexUpdateDidProgressEmitter = new event_1.Emitter();
        this.indexUpdateDidFailEmitter = new event_1.Emitter();
        this.daemonDidStartEmitter = new event_1.Emitter();
        this.daemonDidStopEmitter = new event_1.Emitter();
        this.configDidChangeEmitter = new event_1.Emitter();
        this.platformDidInstallEmitter = new event_1.Emitter();
        this.platformDidUninstallEmitter = new event_1.Emitter();
        this.libraryDidInstallEmitter = new event_1.Emitter();
        this.libraryDidUninstallEmitter = new event_1.Emitter();
        this.attachedBoardsDidChangeEmitter = new event_1.Emitter();
        this.recentSketchesChangedEmitter = new event_1.Emitter();
        this.onAppStateDidChangeEmitter = new event_1.Emitter();
        this.toDispose = new disposable_1.DisposableCollection(this.indexWillUpdateEmitter, this.indexUpdateDidProgressEmitter, this.indexDidUpdateEmitter, this.indexUpdateDidFailEmitter, this.daemonDidStartEmitter, this.daemonDidStopEmitter, this.configDidChangeEmitter, this.platformDidInstallEmitter, this.platformDidUninstallEmitter, this.libraryDidInstallEmitter, this.libraryDidUninstallEmitter, this.attachedBoardsDidChangeEmitter);
        this.onIndexDidUpdate = this.indexDidUpdateEmitter.event;
        this.onIndexWillUpdate = this.indexDidUpdateEmitter.event;
        this.onIndexUpdateDidProgress = this.indexUpdateDidProgressEmitter.event;
        this.onIndexUpdateDidFail = this.indexUpdateDidFailEmitter.event;
        this.onDaemonDidStart = this.daemonDidStartEmitter.event;
        this.onDaemonDidStop = this.daemonDidStopEmitter.event;
        this.onConfigDidChange = this.configDidChangeEmitter.event;
        this.onPlatformDidInstall = this.platformDidInstallEmitter.event;
        this.onPlatformDidUninstall = this.platformDidUninstallEmitter.event;
        this.onLibraryDidInstall = this.libraryDidInstallEmitter.event;
        this.onLibraryDidUninstall = this.libraryDidUninstallEmitter.event;
        this.onAttachedBoardsDidChange = this.attachedBoardsDidChangeEmitter.event;
        this.onRecentSketchesDidChange = this.recentSketchesChangedEmitter.event;
        this.onAppStateDidChange = this.onAppStateDidChangeEmitter.event;
    }
    init() {
        this.server.setClient(this);
        this.toDispose.push(this.appStateService.onStateChanged((state) => this.onAppStateDidChangeEmitter.fire(state)));
    }
    onStop() {
        this.toDispose.dispose();
    }
    notifyIndexWillUpdate(progressId) {
        this.indexWillUpdateEmitter.fire(progressId);
    }
    notifyIndexUpdateDidProgress(progressMessage) {
        this.indexUpdateDidProgressEmitter.fire(progressMessage);
    }
    notifyIndexDidUpdate(progressId) {
        this.indexDidUpdateEmitter.fire(progressId);
    }
    notifyIndexUpdateDidFail({ progressId, message, }) {
        this.indexUpdateDidFailEmitter.fire({ progressId, message });
    }
    notifyDaemonDidStart(port) {
        this.daemonDidStartEmitter.fire(port);
    }
    notifyDaemonDidStop() {
        this.daemonDidStopEmitter.fire();
    }
    notifyConfigDidChange(event) {
        this.configDidChangeEmitter.fire(event);
    }
    notifyPlatformDidInstall(event) {
        this.platformDidInstallEmitter.fire(event);
    }
    notifyPlatformDidUninstall(event) {
        this.platformDidUninstallEmitter.fire(event);
    }
    notifyLibraryDidInstall(event) {
        this.libraryDidInstallEmitter.fire(event);
    }
    notifyLibraryDidUninstall(event) {
        this.libraryDidUninstallEmitter.fire(event);
    }
    notifyAttachedBoardsDidChange(event) {
        this.attachedBoardsDidChangeEmitter.fire(event);
    }
    notifyRecentSketchesDidChange(event) {
        this.recentSketchesChangedEmitter.fire(event);
    }
};
__decorate([
    (0, inversify_1.inject)(notification_service_1.NotificationServiceServer),
    __metadata("design:type", Object)
], NotificationCenter.prototype, "server", void 0);
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], NotificationCenter.prototype, "appStateService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], NotificationCenter.prototype, "init", null);
NotificationCenter = __decorate([
    (0, inversify_1.injectable)()
], NotificationCenter);
exports.NotificationCenter = NotificationCenter;
//# sourceMappingURL=notification-center.js.map