"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseServiceImpl = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const event_1 = require("@theia/core/lib/common/event");
const output_channel_1 = require("@theia/output/lib/browser/output-channel");
const response_service_1 = require("../common/protocol/response-service");
let ResponseServiceImpl = class ResponseServiceImpl {
    constructor() {
        this.progressDidChangeEmitter = new event_1.Emitter();
        this.onProgressDidChange = this.progressDidChangeEmitter.event;
    }
    clearOutput() {
        this.outputChannelManager.getChannel('Arduino').clear();
    }
    appendToOutput(message) {
        const { chunk, severity } = message;
        const channel = this.outputChannelManager.getChannel('Arduino');
        channel.show({ preserveFocus: true });
        channel.append(chunk, mapSeverity(severity));
    }
    reportProgress(progress) {
        this.progressDidChangeEmitter.fire(progress);
    }
};
__decorate([
    (0, inversify_1.inject)(output_channel_1.OutputChannelManager),
    __metadata("design:type", output_channel_1.OutputChannelManager)
], ResponseServiceImpl.prototype, "outputChannelManager", void 0);
ResponseServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], ResponseServiceImpl);
exports.ResponseServiceImpl = ResponseServiceImpl;
function mapSeverity(severity) {
    if (severity === response_service_1.OutputMessage.Severity.Error) {
        return output_channel_1.OutputChannelSeverity.Error;
    }
    else if (severity === response_service_1.OutputMessage.Severity.Warning) {
        return output_channel_1.OutputChannelSeverity.Warning;
    }
    return output_channel_1.OutputChannelSeverity.Info;
}
//# sourceMappingURL=response-service-impl.js.map